package com.biz.crm.dms.business.policy.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutorLadderGift;
import com.biz.crm.dms.business.policy.local.mapper.SalePolicyExecutorLadderGiftMapper;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

/**
 * 和标品中默认的优惠政策执行阶梯信息有关的赠品数据层功能汇总
 * @author yinwenjie
 */
@Component
public class SalePolicyExecutorLadderGiftRepository extends ServiceImpl<SalePolicyExecutorLadderGiftMapper, SalePolicyExecutorLadderGift> {
  /**
   * 按照阶梯信息，删除这个阶梯涉及到的所有
   * @param executorLadderIds
   */
  public void deleteByExecutorLadderIds(String[] executorLadderIds) {
    if(executorLadderIds == null || executorLadderIds.length == 0) {
      return;
    }
    LambdaQueryWrapper<SalePolicyExecutorLadderGift> lambdaQuery = Wrappers.<SalePolicyExecutorLadderGift>lambdaQuery();
    lambdaQuery.in(SalePolicyExecutorLadderGift::getExecutorLadderId, Lists.newArrayList(executorLadderIds));
    this.baseMapper.delete(lambdaQuery);
  }
}
