package com.biz.crm.dms.business.policy.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutorLadder;
import com.biz.crm.dms.business.policy.local.mapper.SalePolicyExecutorLadderMapper;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 和标品中默认的优惠政策执行阶梯信息有关的数据层功能汇总
 * @author yinwenjie
 */
@Component
public class SalePolicyExecutorLadderRepository extends ServiceImpl<SalePolicyExecutorLadderMapper, SalePolicyExecutorLadder> {
  
  /**
   * 根据一组优惠政策执行信息的技术变化，对符合条件的优惠政策执行阶梯信息进行查询
   * @param salePolicyExecutorIds 
   * @return
   */
  public List<SalePolicyExecutorLadder> findBySalePolicyExecutorIds(String[] salePolicyExecutorIds) {
    if(salePolicyExecutorIds == null || salePolicyExecutorIds.length == 0) {
      return null;
    }
    return this.lambdaQuery().in(SalePolicyExecutorLadder::getSalePolicyExecutorId, Lists.newArrayList(salePolicyExecutorIds)).list();
  }
  
  /**
   * 按照解体信息关联的优惠政策执行信息，进行查处
   * @param salePolicyExecutorIds 可以是一个或者多个执行器的技术编号
   */
  public void deleteBySalePolicyExecutorIds(String[] salePolicyExecutorIds) {
    if(salePolicyExecutorIds == null || salePolicyExecutorIds.length == 0) {
      return;
    }
    LambdaQueryWrapper<SalePolicyExecutorLadder> lambdaQuery = Wrappers.<SalePolicyExecutorLadder>lambdaQuery();
    lambdaQuery.in(SalePolicyExecutorLadder::getSalePolicyExecutorId, Lists.newArrayList(salePolicyExecutorIds));
    this.baseMapper.delete(lambdaQuery);
  }
}
