package com.biz.crm.dms.business.policy.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyLimit;
import com.biz.crm.dms.business.policy.local.mapper.SalePolicyLimitMapper;

import java.util.Set;

import org.springframework.stereotype.Component;

/**
 * 和标品中默认的优惠政策限量门槛信息有关的数据层功能汇总
 * @author yinwenjie
 */
@Component
public class SalePolicyLimitRepository extends ServiceImpl<SalePolicyLimitMapper, SalePolicyLimit> {
  
  /**
   * 按照优惠政策业务编码和二级租户信息、限量政策业务编号进行已有限量信息的刪除操作
   * @param ids ID集合
   */
  public void deleteByIds(Set<String> ids) {
    LambdaQueryWrapper<SalePolicyLimit> lambdaQuery = Wrappers.<SalePolicyLimit>lambdaQuery();
    lambdaQuery.in(SalePolicyLimit::getId, ids);
    this.baseMapper.delete(lambdaQuery);
  }
}
