package com.biz.crm.dms.business.policy.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyProduct;
import com.biz.crm.dms.business.policy.local.mapper.SalePolicyProductMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

@Component
public class SalePolicyProductRepository extends ServiceImpl<SalePolicyProductMapper, SalePolicyProduct> {
  @Autowired(required = false)
  private SalePolicyProductJpaRepository salePolicyProductJpaRepository;
  
  /**
   * 基于二级租户信息，查询指定优惠政策下的指定商品本品信息
   * @param salePolicyCode 优惠政策的业务编号
   * @param productCode 指定的商品本品信息
   * @param tenantCode 当前二级租户的业务编号
   * @return
   */
  public SalePolicyProduct findBySalePolicyCodeAndProductCodeAndTenantCode(String salePolicyCode , String productCode , String tenantCode) {
    SalePolicyProduct salePolicyProduct = this.lambdaQuery()
        .eq(SalePolicyProduct::getSalePolicyCode , salePolicyCode)
        .eq(SalePolicyProduct::getProductCode, productCode)
        .eq(SalePolicyProduct::getTenantCode, tenantCode).one();
    return salePolicyProduct;
  }
  
  /**
   * 按照指定的门槛涉及的优惠政策业务编号信息，进行商品本品信息的查询(可能是多个)
   * @param salePolicyCode 指定的优惠政策业务编号 
   * @return
   */
  public List<SalePolicyProduct> findBySalePolicyCode(String salePolicyCode , String tenantCode) {
    return this.salePolicyProductJpaRepository.findBySalePolicyCode(salePolicyCode, tenantCode);
  }
  
  /**
   * 按照优惠政策中的商品明细信息，进行删除
   */
  public void deleteByIds(Set<String> ids) {
    LambdaQueryWrapper<SalePolicyProduct> lambdaQuery = Wrappers.<SalePolicyProduct>lambdaQuery();
    lambdaQuery.in(SalePolicyProduct::getId, ids);
    this.baseMapper.delete(lambdaQuery);
  }
}
