package com.biz.crm.dms.business.policy.local.repository;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecord;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * 利用JPA完成的数据持久层查询（和优惠政策流水信息有关）
 * @author: yinwenjie
 * @version 2.0
 */
@Repository
public interface SalePolicyRecordJpaRepository
        extends 
        JpaRepository<SalePolicyRecord, String>,
        JpaSpecificationExecutor<SalePolicyRecord> {
  
  /**
   * 按照指定的单据编号、客户编号、租户编号，查询优惠政策执行的历史流水信息
   * @return
   */
  @Query("from SalePolicyRecord s "
      + " left join fetch s.salePolicyRecordProductSelectedPolicys spsl "
      + " left join fetch s.salePolicyRecordStepPolicys stp "
      + " left join fetch s.salePolicyRecordExcludePolicys spe "
      + " left join fetch s.salePolicyRecordProducts sps  "
      + " left join fetch sps.salePolicyRecordGifts spsg "
      + " where s.billCode = :billCode and s.customerCode = :customerCode and s.tenantCode = :tenantCode ")
  SalePolicyRecord findByBillCodeAndTenantCodeAndTenantCode(@Param("billCode") String billCode, @Param("customerCode") String customerCode, @Param("tenantCode") String tenantCode);

  /**
   * 按照指定的维度，查询优惠政策执行的历史流水信息
   * @param tenantCode 租户编码
   * @param salePolicyCode 促销政策编码
   * @return SalePolicyRecord
   */
  @Query("select distinct s from SalePolicyRecord s left join fetch s.salePolicyRecordProducts sps  "
      + " where s.tenantCode = :tenantCode and sps.salePolicyCode = :salePolicyCode ")
  Set<SalePolicyRecord> findByTenantCodeAndSalePolicyCode(@Param("tenantCode") String tenantCode, @Param("salePolicyCode") String salePolicyCode);

  /**
   * 按照指定的维度，查询优惠政策执行的历史流水信息
   * @param tenantCode 租户编码
   * @param salePolicyCode 促销政策编码
   * @param customerCode 客户编号
   * @return SalePolicyRecord
   */
  @Query("select distinct s from SalePolicyRecord s left join fetch s.salePolicyRecordProducts sps  "
      + " where s.tenantCode = :tenantCode and sps.salePolicyCode = :salePolicyCode and s.customerCode = :customerCode ")
  Set<SalePolicyRecord> findByTenantCodeAndSalePolicyCodeAndCustomerCode(@Param("tenantCode") String tenantCode, @Param("salePolicyCode") String salePolicyCode, @Param("customerCode") String customerCode);

  /**
   * 按照指定的维度，查询优惠政策执行的历史流水信息
   * @param tenantCode 租户编码
   * @param salePolicyCode 促销政策编码
   * @param customerCode 客户编号
   * @param billCode 单据编号
   * @return SalePolicyRecord
   */
  @Query("select distinct s from SalePolicyRecord s left join fetch s.salePolicyRecordProducts sps  "
      + " where s.tenantCode = :tenantCode and sps.salePolicyCode = :salePolicyCode and s.customerCode = :customerCode and s.billCode = :billCode ")
  Set<SalePolicyRecord> findByTenantCodeAndSalePolicyCodeAndCustomerCodeAndBillCode(@Param("tenantCode") String tenantCode, @Param("salePolicyCode") String salePolicyCode, @Param("customerCode") String customerCode, @Param("billCode") String billCode);
}
