package com.biz.crm.dms.business.policy.local.repository;

import java.util.Set;

import org.springframework.stereotype.Component;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecordProductSelectedPolicy;
import com.biz.crm.dms.business.policy.local.mapper.SalePolicyRecordProductSelectedPolicyMapper;

/**
 * @author yinwenjie
 */
@Component
public class SalePolicyRecordProductSelectedPolicyRepository extends ServiceImpl<SalePolicyRecordProductSelectedPolicyMapper, SalePolicyRecordProductSelectedPolicy> {
  /**
   * 按照促销政策/优惠政策使用记录ID进行优惠政策选定信息的删除
   * @param recordIds
   */
  public void deleteByIds(Set<String> recordIds) {
    LambdaQueryWrapper<SalePolicyRecordProductSelectedPolicy> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.in(SalePolicyRecordProductSelectedPolicy::getRecordId, recordIds);
    this.baseMapper.delete(lambdaQuery);
  }
}