package com.biz.crm.dms.business.policy.local.repository;

import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Component;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecord;
import com.biz.crm.dms.business.policy.local.mapper.SalePolicyRecordMapper;

/**
 * 促销政策/优惠政策使用记录表的数据层功能汇总
 * @author pengxi yinwenjie
 * @date 2022/01/14
 */
@Component
public class SalePolicyRecordRepository extends ServiceImpl<SalePolicyRecordMapper, SalePolicyRecord> {
  
  @Autowired(required = false)
  private SalePolicyRecordJpaRepository salePolicyRecordJpaRepository;
  
  public SalePolicyRecord findByBillCodeAndTenantCodeAndTenantCode(@Param("billCode") String billCode, @Param("customerCode") String customerCode, @Param("tenantCode") String tenantCode) {
    return this.salePolicyRecordJpaRepository.findByBillCodeAndTenantCodeAndTenantCode(billCode, customerCode, tenantCode);
  }

  public Set<SalePolicyRecord> findByTenantCodeAndSalePolicyCode(@Param("tenantCode") String tenantCode, @Param("salePolicyCode") String salePolicyCode) {
    return this.salePolicyRecordJpaRepository.findByTenantCodeAndSalePolicyCode(tenantCode, salePolicyCode);
  }

  public Set<SalePolicyRecord> findByTenantCodeAndSalePolicyCodeAndCustomerCode(@Param("tenantCode") String tenantCode, @Param("salePolicyCode") String salePolicyCode, @Param("customerCode") String customerCode) {
    return this.salePolicyRecordJpaRepository.findByTenantCodeAndSalePolicyCodeAndCustomerCode(tenantCode, salePolicyCode, customerCode);
  }

  public Set<SalePolicyRecord> findByTenantCodeAndSalePolicyCodeAndCustomerCodeAndBillCode(@Param("tenantCode") String tenantCode, @Param("salePolicyCode") String salePolicyCode, @Param("customerCode") String customerCode, @Param("billCode") String billCode) {
    return this.salePolicyRecordJpaRepository.findByTenantCodeAndSalePolicyCodeAndCustomerCodeAndBillCode(tenantCode, salePolicyCode, customerCode, billCode);
  }

  /**
   * 按照id集合进行已有记录信息的刪除操作
   * @param ids id集合
   */
  public void deleteByIds(Set<String> ids) {
    LambdaQueryWrapper<SalePolicyRecord> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.in(SalePolicyRecord::getId, ids);
    this.baseMapper.delete(lambdaQuery);
  }
}