package com.biz.crm.dms.business.policy.local.repository;

import org.springframework.stereotype.Component;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecordStepPolicy;
import com.biz.crm.dms.business.policy.local.mapper.SalePolicyRecordStepPolicyMapper;

/**
 * 促销政策/优惠政策执行顺序流程的数据层功能汇总
 * @author  yinwenjie
 * @date 2022/02/14
 */
@Component
public class SalePolicyRecordStepPolicyRepository extends ServiceImpl<SalePolicyRecordStepPolicyMapper, SalePolicyRecordStepPolicy> {
  /**
   * 按照促销政策/优惠政策使用记录ID，进行已有本品步进记录的刪除操作
   * @param recordId 促销政策/优惠政策使用记录ID
   */
  public void deleteByRecordId(String recordId) {
    LambdaQueryWrapper<SalePolicyRecordStepPolicy> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(SalePolicyRecordStepPolicy::getRecordId, recordId);
    this.baseMapper.delete(lambdaQuery);
  }
}