package com.biz.crm.dms.business.policy.local.repository;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyTemplete;

import java.util.List;
import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * 利用JPA完成的数据持久层查询（和优惠政策模板信息有关）
 * @author: yinwenjie
 * @version 2.0
 */
@Repository
public interface SalePolicyTempleteJpaRepository
        extends 
        JpaRepository<SalePolicyTemplete, String>,
        JpaSpecificationExecutor<SalePolicyTemplete> {
  
  /**
   * 按照二级租户查询已经常见的所有优惠政策模板（按照创建时间排序）
   * @param tenantCode
   * @return
   */
  @Query("from SalePolicyTemplete s "
      + " left join fetch s.bindingExecuteStraties sb "
      + " where s.tenantCode = :tenantCode "
      + " order by s.createTime desc ")
  public Set<SalePolicyTemplete> findByTenantCode(@Param("tenantCode") String tenantCode);
  
  /**
   * 按照二级租户查询已经常见的所有优惠政策模板（按照创建时间排序）
   * @param tenantCode
   * @param enableStatus 优惠政策模板的启用/禁用状态
   * @return
   */
  @Query("from SalePolicyTemplete s "
      + " left join fetch s.bindingExecuteStraties sb "
      + " where s.tenantCode = :tenantCode AND s.enableStatus = :enableStatus "
      + " order by s.createTime desc ")
  public Set<SalePolicyTemplete> findByTenantCodeAndEnableStatus(@Param("tenantCode") String tenantCode ,@Param("enableStatus") String enableStatus);
  
  /**
   * 按照二级租户查询已经常见的所有优惠政策模板（按照创建时间排序）
   * @param tenantCode
   * @return
   */
  @Query("from SalePolicyTemplete s "
      + " left join fetch s.bindingExecuteStraties sb "
      + " where s.tenantCode = :tenantCode and s.templeteCode = :templeteCode ")
  public SalePolicyTemplete findByTempleteCode(@Param("templeteCode") String templeteCode , @Param("tenantCode") String tenantCode);
  
  @Query("from SalePolicyTemplete s "
      + " left join fetch s.bindingExecuteStraties sb "
      + " where s.tenantCode = :tenantCode and s.templeteCode in (:templeteCodes) ")
  public Set<SalePolicyTemplete> findByTempleteCodes(@Param("templeteCodes") List<String> templeteCodes , @Param("tenantCode") String tenantCode);
  
  @Modifying
  @Query("delete from SalePolicyTemplete s where s.templeteCode = :templeteCode and s.tenantCode = :tenantCode ")
  public void deleteByTempleteCode(@Param("templeteCode") String templeteCode , @Param("tenantCode") String tenantCode);
}
