package com.biz.crm.dms.business.policy.local.repository;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyThresholdDetail;

import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * 利用JPA完成的数据持久层查询
 * @author: yinwenjie
 * @version 2.0
 */
@Repository
public interface SalePolicyThresholdDetailJpaRepository
        extends 
        JpaRepository<SalePolicyThresholdDetail, String>,
        JpaSpecificationExecutor<SalePolicyThresholdDetail> {
  
  /**
   * 按照优惠政策业务编号和特定的门槛明细业务编号进行查询
   * @param salePolicyCode 指定的优惠政策业务编号
   * @param thresholdDetailCode 指定的门槛明细业务编号
   */
  @Query("from SalePolicyThresholdDetail td "
      + " inner join td.salePolicyThreshold s "
      + " where s.tenantCode = :tenantCode and s.salePolicyCode = :salePolicyCode AND td.thresholdDetailCode = :thresholdDetailCode ")
  public SalePolicyThresholdDetail findBySalePolicyCodeAndThresholdDetailCode(@Param("salePolicyCode") String salePolicyCode, @Param("tenantCode") String tenantCode , @Param("thresholdDetailCode") String thresholdDetailCode);
  
  /**
   * 按照指定的门槛信息业务编号信息，进行门槛详情信息的查询(这里没有关联信息)
   * @param thresholdCode  指定的门槛业务编号
   */
  @Query("select distinct td from SalePolicyThresholdDetail td "
      + " inner join fetch td.salePolicyThreshold s "
      + " where s.tenantCode = :tenantCode and s.salePolicyCode = :salePolicyCode ")
  public Set<SalePolicyThresholdDetail> findBySalePolicyCode(@Param("salePolicyCode") String salePolicyCode, @Param("tenantCode") String tenantCode);
}
