package com.biz.crm.dms.business.policy.local.service;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutor;

import java.util.List;

/**
 * 该服务接口面向SalePolicyExecutor实体
 * @author yinwenjie
 */
public interface SalePolicyExecutorService {
  /**
   * 为特定的优惠政策添加优惠政策执行信息（无论是什么样的优惠政策，都会有执行器）
   * @return
   */
  public void create(SalePolicyExecutor salePolicyExecutor);
  
  /**
   * 查询特定二级租户下的特定优惠政策信息(可能有多个执行策略器)
   * @param salePolicyCode 指定的优惠政策二级业务编码
   * @param tenantCode 指定的二级租户信息
   * @param executeStrategyCode 特定的执行策略业务编号
   * @return
   */
  public List<SalePolicyExecutor> findBySalePolicyCodeAndTenantCode(String salePolicyCode, String tenantCode , String executeStrategyCode);
}
