package com.biz.crm.dms.business.policy.local.service;

import java.util.Set;

import org.springframework.data.domain.Pageable;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.policy.sdk.dto.SalePolicyTempletePageDto;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyTempleteVo;

/**
 * 优惠政策模板的业务层服务
 * @author yinwenjie
 */
public interface SalePolicyTempleteVoService {
  /**
   * 创建一个新的优惠政策模板
   * @param salePolicyTemplete 优惠政策模板VO层对象
   * @return
   */
  public SalePolicyTempleteVo create(SalePolicyTempleteVo salePolicyTemplete);
  
  /**
   * 对特定的优惠政策模板进行修改（注意，就该操作并不会影响根据这个优惠政策模板已经创建的优惠政策信息）
   * @param salePolicyTemplete
   * @return
   */
  public SalePolicyTempleteVo update(SalePolicyTempleteVo salePolicyTemplete);
  /**
   * 将指定的促销政策模板禁用（也就是将enableStatus标记设置为EnableStatusEnum.DISABLE）
   * @param salePolicyTempleteCode 促销政策模板指定的业务编号
   */
  public void invalid(String salePolicyTempleteCode);
  /**
   * 将指定的促销政策模板启用（也就是将enableStatus标记设置为EnableStatusEnum.ENABLE）
   * @param salePolicyTempleteCode 促销政策模板指定的业务编号
   */
  public void effective(String salePolicyTempleteCode);
  /**
   * 该方法可用于物理删除指定的优惠政策模板，但是只有那些没有关联任何优惠政策的模板，才能被删除
   * @param salePolicyTempleteCode
   */
  public void deleteByTempleteCode(String salePolicyTempleteCode);
  /**
   * 按照指定的优惠政策模板进行模板详情查询
   * @param templteCode 指定的优惠政策模板编号
   * @param tenantCode 二级租户信息
   * @return
   */
  public SalePolicyTempleteVo findByTempleteCode(String templeteCode , String tenantCode);
  
  /**
   * 按照二级租户查询已经常见的所有优惠政策模板（按照创建时间排序）
   * @param tenantCode
   * @param enableStatus 非必要参数，启用或者禁用标记，并参见EnableStatusEnum枚举信息：003：禁用；009：启用
   * @return
   */
  public Set<SalePolicyTempleteVo> findByTenantCode(String tenantCode , EnableStatusEnum enableStatus);
  
  /**
   * 针对特定二级租户的已存在的优惠政策模板分页查询信息
   * @return 分页列表
   */
  Page<SalePolicyTempleteVo> findByConditions(Pageable pageable, SalePolicyTempletePageDto dto);
}
