package com.biz.crm.dms.business.policy.local.service;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyThresholdDetail;

import java.util.List;

/**
 * sale_policy 优惠政策中，标品模块使用的优惠政策门槛明细信息的本地服务接口
 * @author yinwenjie
 */
public interface SalePolicyThresholdDetailService {
  
  /**
   * 按照指定的门槛信息技术编号信息，进行门槛明细信息的查询 
   * @param thresholdId
   * @return
   */
  public List<SalePolicyThresholdDetail> findByThresholdId(String thresholdId);
  
  /**
   * 按照特定的优惠政策门槛技术编号，删除所有相关的门槛商品信
   * @param salePolicyThresholdId
   */
  public void deleteBySalePolicyThresholdId(String salePolicyThresholdId);
}
