package com.biz.crm.dms.business.policy.local.service;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyThreshold;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyThresholdVo;

/**
 * DMS提供的产品标品模块，所支持的一种商品门槛信息服务，这种商品门槛适用于商品满减、商品折扣、商品满赠等场景
 * @author yinwenjie
 */
public interface SalePolicyThresholdService {
  /**
   * 创建商品门槛信息
   * @param salePolicyThreshold
   * @return
   */
  public SalePolicyThreshold create(SalePolicyThresholdVo salePolicyThreshold);
  /**
   * 按照指定的门槛涉及的优惠政策业务编号信息(可能是多个)，进行门槛基本信息的查询(不包括关联信息)
   * @param salePolicyCode 指定的优惠政策业务编号
   */
  public SalePolicyThreshold findBySalePolicyCode(String salePolicyCode, String tenantCode);
}
