package com.biz.crm.dms.business.policy.local.service.internal;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutorLadder;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutorLadderGift;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutorLadderVar;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyExecutorLadderRepository;
import com.biz.crm.dms.business.policy.local.service.SalePolicyExecutorLadderGiftService;
import com.biz.crm.dms.business.policy.local.service.SalePolicyExecutorLadderService;
import com.biz.crm.dms.business.policy.local.service.SalePolicyExecutorLadderVarService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Set;

/**
 * 标品中默认的优惠政策执行信息阶梯部分的服务层实现（默认的）
 * @author songjingen
 */
@Service
public class SalePolicyExecutorLadderServiceImpl implements SalePolicyExecutorLadderService {

  @Autowired(required = false)
  private SalePolicyExecutorLadderRepository salePolicyExecutorLadderRepository;
  @Autowired(required = false)
  private SalePolicyExecutorLadderVarService salePolicyExecutorLadderVarService;
  @Autowired(required = false)
  private SalePolicyExecutorLadderGiftService salePolicyExecutorLadderGiftService;


  /**
   * 批量创建促销规则的明细阶梯信息
   * @param salePolicyExecutorLadders 阶梯信息集合
   * @param executeStrategyCode 这条优惠政策执行规则所使用的执行器编码，该编码和某个SalePolicyExecuteStrategy接口具体实现类中的getExecuteStrategyCode()方法返回的值对应
   * @param salePolicyCode 优惠政策业务编号
   * @param salePolicyExecutorId 关联的执行规则基本信息的id
   * @param expression 优惠执行策略表达式
   */
  @Override
  @Transactional
  public void createBatch(Set<SalePolicyExecutorLadder> salePolicyExecutorLadders, String executeStrategyCode, String salePolicyCode, String salePolicyExecutorId, String expression) {
    Validate.isTrue(!CollectionUtils.isEmpty(salePolicyExecutorLadders) , "创建优惠政策执行信息时，至少需要一条执行阶梯信息，请检查!!");
    // 变量名的正则表达式(只能是字母或者数字，且首字母必须是字母)
    for (SalePolicyExecutorLadder salePolicyExecutorLadder : salePolicyExecutorLadders) {
      salePolicyExecutorLadder.setSalePolicyCode(salePolicyCode);
      salePolicyExecutorLadder.setId(null);
      salePolicyExecutorLadder.setSalePolicyExecutorId(salePolicyExecutorId);
      Integer indexs = salePolicyExecutorLadder.getIndexs();
      Validate.notNull(indexs, "创建优惠政策执行信息时，需要填写每一个阶梯的排列索引（越小的排越前面），请检查!!");
      this.salePolicyExecutorLadderRepository.save(salePolicyExecutorLadder);

      // 以下是每一个salePolicyExecutorLadder阶梯设计的若干变量信息
      Set<SalePolicyExecutorLadderVar> salePolicyExecutorLadderVars = salePolicyExecutorLadder.getExecutorLadderVars();
      if (CollectionUtils.isEmpty(salePolicyExecutorLadderVars)) {
        continue;
      }
      // 保存变量信息
      this.salePolicyExecutorLadderVarService.createBatch(salePolicyExecutorLadderVars, salePolicyExecutorLadder.getId(), expression);
      // 如果有赠品信息，则进行赠品信息保存
      //（注意，一个优惠执行策略是否能够包括赠品的验证，并不是在这里完成，而是在外层的具体执行策略处进行限制）
      Set<SalePolicyExecutorLadderGift> executorLadderGifts = salePolicyExecutorLadder.getExecutorLadderGifts();
      if (CollectionUtils.isEmpty(executorLadderGifts)) {
        continue;
      }
      this.salePolicyExecutorLadderGiftService.createBatch(executorLadderGifts, salePolicyExecutorLadder.getId());
    }
  }
}
