package com.biz.crm.dms.business.policy.local.service.internal;

import java.util.Map;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;

import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyGiftInquiryStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.FindPriceUserTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

/**
 * 这是CRM 3.0，优惠政策模块默认实现的询价方式，即通过基本价格（总价值）进行特定商品的询价
 * @author yinwenjie
 */
public class SalePolicyGiftInquiryStrategyImpl implements SalePolicyGiftInquiryStrategy {

  @Autowired(required = false)
  private PriceModelVoService priceModelVoService;
  
  @Override
  public Map<String, PriceModelVo> inquiry(String customerCode, Set<String> giftCodes, SalePolicyVo salePolicy) {
    // 实时进行MDM中赠品单价的查询
    Map<String, PriceModelVo> giftPriceMapping = Maps.newHashMap();
    FindPriceDto searchPriceDto = new FindPriceDto();
    searchPriceDto.setPriceTypeCode(Sets.newHashSet("sale_price"));
    searchPriceDto.setUserCode(customerCode);
    searchPriceDto.setUserType(FindPriceUserTypeEnum.CUSTOMER.getDictCode());
    // 一批商品同时批量查
    searchPriceDto.setProductCodeSet(giftCodes);
    giftPriceMapping = this.priceModelVoService.findPrice(searchPriceDto);
    return giftPriceMapping;
  } 
}
