package com.biz.crm.dms.business.policy.local.service.internal;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyLimitVar;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyLimitVarRepository;
import com.biz.crm.dms.business.policy.local.service.SalePolicyLimitVarService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 促销政策限量控制关联的变量信息服务实现类
 *
 * @author pengxi
 * @date 2022/01/11
 */
@Service
public class SalePolicyLimitVarServiceImpl implements SalePolicyLimitVarService {

  @Autowired(required = false)
  private SalePolicyLimitVarRepository salePolicyLimitVarRepository;

  @Override
  public void create(SalePolicyLimitVar salePolicyLimitVar) {
    salePolicyLimitVar = ObjectUtils.defaultIfNull(salePolicyLimitVar, new SalePolicyLimitVar());
    Validate.notNull(salePolicyLimitVar.getSalePolicyLimitId(), "关联的优惠政策限量政策主键ID不能为空！");
    // TODO 校验项完善
    this.salePolicyLimitVarRepository.save(salePolicyLimitVar);
  }

  @Override
  public void deleteBySalePolicyLimitId(String salePolicyLimitId) {
    Validate.notEmpty(salePolicyLimitId, "关联的优惠政策限量政策主键ID不能为空！");
    this.salePolicyLimitVarRepository.deleteBySalePolicyLimit(salePolicyLimitId);
  }
}
