package com.biz.crm.dms.business.policy.local.service.internal;

import com.biz.crm.dms.business.policy.local.entity.SalePolicy;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyProduct;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyExecutorRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyProductRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyRepository;
import com.biz.crm.dms.business.policy.local.service.SalePolicyProductService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.List;
import java.util.Set;

@Service
public class SalePolicyProductServiceImpl implements SalePolicyProductService {

  @Autowired(required = false)
  private SalePolicyRepository salePolicyRepository;
  @Autowired(required = false)
  private SalePolicyProductRepository salePolicyProductRepository;
  @Autowired(required = false)
  private SalePolicyExecutorRepository salePolicyExecutorRepository;
  
  @Override
  @Transactional
  public void createBatch(Set<SalePolicyProduct> salePolicyProducts) {
    Validate.isTrue(!CollectionUtils.isEmpty(salePolicyProducts) , "创建优惠政策商品本品信息时，必须至少传入一条本品信息，请检查！！");
    for (SalePolicyProduct salePolicyProduct : salePolicyProducts) {
      this.createHandle(salePolicyProduct);
    }
  }
  
  /**
   * 该私有方法负责处理单条优惠政策本品信息
   * @param salePolicyProduct
   */
  private void createHandle(SalePolicyProduct salePolicyProduct) {
    String tenantCode = TenantUtils.getTenantCode();
    salePolicyProduct.setTenantCode(tenantCode);
    String salePolicyCode = salePolicyProduct.getSalePolicyCode();
    Validate.notBlank(salePolicyCode , "创建优惠政策本品商品时，发现未指定的优惠政策信息，请检查并完善!!");
    salePolicyProduct.setId(null);
    SalePolicy exsitSalePolicy = this.salePolicyRepository.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode);
    Validate.notNull(exsitSalePolicy , "创建优惠政策本品商品时，未发现指定的优惠政策信息，请检查!!");
    
    // ==== 必须填写的信息  
    // 执行器的信息
    String executorCode = salePolicyProduct.getExecutorCode();
    Validate.notBlank(executorCode , "创建优惠政策本品商品时，至少一条本品商品的执行器业务编码没有填写，请检查!!");
    Integer exsitSalePolicyExecutorCount = this.salePolicyExecutorRepository.countBySalePolicyCodeAndExecutorCode(salePolicyCode, executorCode, tenantCode);
    Validate.isTrue(exsitSalePolicyExecutorCount == 1 , "创建优惠政策本品商品时，至少有一条本品商品的关联的执行策略没有被找到（%s），请检查!!" , executorCode);
    String productCode = salePolicyProduct.getProductCode();
    Validate.notBlank(productCode , "创建优惠政策本品商品时，至少有一条本品商品的业务编码没有填写，请检查!!");
    // 一个优惠政策下，本品的业务编号不可能重复
    SalePolicyProduct exsitSalePolicyProduct = this.salePolicyProductRepository.findBySalePolicyCodeAndProductCodeAndTenantCode(salePolicyCode, productCode, tenantCode);
    Validate.isTrue(exsitSalePolicyProduct == null , "创建优惠政策本品商品时，发现指定的本品商品信息(%s)已经被添加到这条优惠政策中，不能添加重复的本品商品信息，请检查!!" , productCode);
    String productName = salePolicyProduct.getProductName();
    Validate.notBlank(productName , "创建优惠政策本品商品时，至少有一条本品商品的中文名称没有填写，请检查!!"); 
    
    // 验证完成后，开始进行保存
    this.salePolicyProductRepository.save(salePolicyProduct);
  }

  @Override
  public List<SalePolicyProduct> findBySalePolicyCode(String salePolicyCode, String tenantCode) {
    if(StringUtils.isAnyBlank(salePolicyCode , tenantCode)) {
      return null;
    }
    return this.salePolicyProductRepository.findBySalePolicyCode(salePolicyCode, tenantCode);
  }
}
