package com.biz.crm.dms.business.policy.local.sharestrategy;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.local.context.DefaultCycleExecuteContext;
import com.biz.crm.dms.business.policy.local.context.DefaultPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.GiftResultInfo;
import com.biz.crm.dms.business.policy.sdk.context.ProductPolicyStepResult;
import com.biz.crm.dms.business.policy.sdk.context.StepType;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.CycleStepResult;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.local.utils.GiftBuildUtils;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteShareStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyGiftInquiryStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

/**
 * 将优惠后的赠品，基于各个参与优惠的本品明细在优惠前的数量比例，分摊到商品小计上</br>
 * 这种分摊方式适用于按照按照数量进行赠品赠送的优惠政策。</p>
 * 
 * 2022-05-10 根据需求变更后的设计，按照本品数量进行优惠赠品的分摊这个逻辑不再使用，但是代码进行保留
 * 
 * @author yinwenjie
 */
@Deprecated
@Component
public class GiftShareStrategyWithNumber implements SalePolicyExecuteShareStrategy {

  @Autowired(required = false)
  private SalePolicyGiftInquiryStrategy salePolicyGiftInquiryStrategy;
  
  private static final Logger LOGGER = LoggerFactory.getLogger(GiftShareStrategyWithNumber.class);
  
  @Override
  public void share(String customer , SalePolicyVo salePolicy ,  AbstractPolicyExecuteContext abstractPolicyExecuteContext , AbstractCycleExecuteContext abstractCycleExecuteContext , Set<String> productCodes) {
    DefaultPolicyExecuteContext policyExecuteContext = (DefaultPolicyExecuteContext)abstractPolicyExecuteContext;
    DefaultCycleExecuteContext cycleExecuteContext = (DefaultCycleExecuteContext)abstractCycleExecuteContext;
    String salePolicyCode = salePolicy.getSalePolicyCode();
    
    /*
     * 整个分摊过程如下：
     * 
     * 1、取得最新增加的赠品信息（注意，可能为null）
     * 
     * 2、接着就要分摊赠品增量，到每个参与优惠的本品上了。
     * 首先需要从优惠政策执行上下文中得到哪些本品参与了本次优惠，这样可以汇总当前这些本品的最新状态
     * 
     * 3、另外，需对将要分摊的本品（第2步得到）按照当前最新的数量进行一个排序，数量越大的排在越前面（本品数量记为N）
     * 
     * 4、进行赠品的循环分摊，分摊公式见后续代码中的说明。注意，这个公式只适用于排序后，最前面N-1个本品
     * 而对于最后一个本品N，则直接使用整数减法进行分摊
     * 另外，需要特别注意，在分摊过程中赠品的小计价格和单价的重计算问题
     * */
    
    // 1、========
    CycleStepResult cycleLastStepResult = cycleExecuteContext.findLastStepResult();
    Set<GiftResultInfo> newGiftResultInfos = cycleLastStepResult.getLastGifts();
    if(newGiftResultInfos == null) {
      newGiftResultInfos = Sets.newLinkedHashSet();
    }
    
    // 2、=======
    Set<String> mathcedProductCodes = policyExecuteContext.findProductCodesByPolicyCode(salePolicyCode);
    List<ProductPolicyStepResult> productLastPolicyStepResults = Lists.newArrayList();
    // 一般来说不会出现这种情况，但如果出现了这种情况，就需要报出警告信息，并跳过整个分摊过程
    if(CollectionUtils.isEmpty(mathcedProductCodes)) {
      String errorMsg = String.format("错误的商品分摊场景，请联系管理员检查%s优惠政策的执行情况", salePolicyCode);
      policyExecuteContext.resetExcludedPolicy(salePolicyCode , null, errorMsg);
      LOGGER.warn(errorMsg);
      return;
    }
    for (String mathcedProductCode : mathcedProductCodes) {
      ProductPolicyStepResult productPolicyStepResult = policyExecuteContext.findLastProductStepResultByProductCode(mathcedProductCode);
      productLastPolicyStepResults.add(productPolicyStepResult);
      if(productPolicyStepResult == null) {
        String errorMsg = String.format("错误的商品分摊场景，请联系管理员检查%s优惠政策中本品%s的执行情况", salePolicyCode , mathcedProductCode);
        LOGGER.warn(errorMsg);
        return;
      }
    }
    
    // 3、=======
    // 由于是按照本品数量进行分摊，所以这里按照各本品的数量进行排序
    productLastPolicyStepResults = productLastPolicyStepResults.stream().sorted((target , source) -> target.getInitNumbers() - source.getInitNumbers()).collect(Collectors.toList());
    Set<SalePolicyConProduct> policyConProducts = cycleExecuteContext.getInitPolicyProducts();
    int totalQuantity = 0;
    for (SalePolicyConProduct policyConProduct : policyConProducts) {
      totalQuantity += policyConProduct.getQuantity().intValue();
    }
    // 实时进行MDM中赠品单价的查询
    Map<String, PriceModelVo> giftPriceMapping = Maps.newHashMap();
    if(!CollectionUtils.isEmpty(newGiftResultInfos)) {
      Set<String> giftCodes = newGiftResultInfos.stream().filter(item -> StringUtils.isNotBlank(item.getProductCode())).map(GiftResultInfo::getProductCode).collect(Collectors.toSet());
      giftPriceMapping = this.salePolicyGiftInquiryStrategy.inquiry(customer, giftCodes, salePolicy);
    }
    
    // 4、=======
    Set<ProductPolicyStepResult> newProductPolicyStepResults = Sets.newLinkedHashSet();
    // allocatedGiftMapping记录这些赠品已经完成本品分摊的数量
    Map<String , Integer> allocatedGiftMapping = newGiftResultInfos.stream().collect(Collectors.toMap(GiftResultInfo::getProductCode, item -> 0));
    for (int index = 0 ; index < productLastPolicyStepResults.size() ; index++) {
      ProductPolicyStepResult productPolicyStepResult = productLastPolicyStepResults.get(index);
      BigDecimal lastSubtotal = productPolicyStepResult.getLastSubtotal();
      if(lastSubtotal.compareTo(BigDecimal.ZERO) != 1) {
        continue;
      }
      // 为当前商品添加一个新的优惠步进
      ProductPolicyStepResult newProductPolicyStepResult = new ProductPolicyStepResult();
      newProductPolicyStepResult.setStepType(salePolicy.getWholePolicy()?StepType.POLICY:StepType.PRODUCT);
      newProductPolicyStepResult.setSalePolicyCode(salePolicy.getSalePolicyCode());
      newProductPolicyStepResult.setExecuteCode(abstractCycleExecuteContext.getExecuteCode());
      newProductPolicyStepResult.setProductCode(productPolicyStepResult.getProductCode());
      newProductPolicyStepResult.setInitNumbers(productPolicyStepResult.getInitNumbers());
      newProductPolicyStepResult.setInitPrices(productPolicyStepResult.getInitPrices());
      newProductPolicyStepResult.setInitSubtotal(productPolicyStepResult.getInitSubtotal());
      List<GiftResultInfo> lastGifts = productPolicyStepResult.getLastGifts();
      newProductPolicyStepResult.setPreGifts(lastGifts);
      newProductPolicyStepResult.setPrePrices(productPolicyStepResult.getLastPrices());
      newProductPolicyStepResult.setPreSubtotal(productPolicyStepResult.getLastSubtotal());
      newProductPolicyStepResult.setPreSurplusTotalAmount(productPolicyStepResult.getLastSurplusTotalAmount());
      newProductPolicyStepResult.setPreSurplusTotalNumber(productPolicyStepResult.getLastSurplusTotalNumber());
      List<GiftResultInfo> lastProductPolicyStepResult = productPolicyStepResult.getLastGifts();
      newProductPolicyStepResult.setLastPrices(productPolicyStepResult.getLastPrices());
      newProductPolicyStepResult.setLastSubtotal(lastSubtotal);
      newProductPolicyStepResult.setLastSurplusTotalAmount(productPolicyStepResult.getLastSurplusTotalAmount());
      newProductPolicyStepResult.setLastSurplusTotalNumber(productPolicyStepResult.getLastSurplusTotalNumber());
      
      // 只做赠品数量的分摊，每一个赠品都要进行数量分摊，其它步进值保持布标
      int productNumber = productPolicyStepResult.getInitNumbers();
      // 每个赠品都要分摊，并且要记录每一个赠品，在各个本品上，已经被分摊的数量
      Set<GiftResultInfo> shareNewProductGiftInfos = Sets.newLinkedHashSet(); 
      for (GiftResultInfo resultGiftInfo : newGiftResultInfos) {
        Integer quantity = resultGiftInfo.getQuantity();
        String productCode = resultGiftInfo.getProductCode();
        String productName = resultGiftInfo.getProductName();
        PriceModelVo giftPriceModel = giftPriceMapping.get(productCode);
        BigDecimal unitPrice = BigDecimal.ZERO;
        if(giftPriceModel != null && giftPriceModel.getPrice() != null) {
          unitPrice = giftPriceModel.getPrice();
        }
        // 如果条件成立，就不需要对这个赠品进行分摊，当然正常情况下不会出现这样的场景
        if(quantity <= 0 ) {
          continue;
        }
        
        /*
         * 开始分摊，注意，最后一次index循环的分摊，并不是按照比例来的，而是直接减去已分摊的赠品数量
         * 剩下的都分摊到最后一个本品上
         * */
        int shareQuantity = 0;
        // 如果条件成立，就是最后一个本品的分摊，那么哪找减法进行计算
        if(index + 1 == productLastPolicyStepResults.size()) {
          int allocatedGiftNumber = allocatedGiftMapping.get(productCode);
          shareQuantity = quantity - allocatedGiftNumber;
          // 很有可能出现分摊到执行本品的赠品数量为0，这是正常情况
          if(shareQuantity == 0) {
            continue;
          }
        } 
        // 否则就不是最后一个本品的分摊，那么按照金额比例进行分摊
        else {
          shareQuantity = new BigDecimal(productNumber).divide(new BigDecimal(totalQuantity), 20, RoundingMode.HALF_UP).multiply(new BigDecimal(quantity)).intValue();
          if(shareQuantity == 0) {
            continue;
          }
          int allocatedGiftNumber = allocatedGiftMapping.get(productCode);
          allocatedGiftMapping.put(productCode, allocatedGiftNumber + shareQuantity);
        }
        // 分摊完成后，计算这个赠品在指定本品上的新增情况，并记录下来
        GiftResultInfo productGiftResultInfo = new GiftResultInfo();
        productGiftResultInfo.setProductCode(productCode);
        productGiftResultInfo.setProductName(productName);
        productGiftResultInfo.setQuantity(shareQuantity);
        productGiftResultInfo.setSubtotalAmount(new BigDecimal(shareQuantity).multiply(unitPrice));
        shareNewProductGiftInfos.add(productGiftResultInfo);
      }
      Set<GiftResultInfo> shareProductGiftResultInfos = GiftBuildUtils.buildGiftResult(lastProductPolicyStepResult, shareNewProductGiftInfos);
      newProductPolicyStepResult.setLastGifts(Lists.newArrayList(shareProductGiftResultInfos));
      newProductPolicyStepResults.add(newProductPolicyStepResult);
    }
    policyExecuteContext.addPolicyStepResult(newProductPolicyStepResults);
  }
}
