package com.biz.crm.dms.business.policy.local.utils;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import com.biz.crm.dms.business.policy.sdk.context.GiftResultInfo;
import com.google.common.collect.Sets;

/**
 * 该工具专门用于累加赠品结果
 * @author yinwenjie
 *
 */
public class GiftBuildUtils {
  
  private GiftBuildUtils() {
    
  }
  
  /**
   * 该方法用于整合两组赠品信息，更准确的说，是基于sourceGiftResultInfos赠品集合，进行targetGiftResultInfos集合中赠品的累计
   * @param lastGiftResultInfos
   * @param newGiftResultInfos
   * @return
   */
  public static Set<GiftResultInfo> buildGiftResult(Collection<GiftResultInfo> sourceGiftResultInfos , Collection<GiftResultInfo> targetGiftResultInfos) {
    Map<String , GiftResultInfo> sourceGiftResultInfoMappings = sourceGiftResultInfos.stream().collect(Collectors.toMap(GiftResultInfo::getProductCode, item -> item));
    Map<String , GiftResultInfo> targetGiftResultInfoMappings = targetGiftResultInfos.stream().collect(Collectors.toMap(GiftResultInfo::getProductCode, item -> item));
    Set<GiftResultInfo> resultGiftInfos = Sets.newLinkedHashSet();
    /*
     * 提取本次优惠新增的赠品信息，主要有两种情况：
     * a、sourceGiftResultInfos中没有，而targetGiftResultInfos中有的赠品。说明这种赠品全部都是本次优惠增加的
     * b、sourceGiftResultInfos中有，而targetGiftResultInfos中也有的赠品，说明这部分需要累加上去，并且需要重新计算赠品单价
     * */
    
    // a、======= 存在的差集，就代表新加入的赠品信
    for (String giftInfoCode : Sets.difference(targetGiftResultInfoMappings.keySet(), sourceGiftResultInfoMappings.keySet())) {
      GiftResultInfo resultGiftInfo = targetGiftResultInfoMappings.get(giftInfoCode);
      resultGiftInfos.add(resultGiftInfo);
    }
    // 没有变化的赠品信息，继续延续到新的集合中
    for (String giftInfoCode : Sets.difference(sourceGiftResultInfoMappings.keySet() , targetGiftResultInfoMappings.keySet())) {
      GiftResultInfo resultGiftInfo = sourceGiftResultInfoMappings.get(giftInfoCode);
      resultGiftInfos.add(resultGiftInfo);
    }
    // b、======= 存在的交集就代表了新的赠品已经存在于既有的赠品集合中
    for (String giftInfoCode : Sets.intersection(targetGiftResultInfoMappings.keySet(), sourceGiftResultInfoMappings.keySet())) {
      GiftResultInfo lastGiftInfo = sourceGiftResultInfoMappings.get(giftInfoCode);
      GiftResultInfo newGiftInfo = targetGiftResultInfoMappings.get(giftInfoCode);
      // 重算小计价格和单价
      Integer resultGiftNumber = lastGiftInfo.getQuantity() + newGiftInfo.getQuantity();
      BigDecimal resultSubtotalAmount = lastGiftInfo.getSubtotalAmount().add(newGiftInfo.getSubtotalAmount());
      GiftResultInfo resultGiftInfo = new GiftResultInfo();
      resultGiftInfo.setProductCode(newGiftInfo.getProductCode());
      resultGiftInfo.setProductName(newGiftInfo.getProductName());
      resultGiftInfo.setQuantity(resultGiftNumber);
      resultGiftInfo.setSubtotalAmount(resultSubtotalAmount);
      resultGiftInfos.add(resultGiftInfo);
    }
    return resultGiftInfos;
  }
}
