package com.biz.crm.dms.business.policy.local.vo;

import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import io.swagger.annotations.ApiModelProperty;

/**
 * 以圈定渠道范围的方式，确认特定优惠政策的适用客户范围
 * @author yinwenjie
 */
public class SalePolicyScopeChannelInfoVo extends AbstractSalePolicyCustomerScopeInfo {
  private static final long serialVersionUID = 1L;
  
  @ApiModelProperty("渠道的选定方式：include：包括；exclude：排除")
  private String selectionMethod;
  
  @ApiModelProperty("被选定或者被排除的渠道业务编号")
  private String channelCode;
  
  @ApiModelProperty("被选定或者被排除的渠道业务名称")
  private String channelName;

  public String getSelectionMethod() {
    return selectionMethod;
  }

  public void setSelectionMethod(String selectionMethod) {
    this.selectionMethod = selectionMethod;
  }

  public String getChannelCode() {
    return channelCode;
  }

  public void setChannelCode(String channelCode) {
    this.channelCode = channelCode;
  }

  public String getChannelName() {
    return channelName;
  }

  public void setChannelName(String channelName) {
    this.channelName = channelName;
  }

  @Override
  public String scopeCode() {
    return this.channelCode;
  }
}
