package com.biz.crm.dms.business.policy.local.vo;

import java.util.List;

import com.biz.crm.business.common.sdk.vo.UuidVo;

import io.swagger.annotations.ApiModelProperty;

/**
 * 标品中，适用于商品满减、商品折扣、商品买赠（等）的促销门槛涉及的门槛详情描述
 * @author yinwenjie
 */
public class SalePolicyThresholdDetailVo extends UuidVo {
  private static final long serialVersionUID = -6958731103026042085L;
  
  @ApiModelProperty("优惠政策设计的二级租户信息")
  private String tenantCode;
  
  @ApiModelProperty("优惠政策业务编号")
  private String salePolicyCode;
  
  @ApiModelProperty("门槛业务编号（每个租户，每个优惠政策下，该值需要唯一）")
  private String thresholdDetailCode;
  
  @ApiModelProperty("门槛所包含商品的方式：1、包含当前优惠政策中的所有商品（必含全部）；2、包括固定的数量、固定的商品（必含X种）")
  private Integer includeType = 2;
  
  @ApiModelProperty("门槛所包括的固定商品的数量，默认为0，和includeType配合使用（只有includeType == 2时，起作用）")
  private Integer includeNumber = 0;
  /**
   * 具体的商品门槛信息<br>
   * 无论includeType的值为什么，都会有商品门槛明细
   */
  @ApiModelProperty("具体的商品门槛信息")
  private List<SalePolicyThresholdProductVo> thresholdProducts;
  public String getTenantCode() {
    return tenantCode;
  }
  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }
  public String getSalePolicyCode() {
    return salePolicyCode;
  }
  public void setSalePolicyCode(String salePolicyCode) {
    this.salePolicyCode = salePolicyCode;
  }
  public String getThresholdDetailCode() {
    return thresholdDetailCode;
  }
  public void setThresholdDetailCode(String thresholdDetailCode) {
    this.thresholdDetailCode = thresholdDetailCode;
  }
  public Integer getIncludeType() {
    return includeType;
  }
  public void setIncludeType(Integer includeType) {
    this.includeType = includeType;
  }
  public Integer getIncludeNumber() {
    return includeNumber;
  }
  public void setIncludeNumber(Integer includeNumber) {
    this.includeNumber = includeNumber;
  }
  public List<SalePolicyThresholdProductVo> getThresholdProducts() {
    return thresholdProducts;
  }
  public void setThresholdProducts(List<SalePolicyThresholdProductVo> thresholdProducts) {
    this.thresholdProducts = thresholdProducts;
  }
}
