package com.biz.crm.dms.business.policy.local.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 标品中，适用于商品满减、商品折扣、商品买赠（等）的促销门槛涉及的主要商品信息描述
 * @author yinwenjie
 */
@Getter
@Setter
public class SalePolicyThresholdProductVo extends TenantVo {
  private static final long serialVersionUID = -6958731103026042085L;
  
  /**
   * 优惠政策业务编号
   */
  @ApiModelProperty("优惠政策业务编号")
  private String salePolicyCode;
  
  /**
   * 优惠政策门槛明细业务编号
   */
  @ApiModelProperty("优惠政策门槛明细业务编号")
  private String thresholdDetailCode;
  
  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;
  
  /**
   * 该商品门槛是否必然包括
   */
  @ApiModelProperty("该商品门槛是否必然包括")
  private Boolean certain = false;
  
  /**
   * 商品门槛单位：（ 1：小计金额；2：数量）
   */
  @ApiModelProperty("商品门槛单位：（ 1：小计金额；2：数量）")
  private Integer thresholdUnit;
  
  /**
   * 该商品门槛的数量值（单位由thresholdUnit）属性决定
   */
  @ApiModelProperty("该商品门槛的数量值（单位由thresholdUnit）属性决定")
  private Integer thresholdNumber;
}
