package com.biz.crm.dms.business.policy.local.vo;

import java.util.List;

import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyThreshold;

import io.swagger.annotations.ApiModelProperty;

/**
 * 标品中，适用于商品满减、商品折扣、商品买赠（等）的促销门槛描述
 * @author yinwenjie
 */
public class SalePolicyThresholdVo extends AbstractSalePolicyThreshold {
  private static final long serialVersionUID = -8205593060924057142L;
  
  @ApiModelProperty("产品组合的总阈值单位（ 1：总金额；2：数量）")
  private Integer composeUnit;
  
  @ApiModelProperty("商品优惠门槛的总阈值数量(默认为0)")
  private Integer composeNumber = 0;
  /**
   * 具体的商品门槛信息<br>
   * 无论includeType的值为什么，都会有商品门槛明细
   */
  @ApiModelProperty("具体的商品门槛信息")
  private List<SalePolicyThresholdDetailVo> thresholdDetails;
  public Integer getComposeUnit() {
    return composeUnit;
  }
  public void setComposeUnit(Integer composeUnit) {
    this.composeUnit = composeUnit;
  }
  public Integer getComposeNumber() {
    return composeNumber;
  }
  public void setComposeNumber(Integer composeNumber) {
    this.composeNumber = composeNumber;
  }
  public List<SalePolicyThresholdDetailVo> getThresholdDetails() {
    return thresholdDetails;
  }
  public void setThresholdDetails(List<SalePolicyThresholdDetailVo> thresholdDetails) {
    this.thresholdDetails = thresholdDetails;
  }
}
