/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.config;

import com.biz.crm.dms.business.policy.local.entity.SalePolicy;
import com.biz.crm.dms.business.policy.local.scopestrategy.UnionSalePolicyCustomerScopeMergeStrategy;
import com.biz.crm.dms.business.policy.local.service.internal.SalePolicyGiftInquiryStrategyImpl;
import com.biz.crm.dms.business.policy.local.service.internal.SalePolicyMatchedStrategyImpl;
import com.biz.crm.dms.business.policy.local.service.task.SalePolicyCustomerScopeMatchedTask;
import com.biz.crm.dms.business.policy.local.service.task.SalePolicyLoadingTask;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeMergeStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyGiftInquiryStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyMatchedStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class DefaultPolicyLocalConfig {
    private static final Integer PROCESSINGCOUNT = Runtime.getRuntime().availableProcessors();

    @Bean(value={"policyLoadingExecutor"})
    @ConditionalOnMissingBean
    public ThreadPoolExecutor getPolicyLoadingExecutor() {
        return new ThreadPoolExecutor((int)PROCESSINGCOUNT, (int)PROCESSINGCOUNT, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(), new PolicyLoadingExecutorThreadFactory());
    }

    @Bean
    @Scope(value="prototype")
    public SalePolicyLoadingTask getPolicyLoadingTask(SalePolicy salePolicy, String tenantCode) {
        return new SalePolicyLoadingTask(salePolicy, tenantCode);
    }

    @Bean
    @Scope(value="prototype")
    public SalePolicyCustomerScopeMatchedTask getSalePolicyCustomerScopeMatchedTask(SalePolicyVo salePolicyVo, String tenantCode, String customerCode) {
        return new SalePolicyCustomerScopeMatchedTask(salePolicyVo, tenantCode, customerCode);
    }

    @Bean
    @ConditionalOnMissingBean
    public SalePolicyGiftInquiryStrategy getSalePolicyGiftInquiryStrategy() {
        return new SalePolicyGiftInquiryStrategyImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public SalePolicyMatchedStrategy getSalePolicyMatchedStrategy() {
        return new SalePolicyMatchedStrategyImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public SalePolicyCustomerScopeMergeStrategy getSalePolicyCustomerScopeMergeStrategy() {
        return new UnionSalePolicyCustomerScopeMergeStrategy();
    }

    private class PolicyLoadingExecutorThreadFactory
    implements ThreadFactory {
        private AtomicInteger count = new AtomicInteger(1);

        private PolicyLoadingExecutorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "policy-loading-task-" + this.count.getAndIncrement());
        }
    }
}

