/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.policy.local.context.DefaultPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.sdk.service.SalePolicyExecuteService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8be5http\u5c42\u529f\u80fd\u63d0\u4f9b\u7684\u63a5\u53e3\uff0c\u90fd\u4e0e\u4f18\u60e0\u653f\u7b56\u8ba1\u7b97/\u9884\u8ba1\u7b97/\u9884\u5224\u5b9a\u6709\u5173"})
@RestController
@RequestMapping(value={"/v1/salepolicies/execute"})
public class SalePolicyExecuteController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SalePolicyExecuteController.class);
    @Autowired(required=false)
    private SalePolicyExecuteService<DefaultPolicyExecuteContext> salePolicyExecuteService;

    @ApiOperation(value="\u9884\u5224\u5b9a\u6267\u884c\u3002\u9884\u5224\u5b9a\u573a\u666f\u65e0\u9700\u77e5\u6653\u5546\u54c1\u6570\u91cf\uff0c\u4e0d\u8003\u8651\u4f18\u60e0\u653f\u7b56\u7684\u95e8\u69db\u3001\u4e0d\u8003\u8651\u8ba2\u5355\u603b\u4ef7\uff0c\u4e0d\u8003\u8651\u653f\u7b56\u53e0\u52a0\u3001\u653f\u7b56\u9636\u68af", notes="\u9884\u5224\u5b9a\u573a\u666f\u9002\u7528\u4e8e\u5546\u54c1\u5217\u8868\u5c55\u793a\u529f\u80fd\u3001\u8d2d\u7269\u8f66\u5217\u8868\u5c55\u793a\u529f\u80fd")
    @PostMapping(value={"/preJudgment"})
    public Result<DefaultPolicyExecuteContext> preJudgment(@RequestBody Set<SalePolicyConProduct> initPolicyProducts, @RequestParam(value="customerCode") String customerCode) {
        try {
            String tenantCode = TenantUtils.getTenantCode();
            DefaultPolicyExecuteContext policyExecuteContext = (DefaultPolicyExecuteContext)this.salePolicyExecuteService.preJudgment(initPolicyProducts, tenantCode, customerCode);
            return Result.ok((Object)policyExecuteContext);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8ba9\u4e00\u6279\u5546\u54c1\u89c4\u683c\uff0c\u57fa\u4e8e\u7ecf\u9500\u5546\u4e3a\u6307\u5b9a\u5ba2\u6237\u63d0\u4f9b\u7684\u6b63\u5728\u6267\u884c\u4e2d\u7684\u6d3b\u52a8\u7b56\u7565\u8fdb\u884c\u9884\u8ba1\u7b97\uff0c\u6700\u7ec8\u5f97\u5230\u8fd9\u6279\u7269\u8d44\u5728\u5404\u4e2a\u7ef4\u5ea6\u5c42\u9762\u4e0a\u7684\u4f18\u60e0\u4fe1\u606f")
    @PostMapping(value={"/preexecute"})
    public Result<DefaultPolicyExecuteContext> preExecute(@RequestBody Set<SalePolicyConProduct> initPolicyProducts, @RequestParam(value="customerCode") String customerCode, @RequestParam(value="kneading", required=false, defaultValue="false") boolean kneading) {
        try {
            String tenantCode = TenantUtils.getTenantCode();
            LinkedHashMap mustCorrectPolicyMapping = Maps.newLinkedHashMap();
            for (SalePolicyConProduct defaultPolicyConProduct : initPolicyProducts) {
                String[] selectedPolicyCodes = defaultPolicyConProduct.getSelectedPolicyCodes();
                if (selectedPolicyCodes == null) continue;
                mustCorrectPolicyMapping.put(defaultPolicyConProduct.getProductCode(), selectedPolicyCodes);
            }
            DefaultPolicyExecuteContext policyExecuteContext = null;
            policyExecuteContext = CollectionUtils.isEmpty((Map)mustCorrectPolicyMapping) ? (DefaultPolicyExecuteContext)this.salePolicyExecuteService.preExecute(initPolicyProducts, tenantCode, customerCode, kneading) : (DefaultPolicyExecuteContext)this.salePolicyExecuteService.preExecute(initPolicyProducts, (Map)mustCorrectPolicyMapping, tenantCode, customerCode, kneading);
            return Result.ok((Object)policyExecuteContext);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8ba9\u4e00\u6279\u5546\u54c1\u89c4\u683c\uff0c\u57fa\u4e8e\u7ecf\u9500\u5546\u4e3a\u6307\u5b9a\u5ba2\u6237\u63d0\u4f9b\u7684\u6b63\u5728\u6267\u884c\u4e2d\u7684\u6d3b\u52a8\u7b56\u7565\u8fdb\u884c\u6b63\u5f0f\u8ba1\u7b97\uff08\u8be5\u63a5\u53e3\u4e13\u6ce8\u4e8e\u8fc7\u7a0b\u6d4b\u8bd5\uff0c\u540e\u7eed\u5c06\u88ab\u5220\u9664\uff09\uff0c\u6700\u7ec8\u5f97\u5230\u8fd9\u6279\u7269\u8d44\u5728\u5404\u4e2a\u7ef4\u5ea6\u5c42\u9762\u4e0a\u7684\u4f18\u60e0\u4fe1\u606f")
    @PostMapping(value={"/execute"})
    public Result<DefaultPolicyExecuteContext> execute(@RequestBody Set<SalePolicyConProduct> initPolicyProducts, @RequestParam(value="relevanceCode") String relevanceCode, @RequestParam(value="customerCode") String customerCode, @RequestParam(value="kneading", required=false, defaultValue="false") boolean kneading) {
        try {
            String tenantCode = TenantUtils.getTenantCode();
            LinkedHashMap mustCorrectPolicyMapping = Maps.newLinkedHashMap();
            for (SalePolicyConProduct defaultPolicyConProduct : initPolicyProducts) {
                String[] selectedPolicyCodes = defaultPolicyConProduct.getSelectedPolicyCodes();
                if (selectedPolicyCodes == null) continue;
                mustCorrectPolicyMapping.put(defaultPolicyConProduct.getProductCode(), selectedPolicyCodes);
            }
            DefaultPolicyExecuteContext policyExecuteContext = (DefaultPolicyExecuteContext)this.salePolicyExecuteService.execute(relevanceCode, initPolicyProducts, (Map)mustCorrectPolicyMapping, tenantCode, customerCode, kneading);
            return Result.ok((Object)policyExecuteContext);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be5\u65b9\u6cd5\u6309\u7167\u6307\u5b9a\u7684\u5355\u636e\u4fe1\u606f\u3001\u79df\u6237\u4fe1\u606f\u548c\u5ba2\u6237\u4fe1\u606f\uff0c\u67e5\u627e\u5386\u53f2\u4e0a\u5df2\u5b8c\u6210\u4f18\u60e0\u653f\u7b56\u6267\u884c\u7684\u7ed3\u679c\uff08\u4ee5\u4e0a\u4e0b\u6587\u7684\u60c5\u51b5\u8fd4\u56de\uff09")
    @GetMapping(value={"/findByRelevanceCode"})
    public Result<DefaultPolicyExecuteContext> findByRelevanceCode(@RequestParam(value="relevanceCode") String relevanceCode, @RequestParam(value="customerCode") String customerCode) {
        try {
            String tenantCode = TenantUtils.getTenantCode();
            DefaultPolicyExecuteContext policyExecuteContext = (DefaultPolicyExecuteContext)this.salePolicyExecuteService.findByRelevanceCode(relevanceCode, tenantCode, customerCode);
            return Result.ok((Object)policyExecuteContext);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

