/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.policy.local.service.task.SalePolicyCacheLoadingService;
import com.biz.crm.dms.business.policy.sdk.dto.SalePolicyPageDto;
import com.biz.crm.dms.business.policy.sdk.service.SalePolicyVoService;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={" SalePolicyVo\uff08\u4f18\u60e0\u653f\u7b56\uff09\u4e1a\u52a1\u6a21\u578b\u7684MVC Controller\u5c42\u5b9e\u73b0\uff0c\u57fa\u4e8eHTTP Restful\u98ce\u683c"})
@RestController
@RequestMapping(value={"/v1/salepolicies/policies"})
public class SalePolicyVoController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SalePolicyVoController.class);
    @Autowired(required=false)
    private SalePolicyVoService salePolicyVoService;
    @Autowired(required=false)
    private SalePolicyCacheLoadingService salePolicyCacheLoadingService;

    @ApiOperation(value="\u7531\u4e8e\u4fc3\u9500\u653f\u7b56\u5355\u4f7f\u7528\u521b\u5efa\u6388\u6743\u6807\u7b7e\u6765\u907f\u514d\u91cd\u590d\u63d0\u4ea4\u7684\u95ee\u9898\u3002\u6240\u4ee5\u5728\u521b\u5efa/\u4fee\u6539\u8425\u9500\u653f\u7b56\u5355\u524d\uff0c\u9700\u8981\u4f7f\u7528\u8be5\u65b9\u6cd5\u83b7\u5f97\u9884\u6388\u6743\u3002\u9884\u6388\u6743\u6210\u529f\u540e\uff0c\u624d\u80fd\u901a\u8fc7\u9884\u6388\u6743\u4fe1\u606f\u8fdb\u884c\u6dfb\u52a0\uff0c")
    @PostMapping(value={"/preSave"})
    public Result<?> preSave() {
        try {
            String prefix = this.salePolicyVoService.preSave();
            return Result.ok((String)prefix);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa\u4e00\u4e2a\u65b0\u7684SalePolicy\u6a21\u578b\u5bf9\u8c61\uff08\u5305\u62ec\u4e86\u53ef\u80fd\u7684\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8c03\u7528\u3001\u590d\u6742\u903b\u8f91\u5904\u7406\u7b49\uff09")
    @PostMapping(value={""})
    public Result<?> create(@RequestBody @ApiParam(name="salePolicy", value="\u521b\u5efa\u4e00\u4e2a\u65b0\u7684SalePolicy\u6a21\u578b\u5bf9\u8c61\uff08JSON\u7ed3\u6784\u662f\u52a8\u6001\u7684\u5305\u62ec\u4e86\u53ef\u80fd\u7684\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8c03\u7528\u3001\u590d\u6742\u903b\u8f91\u5904\u7406\u7b49\uff09") JSONObject salePolicyJson) {
        try {
            SalePolicyVo current = this.salePolicyVoService.create(salePolicyJson);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u4e00\u4e2a\u5df2\u6709\u7684SalePolicy\u6a21\u578b\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u5c5e\u6027\u5fc5\u987b\u6709\u503c\u3002")
    @PatchMapping(value={""})
    public Result<?> update(@RequestBody @ApiParam(name="salePolicyJson", value="\u66f4\u65b0\u4e00\u4e2a\u65b0\u7684SalePolicy\u6a21\u578b\u5bf9\u8c61\uff08JSON\u7ed3\u6784\u662f\u52a8\u6001\u7684\u5305\u62ec\u4e86\u53ef\u80fd\u7684\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8c03\u7528\u3001\u590d\u6742\u903b\u8f91\u5904\u7406\u7b49\uff09") JSONObject salePolicyJson) {
        try {
            SalePolicyVo current = this.salePolicyVoService.update(salePolicyJson);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u7684\u8425\u9500\u6d3b\u52a8\u4e0b\u67b6\uff08\u4e5f\u5c31\u662f\u5c06effective\u6807\u8bb0\u8bbe\u7f6e\u4e3afalse\uff09")
    @PostMapping(value={"invalid"})
    public Result<?> invalid(@RequestParam(value="salePolicyCodes") @ApiParam(name="salePolicyCodes", value="\u8425\u9500\u6d3b\u52a8\u7684\u4e1a\u52a1\u7f16\u53f7") String[] salePolicyCodes) {
        try {
            this.salePolicyVoService.invalid(salePolicyCodes);
            return Result.ok();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u7684\u8425\u9500\u6d3b\u52a8\u4e0b\u67b6\uff08\u4e5f\u5c31\u662f\u5c06effective\u6807\u8bb0\u8bbe\u7f6e\u4e3atrue\uff09")
    @PostMapping(value={"effective"})
    public Result<?> effective(@RequestParam(value="salePolicyCodes") @ApiParam(name="salePolicyCodes", value="\u8425\u9500\u6d3b\u52a8\u7684\u4e1a\u52a1\u7f16\u53f7") String[] salePolicyCodes) {
        try {
            this.salePolicyVoService.effective(salePolicyCodes);
            return Result.ok();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be5\u65b9\u6cd5\u53ef\u7528\u4e8e\u7269\u7406\u5220\u9664\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\uff0c\u4f46\u662f\u53ea\u6709\u90a3\u4e9b\u6ca1\u6709\u5f00\u59cb\u6267\u884c\u3001\u6ca1\u6709\u5173\u8054\u4f18\u60e0\u653f\u7b56\u6267\u884c\u6d41\u6c34\u7684\u4f18\u60e0\u653f\u7b56\uff0c\u53ef\u4ee5\u88ab\u5220\u9664")
    @PostMapping(value={"deleteBySalePolicyCode"})
    public Result<?> deleteBySalePolicyCode(@RequestParam(value="salePolicyCode") String salePolicyCode) {
        try {
            this.salePolicyVoService.deleteBySalePolicyCode(salePolicyCode);
            return Result.ok();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8fdb\u884c\u5f53\u524d\u79df\u6237\u6240\u6709\u4f18\u60e0\u653f\u7b56\u4fe1\u606f\u7f13\u5b58\u7684\u5237\u65b0\uff0c\u4ee5\u4fdd\u8bc1\u6570\u636e\u5e93\u4e2d\u6700\u65b0\u7684\u4f18\u60e0\u653f\u7b56\u6570\u636e\u8fdb\u884c\u52a0\u8f7d\u540c\u6b65")
    @PostMapping(value={"refresh"})
    public Result<?> refresh() {
        try {
            String tenantCode = TenantUtils.getTenantCode();
            this.salePolicyCacheLoadingService.notifyCacheRefresh(tenantCode);
            return Result.ok();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7cfb\u7edf\u5df2\u7ecf\u652f\u6301\u7684\u5728\u4f18\u60e0\u653f\u7b56\u7ba1\u7406\u4e2d\uff0c\u786e\u5b9a\u5ba2\u6237\u8303\u56f4\u7684\u7b56\u7565\u4fe1\u606f")
    @GetMapping(value={"findDetailsByCode"})
    public Result<SalePolicyVo> findDetailsByCode(@RequestParam(value="salePolicyCode") String salePolicyCode) {
        try {
            SalePolicyVo salePolicyVo = this.salePolicyVoService.findDetailsByCode(salePolicyCode);
            return Result.ok((Object)salePolicyVo);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7cfb\u7edf\u5df2\u7ecf\u652f\u6301\u7684\u5728\u4f18\u60e0\u653f\u7b56\u7ba1\u7406\u4e2d\uff0c\u786e\u5b9a\u5ba2\u6237\u8303\u56f4\u7684\u7b56\u7565\u4fe1\u606f\uff08\u591a\u4e2a\uff09")
    @GetMapping(value={"findDetailsByCodes"})
    public Result<List<SalePolicyVo>> findDetailsByCodes(@RequestParam(value="salePolicyCodes") List<String> salePolicyCodes) {
        try {
            ArrayList results = Lists.newArrayList();
            for (String salePolicyCode : salePolicyCodes) {
                SalePolicyVo salePolicyVo = this.salePolicyVoService.findDetailsByCode(salePolicyCode);
                if (salePolicyVo == null) continue;
                results.add(salePolicyVo);
            }
            return Result.ok((Object)results);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u548c\u6307\u5b9a\u5546\u54c1\u5339\u914d\u7684\u6b63\u5728\u8fdb\u884c\u7684\u8425\u9500\u6d3b\u52a8\u4fe1\u606f\uff08\u591a\u4e2a\uff09\u3002 ")
    @GetMapping(value={"findDetailsByProcessingAndCustomerCodesAndProductCode"})
    public Result<List<SalePolicyVo>> findDetailsByProcessingAndCustomerCodesAndProductCode(@RequestParam(value="productCode") String productCode, @RequestParam(value="customerCode") String customerCode) {
        try {
            ArrayList results = Lists.newArrayList();
            String tenantCode = TenantUtils.getTenantCode();
            Set salePolicySet = this.salePolicyVoService.findDetailsByProcessingAndCustomerCodesAndProductCodes(tenantCode, true, customerCode, null, new String[]{productCode});
            if (!CollectionUtils.isEmpty((Collection)salePolicySet)) {
                results.addAll(salePolicySet);
            }
            return Result.ok((Object)results);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u9488\u5bf9\u7279\u5b9a\u4e8c\u7ea7\u79df\u6237\u7684\u5df2\u5b58\u5728\u7684\u4f18\u60e0\u653f\u7b56\u5206\u9875\u67e5\u8be2\u4fe1\u606f\u3002")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<SalePolicyVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u5206\u9875Dto") SalePolicyPageDto dto) {
        try {
            Page results = this.salePolicyVoService.findByConditions(pageable, dto);
            return Result.ok((Object)results);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

