/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.executestrategy;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.dms.business.policy.local.context.DefaultCycleExecuteContext;
import com.biz.crm.dms.business.policy.local.context.DefaultPolicyExecuteContext;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutor;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutorLadder;
import com.biz.crm.dms.business.policy.local.executestrategy.AbstractExecuteStrategy;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyExecutorLadderGiftRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyExecutorLadderRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyExecutorLadderVarRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyExecutorRepository;
import com.biz.crm.dms.business.policy.local.service.SalePolicyExecutorService;
import com.biz.crm.dms.business.policy.local.utils.AnalyzeExpressionUtils;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorLadderVarVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorLadderVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.ProductPolicyStepResult;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractStandardExecuteStrategy
extends AbstractExecuteStrategy {
    @Autowired(required=false)
    private SalePolicyExecutorRepository salePolicyExecutorRepository;
    @Autowired(required=false)
    private SalePolicyExecutorLadderRepository salePolicyExecutorLadderRepository;
    @Autowired(required=false)
    private SalePolicyExecutorLadderGiftRepository salePolicyExecutorLadderGiftRepository;
    @Autowired(required=false)
    private SalePolicyExecutorLadderVarRepository salePolicyExecutorLadderVarRepository;
    @Autowired(required=false)
    protected NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    protected SalePolicyExecutorService salePolicyExecutorService;

    protected abstract String getExecuteStrategyCode();

    protected abstract String getExpression();

    protected DefaultCycleExecuteContext buildDefaultCycleExecuteContext(String executorCode, AbstractPolicyExecuteContext abstractExecuteContext, Set<SalePolicyConProduct> initPolicyProducts, String customerCode) {
        DefaultPolicyExecuteContext executeContext = (DefaultPolicyExecuteContext)abstractExecuteContext;
        BigDecimal initSubtotalAmountForCycleExecutes = BigDecimal.ZERO;
        BigDecimal initSubtotalNumberForCycleExecutes = BigDecimal.ZERO;
        BigDecimal preSubtotalAmountForCycleExecutes = BigDecimal.ZERO;
        BigDecimal preSurplusSubtotalAmountForCycleExecutes = BigDecimal.ZERO;
        BigDecimal preSurplusSubtotalNumberForCycleExecutes = BigDecimal.ZERO;
        LinkedHashSet policyProductsForCycleExecutes = Sets.newLinkedHashSet();
        Iterator<SalePolicyConProduct> iterator = initPolicyProducts.iterator();
        while (iterator.hasNext()) {
            SalePolicyConProduct abstractPolicyConProduct;
            SalePolicyConProduct policyProductForCycleExecutes = abstractPolicyConProduct = iterator.next();
            policyProductsForCycleExecutes.add(policyProductForCycleExecutes);
            ProductPolicyStepResult productPolicyStepResult = executeContext.findLastProductStepResultByProductCode(policyProductForCycleExecutes.getProductCode());
            initSubtotalAmountForCycleExecutes = initSubtotalAmountForCycleExecutes.add(productPolicyStepResult.getInitSubtotal());
            initSubtotalNumberForCycleExecutes = initSubtotalNumberForCycleExecutes.add(new BigDecimal(productPolicyStepResult.getInitNumbers()));
            preSubtotalAmountForCycleExecutes = preSubtotalAmountForCycleExecutes.add(productPolicyStepResult.getLastSubtotal());
            preSurplusSubtotalAmountForCycleExecutes = preSurplusSubtotalAmountForCycleExecutes.add(productPolicyStepResult.getLastSurplusTotalAmount());
            preSurplusSubtotalNumberForCycleExecutes = preSurplusSubtotalNumberForCycleExecutes.add(new BigDecimal(productPolicyStepResult.getLastSurplusTotalNumber()));
        }
        DefaultCycleExecuteContext cycleExecuteContext = new DefaultCycleExecuteContext(executorCode, customerCode, policyProductsForCycleExecutes, initSubtotalAmountForCycleExecutes, initSubtotalNumberForCycleExecutes.intValue(), preSubtotalAmountForCycleExecutes, preSurplusSubtotalAmountForCycleExecutes, preSurplusSubtotalNumberForCycleExecutes.intValue());
        return cycleExecuteContext;
    }

    protected abstract boolean execute(AbstractCycleExecuteContext var1, int var2, int var3, Map<String, Object> var4, SalePolicyExecutorLadderVo var5);

    public boolean execute(AbstractCycleExecuteContext abstractCycleExecuteContext, int index, int times, AbstractSalePolicyExecutorInfo correctAbstractExecutorInfo) {
        SalePolicyExecutorVo correctExecutorInfo = (SalePolicyExecutorVo)correctAbstractExecutorInfo;
        Set<SalePolicyExecutorLadderVo> salePolicyExecutorLadders = correctExecutorInfo.getSalePolicyExecutorLadders();
        SalePolicyExecutorLadderVo salePolicyExecutorLadder = (SalePolicyExecutorLadderVo)((Object)Lists.newArrayList(salePolicyExecutorLadders).get(index));
        Set<SalePolicyExecutorLadderVarVo> vars = salePolicyExecutorLadder.getExecutorLadderVars();
        Map<String, Object> varParams = super.mappingVariableValues(vars);
        return this.execute(abstractCycleExecuteContext, index, times, varParams, salePolicyExecutorLadder);
    }

    protected void handleSaveSalePolicyExecutorInfo(boolean update, SalePolicyVo currentSalePolicy, SalePolicyVo oldSalePolicy, Set<SalePolicyExecutorVo> salePolicyExecutorInfoVos) {
        Collection salePolicyExecutors;
        long count;
        Set exsitSalePolicyExecutors;
        if (update && !CollectionUtils.isEmpty((Collection)(exsitSalePolicyExecutors = oldSalePolicy.getSalePolicyExecutorInfos()))) {
            String[] existSalePolicyExecutorLadderIds;
            Object[] salePolicyExecutorIds = (String[])exsitSalePolicyExecutors.stream().map(UuidVo::getId).toArray(String[]::new);
            List<SalePolicyExecutorLadder> exsitSalePolicyExecutorLadders = this.salePolicyExecutorLadderRepository.findBySalePolicyExecutorIds((String[])salePolicyExecutorIds);
            if (!CollectionUtils.isEmpty(exsitSalePolicyExecutorLadders) && (existSalePolicyExecutorLadderIds = (String[])exsitSalePolicyExecutorLadders.stream().map(UuidEntity::getId).toArray(String[]::new)) != null && existSalePolicyExecutorLadderIds.length > 0) {
                this.salePolicyExecutorLadderGiftRepository.deleteByExecutorLadderIds(existSalePolicyExecutorLadderIds);
                this.salePolicyExecutorLadderVarRepository.deleteByExecutorLadderIds(existSalePolicyExecutorLadderIds);
            }
            this.salePolicyExecutorLadderRepository.deleteBySalePolicyExecutorIds((String[])salePolicyExecutorIds);
            this.salePolicyExecutorRepository.deleteByIds(Sets.newHashSet((Object[])salePolicyExecutorIds));
        }
        Validate.isTrue(((count = (salePolicyExecutors = this.nebulaToolkitService.copyCollectionByWhiteList(salePolicyExecutorInfoVos, SalePolicyExecutorVo.class, SalePolicyExecutor.class, LinkedHashSet.class, ArrayList.class, new String[]{"salePolicyExecutorLadders", "salePolicyExecutorLadders.executorLadderVars", "salePolicyExecutorLadders.executorLadderGifts"})).stream().filter(item -> StringUtils.isBlank((CharSequence)item.getExecutorCode())).count()) == 0L ? 1 : 0) != 0, (String)"\u5f53\u4fdd\u5b58\u4f18\u60e0\u653f\u7b56\u4e2d\u7684\u6267\u884c\u7b56\u7565\u4fe1\u606f\u65f6\uff0c\u5176\u4e2d\u7684\u6267\u884c\u4fe1\u606f\u4e1a\u52a1\u7f16\u53f7executorCode\u5fc5\u987b\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        count = salePolicyExecutors.stream().map(SalePolicyExecutor::getExecutorCode).distinct().count();
        Validate.isTrue((count == (long)salePolicyExecutors.size() ? 1 : 0) != 0, (String)"\u5f53\u4fdd\u5b58\u4f18\u60e0\u653f\u7b56\u4e2d\u7684\u6267\u884c\u7b56\u7565\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u6709\u4e24\u7ec4\u6267\u884c\u4fe1\u606f\u7684\u4e1a\u52a1\u7f16\u53f7executorCode\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (SalePolicyExecutor salePolicyExecutor : salePolicyExecutors) {
            if (!StringUtils.equals((CharSequence)salePolicyExecutor.getExecuteStrategyCode(), (CharSequence)this.getExecuteStrategyCode())) continue;
            this.salePolicyExecutorService.create(salePolicyExecutor);
        }
    }

    protected void validatetExpressionParams(SalePolicyVo currentSalePolicy) {
        Set salePolicyExecutorInfos = currentSalePolicy.getSalePolicyExecutorInfos();
        Map<Integer, String> expressionParamMapping = AnalyzeExpressionUtils.analyzeLadderExpressionMapping(this.getExpression());
        if (CollectionUtils.isEmpty(expressionParamMapping)) {
            return;
        }
        Set expressionParamNames = expressionParamMapping.values().stream().distinct().collect(Collectors.toSet());
        for (AbstractSalePolicyExecutorInfo abstractSalePolicyExecutorInfo : salePolicyExecutorInfos) {
            SalePolicyExecutorVo salePolicyExecutorInfo = (SalePolicyExecutorVo)abstractSalePolicyExecutorInfo;
            if (!StringUtils.equals((CharSequence)salePolicyExecutorInfo.getExecuteStrategyCode(), (CharSequence)this.getExecuteStrategyCode())) continue;
            Set<SalePolicyExecutorLadderVo> salePolicyExecutorLadders = salePolicyExecutorInfo.getSalePolicyExecutorLadders();
            Iterator<SalePolicyExecutorLadderVo> iterator = salePolicyExecutorLadders.iterator();
            for (int ladderIndex = 0; ladderIndex < salePolicyExecutorLadders.size(); ++ladderIndex) {
                SalePolicyExecutorLadderVo salePolicyExecutorLadder = iterator.next();
                Set<SalePolicyExecutorLadderVarVo> ladderVars = salePolicyExecutorLadder.getExecutorLadderVars();
                Validate.isTrue((!CollectionUtils.isEmpty(ladderVars) ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u6b63\u786e\u7684\u89e3\u4f53\u53d8\u91cf\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                Set ladderVarNames = ladderVars.stream().map(SalePolicyExecutorLadderVarVo::getVariableName).collect(Collectors.toSet());
                Validate.isTrue((boolean)Sets.difference(expressionParamNames, ladderVarNames).isEmpty(), (String)"\u9636\u68af\u53d8\u91cf\u540d\u5339\u914d\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            }
        }
    }
}

