/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.limitstrategy;

import com.alibaba.fastjson.JSON;
import com.biz.crm.dms.business.policy.local.context.DefaultPolicyExecuteContext;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyLimit;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyLimitVar;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecord;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecordProduct;
import com.biz.crm.dms.business.policy.local.service.SalePolicyLimitService;
import com.biz.crm.dms.business.policy.local.service.SalePolicyLimitVarService;
import com.biz.crm.dms.business.policy.local.utils.AnalyzeExpressionUtils;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyLimitVarVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyLimitVo;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyLimitInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractBaseSalePolicyLimitStrategy
implements SalePolicyLimitStrategy<SalePolicyLimitVo> {
    private static final Logger log = LoggerFactory.getLogger(AbstractBaseSalePolicyLimitStrategy.class);
    @Autowired(required=false)
    private SalePolicyLimitService salePolicyLimitService;
    @Autowired(required=false)
    private SalePolicyLimitVarService salePolicyLimitVarService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    protected static final String AMOUNT_LIMIT_VAR_KEY = "amountLimitValue";
    protected static final String QUANTITY_LIMIT_VAR_KEY = "quantityLimitValue";

    public Class<SalePolicyLimitVo> getSalePolicyLimitInfoClass() {
        return SalePolicyLimitVo.class;
    }

    public SalePolicyLimitVo onRequestSalePolicyLimitInfos(String salePolicyCode) {
        Validate.notBlank((CharSequence)salePolicyCode, (String)"\u4fc3\u9500\u653f\u7b56\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.getLimitStrategyCode(), (String)"\u9650\u91cf\u653f\u7b56\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        SalePolicyLimit salePolicyLimit = this.salePolicyLimitService.findBySalePolicyCodeAndTenantCodeAndLimitStrategyCode(salePolicyCode, TenantUtils.getTenantCode(), this.getLimitStrategyCode());
        if (salePolicyLimit == null) {
            return null;
        }
        return (SalePolicyLimitVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)salePolicyLimit, SalePolicyLimitVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"limitVars"}));
    }

    @Transactional
    public void onSaveSalePolicyLimitInfos(boolean update, SalePolicyVo currentSalePolicy, SalePolicyVo oldSalePolicy) {
        AbstractSalePolicyLimitInfo oldPolicyLimitInfo;
        Set salePolicyLimitInfos;
        Validate.notBlank((CharSequence)this.getLimitStrategyCode(), (String)"\u9650\u91cf\u653f\u7b56\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.getExpression(), (String)"\u7ef4\u62a4\u4f18\u60e0\u653f\u7b56\u9650\u91cf\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u8868\u8fbe\u5f0f\u6ca1\u6709\u503c(%s)\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        if (update && !CollectionUtils.isEmpty((Collection)(salePolicyLimitInfos = oldSalePolicy.getSalePolicyLimitInfos())) && (oldPolicyLimitInfo = (AbstractSalePolicyLimitInfo)salePolicyLimitInfos.stream().filter(item -> StringUtils.equals((CharSequence)item.getLimitStrategyCode(), (CharSequence)this.getLimitStrategyCode())).findFirst().orElse(null)) != null) {
            Validate.notBlank((CharSequence)oldPolicyLimitInfo.getId(), (String)"\u4fee\u6539\u4f18\u60e0\u653f\u7b56\u9650\u91cf\u4fe1\u606f\u65f6\uff0c\u6ca1\u6709\u4f20\u51fa\u539f\u6765\u4f18\u60e0\u653f\u7b56\u9650\u91cf\u4fe1\u606f\u7684ID\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            this.salePolicyLimitVarService.deleteBySalePolicyLimitId(oldPolicyLimitInfo.getId());
            this.salePolicyLimitService.deleteByIds(Sets.newHashSet((Object[])new String[]{oldPolicyLimitInfo.getId()}));
        }
        String salePolicyCode = currentSalePolicy.getSalePolicyCode();
        String tenantCode = currentSalePolicy.getTenantCode();
        Set salePolicyLimitInfos2 = currentSalePolicy.getSalePolicyLimitInfos();
        if (CollectionUtils.isEmpty((Collection)salePolicyLimitInfos2)) {
            return;
        }
        AbstractSalePolicyLimitInfo currentPolicyLimitInfo = salePolicyLimitInfos2.stream().filter(item -> StringUtils.equals((CharSequence)item.getLimitStrategyCode(), (CharSequence)this.getLimitStrategyCode())).findFirst().orElse(null);
        if (currentPolicyLimitInfo == null) {
            return;
        }
        SalePolicyLimitVo salePolicyLimitInfoVo = (SalePolicyLimitVo)currentPolicyLimitInfo;
        String limitStrategyCode = salePolicyLimitInfoVo.getLimitStrategyCode();
        Validate.notBlank((CharSequence)limitStrategyCode, (String)"\u7ef4\u62a4\u4f18\u60e0\u653f\u7b56\u9650\u91cf\u4fe1\u606f\u65f6\uff0c\u6ca1\u6709\u4f20\u51fa\u4f18\u60e0\u653f\u7b56\u9650\u91cf\u4fe1\u606f\u7684\u4e1a\u52a1\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        if (!update) {
            SalePolicyLimit exsitSalePolicyLimit = this.salePolicyLimitService.findBySalePolicyCodeAndTenantCodeAndLimitStrategyCode(salePolicyCode, tenantCode, limitStrategyCode);
            Validate.isTrue((exsitSalePolicyLimit == null ? 1 : 0) != 0, (String)"\u7ef4\u62a4\u4f18\u60e0\u653f\u7b56\u9650\u91cf\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u7279\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u4e0b\u5b58\u5728\u91cd\u590d\u7684\u9650\u91cf\u653f\u7b56\u4fe1\u606f\uff08%s\uff09\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{limitStrategyCode});
        }
        salePolicyLimitInfoVo.setSalePolicyCode(salePolicyCode);
        salePolicyLimitInfoVo.setTenantCode(tenantCode);
        salePolicyLimitInfoVo.setId(null);
        Set<SalePolicyLimitVarVo> salePolicyLimitVarVos = salePolicyLimitInfoVo.getLimitVars();
        this.validateVars(limitStrategyCode, salePolicyLimitVarVos);
        SalePolicyLimit salePolicyLimitInfo = (SalePolicyLimit)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)salePolicyLimitInfoVo, SalePolicyLimit.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.salePolicyLimitService.create(salePolicyLimitInfo);
        salePolicyLimitInfoVo.setId(salePolicyLimitInfo.getId());
        if (!CollectionUtils.isEmpty(salePolicyLimitVarVos)) {
            for (SalePolicyLimitVarVo salePolicyLimitVarVo : salePolicyLimitVarVos) {
                SalePolicyLimitVar salePolicyLimitVar = (SalePolicyLimitVar)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)salePolicyLimitVarVo, SalePolicyLimitVar.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                salePolicyLimitVar.setSalePolicyLimit(salePolicyLimitInfo);
                salePolicyLimitVar.setSalePolicyLimitId(salePolicyLimitInfo.getId());
                this.salePolicyLimitVarService.create(salePolicyLimitVar);
                salePolicyLimitVarVo.setId(salePolicyLimitVar.getId());
            }
        }
    }

    public void preValidate(AbstractPolicyExecuteContext policyExecuteContext, AbstractCycleExecuteContext cycleExecuteContext, SalePolicyVo currentSalePolicy, AbstractSalePolicyLimitInfo salePolicyLimitInfo) {
    }

    @Transactional
    public void validate(AbstractPolicyExecuteContext policyExecuteContext, AbstractCycleExecuteContext cycleExecuteContext, SalePolicyVo currentSalePolicy, AbstractSalePolicyLimitInfo salePolicyLimitInfo) {
        this.preValidate(policyExecuteContext, cycleExecuteContext, currentSalePolicy, salePolicyLimitInfo);
    }

    protected void amountValidate(AbstractPolicyExecuteContext policyExecuteContext, AbstractCycleExecuteContext cycleExecuteContext, SalePolicyVo currentSalePolicy, String varValue, Set<SalePolicyRecord> salePolicyRecords) {
        AtomicReference<BigDecimal> recordAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        if (CollectionUtils.isNotEmpty(salePolicyRecords)) {
            salePolicyRecords.forEach(r -> {
                BigDecimal item = Optional.ofNullable(r.getSalePolicyRecordProducts()).orElse(Sets.newHashSet()).stream().filter(s -> StringUtils.equals((CharSequence)currentSalePolicy.getSalePolicyCode(), (CharSequence)s.getSalePolicyCode())).map(SalePolicyRecordProduct::getDiffLastSubtotal).reduce(BigDecimal.ZERO, BigDecimal::add);
                recordAmount.set(((BigDecimal)recordAmount.get()).add(item));
            });
        }
        DefaultPolicyExecuteContext executeContext = (DefaultPolicyExecuteContext)policyExecuteContext;
        BigDecimal currentAmount = executeContext.findEnjoyedTotalAmount(currentSalePolicy.getSalePolicyCode());
        BigDecimal totalAmount = currentAmount.add(recordAmount.get());
        log.info("\u3010\u672c\u54c1\u3011\u4e0a\u4e0b\u6587\u603b\u91d1\u989d\uff1a{}\uff0c\u5386\u53f2\u603b\u91d1\u989d\uff1a{}\uff0c\u6700\u7ec8\u6c47\u603b\u91d1\u989d\uff1a{}\uff0c\u8bbe\u5b9a\u91d1\u989d\uff1a{}", new Object[]{currentAmount, recordAmount.get(), totalAmount, varValue});
        BigDecimal settingAmount = new BigDecimal(varValue);
        Validate.isTrue((settingAmount.compareTo(totalAmount) >= 0 ? 1 : 0) != 0, (String)String.format("%s\u8d85\u51fa\u8bbe\u5b9a\u9650\u91cf\u989d\uff1a%s\uff0c\u5f53\u524d\u5269\u4f59\uff1a%s", this.getLimitStrategyDesc(), varValue, settingAmount.subtract(recordAmount.get())), (Object[])new Object[0]);
    }

    public void quantityValidate(AbstractPolicyExecuteContext policyExecuteContext, AbstractCycleExecuteContext cycleExecuteContext, SalePolicyVo currentSalePolicy, String varValue, Set<SalePolicyRecord> salePolicyRecords) {
        AtomicReference<Integer> recordQuantity = new AtomicReference<Integer>(0);
        if (CollectionUtils.isNotEmpty(salePolicyRecords)) {
            salePolicyRecords.forEach(r -> {
                Integer item = Optional.ofNullable(r.getSalePolicyRecordProducts()).orElse(Sets.newHashSet()).stream().filter(s -> StringUtils.equals((CharSequence)currentSalePolicy.getSalePolicyCode(), (CharSequence)s.getSalePolicyCode())).mapToInt(SalePolicyRecordProduct::getDiffSurplusTotalNumber).sum();
                recordQuantity.set((Integer)recordQuantity.get() + item);
            });
        }
        DefaultPolicyExecuteContext executeContext = (DefaultPolicyExecuteContext)policyExecuteContext;
        Integer currentQuantity = executeContext.findEnjoyedTotalNumber(currentSalePolicy.getSalePolicyCode());
        int totalQuantity = currentQuantity + recordQuantity.get();
        log.info("\u3010\u672c\u54c1\u3011\u4e0a\u4e0b\u6587\u603b\u6570\u91cf\uff1a{}\uff0c\u5386\u53f2\u603b\u6570\u91cf\uff1a{}\uff0c\u6700\u7ec8\u6c47\u603b\u6570\u91cf\uff1a{}\uff0c\u8bbe\u5b9a\u6570\u91cf\uff1a{}", new Object[]{currentQuantity, recordQuantity.get(), totalQuantity, varValue});
        int settingQuantity = Integer.parseInt(varValue);
        Validate.isTrue((settingQuantity >= totalQuantity ? 1 : 0) != 0, (String)String.format("%s\u8d85\u51fa\u8bbe\u5b9a\u9650\u91cf\u989d\uff1a%s\uff0c\u5f53\u524d\u5269\u4f59\uff1a%s", this.getLimitStrategyDesc(), varValue, settingQuantity - recordQuantity.get()), (Object[])new Object[0]);
    }

    protected void amountValidateGift(AbstractPolicyExecuteContext policyExecuteContext, AbstractCycleExecuteContext cycleExecuteContext, SalePolicyVo currentSalePolicy, String varValue, Set<SalePolicyRecord> salePolicyRecords) {
        AtomicReference<BigDecimal> recordAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        if (CollectionUtils.isNotEmpty(salePolicyRecords)) {
            salePolicyRecords.forEach(r -> {
                BigDecimal item = Optional.ofNullable(r.getSalePolicyRecordProducts()).orElse(Sets.newHashSet()).stream().filter(s -> StringUtils.equals((CharSequence)currentSalePolicy.getSalePolicyCode(), (CharSequence)s.getSalePolicyCode())).map(SalePolicyRecordProduct::getDiffGiftEnjoyedTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                recordAmount.set(((BigDecimal)recordAmount.get()).add(item));
            });
        }
        DefaultPolicyExecuteContext executeContext = (DefaultPolicyExecuteContext)policyExecuteContext;
        BigDecimal currentAmount = executeContext.findGiftEnjoyedTotalAmount(currentSalePolicy.getSalePolicyCode());
        BigDecimal totalAmount = currentAmount.add(recordAmount.get());
        log.info("\u3010\u8d60\u54c1\u3011\u4e0a\u4e0b\u6587\u603b\u91d1\u989d\uff1a{}\uff0c\u5386\u53f2\u603b\u91d1\u989d\uff1a{}\uff0c\u6700\u7ec8\u6c47\u603b\u91d1\u989d\uff1a{}\uff0c\u8bbe\u5b9a\u91d1\u989d\uff1a{}", new Object[]{currentAmount, recordAmount.get(), totalAmount, varValue});
        BigDecimal settingAmount = new BigDecimal(varValue);
        Validate.isTrue((settingAmount.compareTo(totalAmount) >= 0 ? 1 : 0) != 0, (String)String.format("%s\u8d85\u51fa\u8bbe\u5b9a\u9650\u91cf\u989d\uff1a%s\uff0c\u5f53\u524d\u5269\u4f59\uff1a%s", this.getLimitStrategyDesc(), varValue, settingAmount.subtract(recordAmount.get())), (Object[])new Object[0]);
    }

    public void quantityValidateGift(AbstractPolicyExecuteContext policyExecuteContext, AbstractCycleExecuteContext cycleExecuteContext, SalePolicyVo currentSalePolicy, String varValue, Set<SalePolicyRecord> salePolicyRecords) {
        AtomicReference<Integer> recordQuantity = new AtomicReference<Integer>(0);
        if (CollectionUtils.isNotEmpty(salePolicyRecords)) {
            salePolicyRecords.forEach(r -> {
                Integer item = Optional.ofNullable(r.getSalePolicyRecordProducts()).orElse(Sets.newHashSet()).stream().filter(s -> StringUtils.equals((CharSequence)currentSalePolicy.getSalePolicyCode(), (CharSequence)s.getSalePolicyCode())).mapToInt(SalePolicyRecordProduct::getDiffGiftEnjoyedTotalNumber).sum();
                recordQuantity.set((Integer)recordQuantity.get() + item);
            });
        }
        DefaultPolicyExecuteContext executeContext = (DefaultPolicyExecuteContext)policyExecuteContext;
        Integer currentQuantity = executeContext.findGiftEnjoyedTotalNumber(currentSalePolicy.getSalePolicyCode());
        int totalQuantity = currentQuantity + recordQuantity.get();
        log.info("\u3010\u8d60\u54c1\u3011\u4e0a\u4e0b\u6587\u603b\u6570\u91cf\uff1a{}\uff0c\u5386\u53f2\u603b\u6570\u91cf\uff1a{}\uff0c\u6700\u7ec8\u6c47\u603b\u6570\u91cf\uff1a{}\uff0c\u8bbe\u5b9a\u6570\u91cf\uff1a{}", new Object[]{currentQuantity, recordQuantity.get(), totalQuantity, varValue});
        int settingQuantity = Integer.parseInt(varValue);
        Validate.isTrue((settingQuantity >= totalQuantity ? 1 : 0) != 0, (String)String.format("%s\u8d85\u51fa\u8bbe\u5b9a\u9650\u91cf\u989d\uff1a%s\uff0c\u5f53\u524d\u5269\u4f59\uff1a%s", this.getLimitStrategyDesc(), varValue, settingQuantity - recordQuantity.get()), (Object[])new Object[0]);
    }

    protected void validateVars(String limitStrategyCode, Set<SalePolicyLimitVarVo> salePolicyLimitVarVos) {
        String expression = this.getExpression();
        Map<Integer, String> mustVarNames = AnalyzeExpressionUtils.analyzeLadderExpressionMapping(expression);
        if (mustVarNames.isEmpty()) {
            Validate.isTrue((boolean)CollectionUtils.isEmpty(salePolicyLimitVarVos), (String)"\u7ef4\u62a4\u4f18\u60e0\u653f\u7b56\u9650\u91cf\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u5f53\u524d\u9650\u91cf\u653f\u7b56\uff08%s\uff09\u65e0\u9700\u4f20\u9012\u4efb\u4f55\u53d8\u91cf\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{limitStrategyCode});
            return;
        }
        HashSet mustVarNameSet = new HashSet();
        mustVarNames.forEach((k, v) -> mustVarNameSet.add(v));
        Set inputVarNames = salePolicyLimitVarVos.stream().map(SalePolicyLimitVarVo::getVariableName).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        Validate.isTrue((mustVarNames.size() == inputVarNames.size() ? 1 : 0) != 0, (String)"\u7ef4\u62a4\u4f18\u60e0\u653f\u7b56\u9650\u91cf\u4fe1\u606f\u65f6\uff0c\u73b0\u5728\u5f53\u524d\u9650\u91cf\u653f\u7b56\uff08%s\uff09\u4f20\u9012\u4e86\u65e0\u6548\u7684\u53d8\u91cf\u4fe1\u606f\uff08\u6216\u4e3a\u7a7a\u6216\u91cd\u590d\uff09\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{limitStrategyCode});
        Sets.SetView differenceSet = Sets.difference(inputVarNames, mustVarNameSet);
        Validate.isTrue((boolean)differenceSet.isEmpty(), (String)"\u7ef4\u62a4\u4f18\u60e0\u653f\u7b56\u9650\u91cf\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u9700\u8981\u586b\u5199\u7684\u53d8\u91cf\u4fe1\u606f(%s)\uff0c\u5e76\u6ca1\u6709\u586b\u5199\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{StringUtils.join((Object[])differenceSet.toArray((Object[])new String[0]), (String)",")});
        String pattern = "^[A-Za-z]{1}[A-Za-z0-9]*$";
        for (SalePolicyLimitVarVo salePolicyLimitVarVo : salePolicyLimitVarVos) {
            Integer variableType = salePolicyLimitVarVo.getVariableType();
            Validate.inclusiveBetween((long)1L, (long)4L, (long)variableType.intValue(), (String)"\u7ef4\u62a4\u4f18\u60e0\u653f\u7b56\u9650\u91cf\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u53d8\u91cf\uff08%s\uff09\u4e0d\u7b26\u5408\u53d8\u91cf\u7c7b\u578b\u8981\u6c42\uff081\uff1aboolean\u30012\uff1a\u5c0f\u6570\uff1b3\uff1a\u6574\u6570\uff1b4\uff1a\u5b57\u7b26\u4e32\uff09\uff0c\u8bf7\u68c0\u67e5\uff01");
            String variableName = salePolicyLimitVarVo.getVariableName();
            Validate.matchesPattern((CharSequence)variableName, (String)pattern, (String)"\u7ef4\u62a4\u4f18\u60e0\u653f\u7b56\u9650\u91cf\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u53d8\u91cf\uff08%s\uff09\u4e0d\u7b26\u5408\u53d8\u91cf\u547d\u540d\u8981\u6c42\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{variableName});
            String variableValue = salePolicyLimitVarVo.getVariableValue();
            Validate.notBlank((CharSequence)variableValue, (String)"\u7ef4\u62a4\u4f18\u60e0\u653f\u7b56\u9650\u91cf\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u53d8\u91cf\uff08%s\uff09\u6ca1\u6709\u4f20\u5165\u503c\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{variableName});
            salePolicyLimitVarVo.setId(null);
        }
    }

    protected String getVarValue(AbstractSalePolicyLimitInfo salePolicyLimitInfo) {
        log.info("salePolicyLimitInfo:{}", (Object)JSON.toJSONString((Object)salePolicyLimitInfo));
        if (salePolicyLimitInfo == null) {
            return null;
        }
        SalePolicyLimitVo salePolicyLimitInfoVo = (SalePolicyLimitVo)salePolicyLimitInfo;
        Set<SalePolicyLimitVarVo> varVos = salePolicyLimitInfoVo.getLimitVars();
        if (CollectionUtils.isEmpty(varVos) || !varVos.iterator().hasNext()) {
            return null;
        }
        SalePolicyLimitVarVo salePolicyLimitVarVo = varVos.iterator().next();
        if (StringUtils.isBlank((CharSequence)salePolicyLimitVarVo.getVariableValue())) {
            return null;
        }
        return salePolicyLimitVarVo.getVariableValue();
    }
}

