/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.limitstrategy;

import com.biz.crm.dms.business.policy.local.context.DefaultPolicyExecuteContext;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecord;
import com.biz.crm.dms.business.policy.local.limitstrategy.AbstractBaseSalePolicyLimitStrategy;
import com.biz.crm.dms.business.policy.local.service.SalePolicyRecordService;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyLimitVo;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyLimitInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCustomerQuantityLimitStrategy
extends AbstractBaseSalePolicyLimitStrategy
implements SalePolicyLimitStrategy<SalePolicyLimitVo> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCustomerQuantityLimitStrategy.class);
    @Autowired(required=false)
    private SalePolicyRecordService salePolicyRecordService;

    @Override
    public void preValidate(AbstractPolicyExecuteContext policyExecuteContext, AbstractCycleExecuteContext cycleExecuteContext, SalePolicyVo currentSalePolicy, AbstractSalePolicyLimitInfo salePolicyLimitInfo) {
        String varValue = super.getVarValue(salePolicyLimitInfo);
        if (varValue == null) {
            log.warn("\u8bf7\u8bbe\u7f6e\u672c\u653f\u7b56\u6bcf\u5ba2\u5546\u54c1\u6570\u91cf\u4e0a\u9650\uff01");
            return;
        }
        DefaultPolicyExecuteContext executeContext = (DefaultPolicyExecuteContext)policyExecuteContext;
        Set<SalePolicyRecord> salePolicyRecords = this.salePolicyRecordService.findByTenantCodeAndSalePolicyCodeAndCustomerCode(executeContext.getTenantCode(), currentSalePolicy.getSalePolicyCode(), executeContext.getCustomerCode());
        log.info("AbstractCustomerQuantityLimitStrategy\uff1atenantCode={}, salePolicyCode={}, customerCode={}", new Object[]{executeContext.getTenantCode(), currentSalePolicy.getSalePolicyCode(), executeContext.getCustomerCode()});
        super.quantityValidate(policyExecuteContext, cycleExecuteContext, currentSalePolicy, varValue, salePolicyRecords);
    }
}

