/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.notifier;

import com.biz.crm.dms.business.policy.local.context.DefaultPolicyExecuteContext;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyThresholdDetail;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyThresholdDetailRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyThresholdProductRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyThresholdRepository;
import com.biz.crm.dms.business.policy.local.service.SalePolicyThresholdService;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyProductVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyThresholdDetailVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyThresholdProductVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyThresholdVo;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.PolicyStepResult;
import com.biz.crm.dms.business.policy.sdk.context.ProductPolicyStepResult;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.sdk.service.SalePolicyVoService;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyThreshold;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractSalePolicyStickupListener {
    @Autowired(required=false)
    private SalePolicyThresholdRepository salePolicyThresholdRepository;
    @Autowired(required=false)
    private SalePolicyThresholdDetailRepository salePolicyThresholdDetailRepository;
    @Autowired(required=false)
    private SalePolicyThresholdProductRepository salePolicyThresholdProductRepository;
    @Autowired(required=false)
    private SalePolicyThresholdService salePolicyThresholdService;
    @Autowired(required=false)
    private SalePolicyVoService salePolicyVoService;

    protected void onSaveSalePolicyProductThreshold(boolean update, SalePolicyVo currentSalePolicy, SalePolicyVo oldSalePolicy, SalePolicyThresholdVo salePolicyThreshold) {
        Collection<Object> salePolicyThresholdDetails;
        AbstractSalePolicyThreshold exsitSalePolicyThreshold;
        if (update && (exsitSalePolicyThreshold = oldSalePolicy.getSalePolicyProductThreshold()) != null) {
            salePolicyThresholdDetails = this.salePolicyThresholdDetailRepository.findBySalePolicyThresholdId(exsitSalePolicyThreshold.getId());
            if (!CollectionUtils.isEmpty(salePolicyThresholdDetails)) {
                for (SalePolicyThresholdDetail salePolicyThresholdDetail : salePolicyThresholdDetails) {
                    this.salePolicyThresholdProductRepository.deleteByThresholdDetailId(salePolicyThresholdDetail.getId());
                }
                this.salePolicyThresholdDetailRepository.deleteBySalePolicyThresholdId(exsitSalePolicyThreshold.getId());
            }
            this.salePolicyThresholdRepository.deleteById(exsitSalePolicyThreshold.getId());
        }
        String tenantCode = TenantUtils.getTenantCode();
        if (this.salePolicyThresholdService.findBySalePolicyCode(currentSalePolicy.getSalePolicyCode(), tenantCode) != null) {
            return;
        }
        salePolicyThresholdDetails = salePolicyThreshold.getThresholdDetails();
        if (!currentSalePolicy.getWholePolicy().booleanValue()) {
            Validate.isTrue((!CollectionUtils.isEmpty(salePolicyThresholdDetails) ? 1 : 0) != 0, (String)"\u7ef4\u62a4\u4f18\u60e0\u653f\u7b56\u95e8\u69db\u65f6\uff0c\u81f3\u5c11\u6709\u4e00\u6761\u4f18\u60e0\u653f\u7b56\u95e8\u69db\u8be6\u60c5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            if (salePolicyThresholdDetails.size() == 1) {
                Set salePolicyProducts = currentSalePolicy.getSalePolicyProductInfos();
                Validate.isTrue((!CollectionUtils.isEmpty((Collection)salePolicyProducts) ? 1 : 0) != 0, (String)"\u7ef4\u62a4\u5546\u54c1\u95e8\u69db\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u4f18\u60e0\u653f\u7b56\u4e2d\u7684\u5546\u54c1\u672c\u54c1\u4fe1\u606f\u6ca1\u6709\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                long l = salePolicyProducts.stream().filter(item -> StringUtils.isBlank((CharSequence)((SalePolicyProductVo)((Object)((Object)item))).getProductCode())).count();
                Validate.isTrue((l == 0L ? 1 : 0) != 0, (String)"\u7ef4\u62a4\u5546\u54c1\u95e8\u69db\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u4f18\u60e0\u653f\u7b56\u4e2d\u81f3\u5c11\u4e00\u6761\u5546\u54c1\u672c\u54c1\u4fe1\u606f\u7684\u4e1a\u52a1\u7f16\u7801\u6ca1\u6709\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                Set salePolicyProductCodes = salePolicyProducts.stream().map(item -> ((SalePolicyProductVo)((Object)((Object)item))).getProductCode()).distinct().collect(Collectors.toSet());
                Validate.isTrue((salePolicyProductCodes.size() == salePolicyProducts.size() ? 1 : 0) != 0, (String)"\u7ef4\u62a4\u5546\u54c1\u95e8\u69db\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u4f18\u60e0\u653f\u7b56\u4e2d\u81f3\u5c11\u4e24\u6761\u5546\u54c1\u672c\u54c1\u7684\u4e1a\u52a1\u7f16\u7801\u4fe1\u606f\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                List<SalePolicyThresholdProductVo> thresholdProducts = ((SalePolicyThresholdDetailVo)((Object)salePolicyThresholdDetails.iterator().next())).getThresholdProducts();
                Validate.isTrue((!CollectionUtils.isEmpty(thresholdProducts) ? 1 : 0) != 0, (String)"\u7ef4\u62a4\u5546\u54c1\u95e8\u69db\u4fe1\u606f\u65f6\uff0c\u6ca1\u6709\u53d1\u73b0\u4efb\u4f55\u95e8\u69db\u5546\u54c1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                l = thresholdProducts.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getProductCode())).count();
                Validate.isTrue((l == 0L ? 1 : 0) != 0, (String)"\u7ef4\u62a4\u5546\u54c1\u95e8\u69db\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u4f18\u60e0\u653f\u7b56\u4e2d\u81f3\u5c11\u4e00\u6761\u5546\u54c1\u95e8\u69db\u4fe1\u606f\u7684\u4e1a\u52a1\u7f16\u7801\u6ca1\u6709\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                Set thresholdProductCodes = thresholdProducts.stream().map(item -> item.getProductCode()).distinct().collect(Collectors.toSet());
                Validate.isTrue((thresholdProductCodes.size() == thresholdProducts.size() ? 1 : 0) != 0, (String)"\u7ef4\u62a4\u5546\u54c1\u95e8\u69db\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u4f18\u60e0\u653f\u7b56\u4e2d\u81f3\u5c11\u4e24\u6761\u95e8\u69db\u5546\u54c1\u7684\u4e1a\u52a1\u7f16\u7801\u4fe1\u606f\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                Validate.isTrue((Sets.difference(salePolicyProductCodes, thresholdProductCodes).isEmpty() && Sets.difference(thresholdProductCodes, salePolicyProductCodes).isEmpty() ? 1 : 0) != 0, (String)"\u7ef4\u62a4\u5546\u54c1\u95e8\u69db\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u4f18\u60e0\u653f\u7b56\u7684\u5546\u54c1\u4fe1\u606f\u548c\u5546\u54c1\u95e8\u69db\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                if (((SalePolicyThresholdDetailVo)((Object)salePolicyThresholdDetails.iterator().next())).getIncludeType() == 1) {
                    thresholdProducts.stream().forEach(item -> item.setCertain(true));
                }
            }
        }
        salePolicyThreshold.setSalePolicyCode(currentSalePolicy.getSalePolicyCode());
        this.salePolicyThresholdService.create(salePolicyThreshold);
    }

    /*
     * WARNING - void declaration
     */
    protected Pair<Map<String, Set<String>>, String> executeThreshold(Set<SalePolicyConProduct> policyConProducts, AbstractPolicyExecuteContext abstractPolicyExecuteContext, AbstractSalePolicyThreshold abstractSalePolicyThreshold) {
        void var18_25;
        DefaultPolicyExecuteContext executeContext = (DefaultPolicyExecuteContext)abstractPolicyExecuteContext;
        SalePolicyThresholdVo salePolicyThreshold = (SalePolicyThresholdVo)abstractSalePolicyThreshold;
        Integer composeNumber = salePolicyThreshold.getComposeNumber();
        Integer composeUnit = salePolicyThreshold.getComposeUnit();
        ArrayList salePolicyThresholdDetailVos = salePolicyThreshold.getThresholdDetails();
        Set thresholdProductCodes = policyConProducts.stream().map(SalePolicyConProduct::getProductCode).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(salePolicyThresholdDetailVos)) {
            for (SalePolicyThresholdDetailVo salePolicyThresholdDetail : salePolicyThresholdDetailVos) {
                List<SalePolicyThresholdProductVo> thresholdProducts = salePolicyThresholdDetail.getThresholdProducts();
                thresholdProductCodes.addAll(thresholdProducts.stream().map(SalePolicyThresholdProductVo::getProductCode).filter(currentProductCode -> thresholdProductCodes.contains(currentProductCode)).collect(Collectors.toSet()));
            }
        } else {
            salePolicyThresholdDetailVos = Lists.newArrayList();
        }
        BigDecimal productsTotalAmount = BigDecimal.ZERO;
        BigDecimal productsTotalNumber = BigDecimal.ZERO;
        for (String productCode : thresholdProductCodes) {
            ProductPolicyStepResult productPolicyStepResult = executeContext.findLastProductStepResultByProductCode(productCode);
            if (productPolicyStepResult == null) continue;
            BigDecimal lastSurplusSubtotal = productPolicyStepResult.getLastSurplusTotalAmount();
            Integer lastSurplusTotalNumber = productPolicyStepResult.getLastSurplusTotalNumber();
            productsTotalAmount = productsTotalAmount.add(lastSurplusSubtotal);
            productsTotalNumber = productsTotalNumber.add(new BigDecimal(lastSurplusTotalNumber));
        }
        boolean matched = false;
        if (composeUnit == 1) {
            matched = productsTotalAmount.intValue() >= composeNumber;
        } else {
            boolean bl = matched = productsTotalNumber.intValue() >= composeNumber;
        }
        if (!matched) {
            PolicyStepResult lastPolicyStepResult = abstractPolicyExecuteContext.findLastStepResult();
            if (lastPolicyStepResult == null || StringUtils.isBlank((CharSequence)lastPolicyStepResult.getSalePolicyCode())) {
                return Pair.of((Object)Maps.newHashMap(), (Object)"\u521d\u59cb\u91cf\u672a\u8fbe\u5230\u8be5\u4f18\u60e0\u653f\u7b56\u7684\u603b\u4f53\u95e8\u69db");
            }
            String lastPolicyCode = lastPolicyStepResult.getSalePolicyCode();
            SalePolicyVo currentSalePolicyVo = this.salePolicyVoService.findDetailsByCode(lastPolicyCode);
            if (currentSalePolicyVo == null) {
                return Pair.of((Object)Maps.newHashMap(), (Object)"(\u4e0a\u4e00\u4f18\u60e0\u653f\u7b56\u6267\u884c\u540e\u7684\u5269\u4f59\u91cf) \u672a\u8fbe\u5230\u8be5\u4f18\u60e0\u653f\u7b56\u7684\u603b\u4f53\u95e8\u69db");
            }
            return Pair.of((Object)Maps.newHashMap(), (Object)("(" + currentSalePolicyVo.getSalePolicyName() + " \u6267\u884c\u540e\u7684\u5269\u4f59\u91cf) \u672a\u8fbe\u5230\u8be5\u4f18\u60e0\u653f\u7b56\u7684\u603b\u4f53\u95e8\u69db"));
        }
        String salePolicyCode = salePolicyThreshold.getSalePolicyCode();
        HashMap failedThresholdDetailInfos = Maps.newHashMap();
        HashMap matchedThresholdDetailMappings = Maps.newHashMap();
        LinkedHashMap remainSourceProductMapping = Maps.newLinkedHashMap();
        for (SalePolicyConProduct salePolicyConProduct : policyConProducts) {
            ProductPolicyStepResult productPolicyStepResult = executeContext.findLastProductStepResultByProductCode(salePolicyConProduct.getProductCode());
            remainSourceProductMapping.put(salePolicyConProduct.getProductCode(), productPolicyStepResult);
        }
        Set remainSourceProductCodes = policyConProducts.stream().map(item -> item.getProductCode()).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty((Collection)salePolicyThresholdDetailVos)) {
            block3: for (SalePolicyThresholdDetailVo salePolicyThresholdDetailVo : salePolicyThresholdDetailVos) {
                Integer includeType = salePolicyThresholdDetailVo.getIncludeType();
                String thresholdDetailCode = salePolicyThresholdDetailVo.getThresholdDetailCode();
                if (includeType == null || includeType != 1 && includeType != 2) {
                    failedThresholdDetailInfos.put(thresholdDetailCode, String.format("\u5728\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u8ba1\u7b97/\u9884\u8ba1\u7b97\u65f6\uff0c\u4f18\u60e0\u653f\u7b56%s:%s\u53d1\u73b0\u9519\u8bef\u7684\u201c\u95e8\u69db\u6240\u5305\u542b\u5546\u54c1\u7684\u65b9\u5f0f\u201d", salePolicyCode, salePolicyThresholdDetailVo.getThresholdDetailCode()));
                    continue;
                }
                List<SalePolicyThresholdProductVo> targetSalePolicyThresholdProductVos = salePolicyThresholdDetailVo.getThresholdProducts();
                if (CollectionUtils.isEmpty(targetSalePolicyThresholdProductVos)) {
                    failedThresholdDetailInfos.put(thresholdDetailCode, String.format("\u5728\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u8ba1\u7b97/\u9884\u8ba1\u7b97\u65f6\uff0c\u4f18\u60e0\u653f\u7b56{}:{}\u53d1\u73b0\u9519\u8bef\u7684\u201c\u95e8\u69db\u660e\u7ec6\u5546\u54c1\u201d", salePolicyCode, salePolicyThresholdDetailVo.getThresholdDetailCode()));
                    continue;
                }
                Set targetThresholdProductCodes = targetSalePolicyThresholdProductVos.stream().map(SalePolicyThresholdProductVo::getProductCode).collect(Collectors.toSet());
                if (Sets.intersection(thresholdProductCodes, targetThresholdProductCodes).isEmpty()) continue;
                Map<String, SalePolicyThresholdProductVo> targetThresholdProductCodeMapping = targetSalePolicyThresholdProductVos.stream().collect(Collectors.toMap(SalePolicyThresholdProductVo::getProductCode, item -> item));
                boolean isSubset = false;
                boolean isIntersectionSet = false;
                Sets.SetView intersectionProductCodes = Sets.intersection(targetThresholdProductCodes, remainSourceProductCodes);
                if (!CollectionUtils.isEmpty((Collection)intersectionProductCodes) && intersectionProductCodes.size() == targetThresholdProductCodes.size()) {
                    isSubset = true;
                    isIntersectionSet = true;
                } else if (!CollectionUtils.isEmpty((Collection)intersectionProductCodes)) {
                    isIntersectionSet = true;
                } else {
                    failedThresholdDetailInfos.put(thresholdDetailCode, "\u4e0d\u5305\u62ec\u6216\u7f3a\u5c11\u5fc5\u987b\u7684\u5546\u54c1\u4fe1\u606f");
                    continue;
                }
                if (includeType == 1 && isSubset) {
                    for (String intersectionProductCode : intersectionProductCodes) {
                        String failedMsg = this.validate(remainSourceProductMapping, targetThresholdProductCodeMapping, intersectionProductCode);
                        if (!StringUtils.isNotBlank((CharSequence)failedMsg)) continue;
                        failedThresholdDetailInfos.put(thresholdDetailCode, failedMsg);
                        continue block3;
                    }
                } else if (includeType == 2 && isIntersectionSet) {
                    Set targetCertainProductCodes = targetSalePolicyThresholdProductVos.stream().filter(item -> item.getCertain()).map(SalePolicyThresholdProductVo::getProductCode).collect(Collectors.toSet());
                    int concurrentCertainCount = Sets.intersection(remainSourceProductCodes, targetCertainProductCodes).size();
                    if (concurrentCertainCount < targetCertainProductCodes.size()) {
                        failedThresholdDetailInfos.put(thresholdDetailCode, String.format("\u4f18\u60e0\u95e8\u69db\u8981\u6c42\u5fc5\u9009\u6570\u91cf\u4e3a%d,\u4f46\u5b9e\u9645\u5fc5\u9009\u6570\u91cf\u4e3a%d", concurrentCertainCount, targetCertainProductCodes.size()));
                        continue;
                    }
                    Integer includeNumber = salePolicyThresholdDetailVo.getIncludeNumber();
                    if (intersectionProductCodes.size() < includeNumber) {
                        failedThresholdDetailInfos.put(thresholdDetailCode, String.format("\u4f18\u60e0\u95e8\u69db\u81f3\u5c11\u8981\u6c42\u5546\u54c1\u6570\u91cf%d,\u4f46\u5b9e\u9645\u80fd\u53c2\u4e0e\u4f18\u60e0\u7684\u5546\u54c1\u6570\u91cf\u4e3a%d", includeNumber, intersectionProductCodes.size()));
                        continue;
                    }
                    for (String intersectionProductCode : intersectionProductCodes) {
                        String failedMsg = this.validate(remainSourceProductMapping, targetThresholdProductCodeMapping, intersectionProductCode);
                        if (!StringUtils.isNotBlank((CharSequence)failedMsg)) continue;
                        failedThresholdDetailInfos.put(thresholdDetailCode, failedMsg);
                        continue block3;
                    }
                } else {
                    failedThresholdDetailInfos.put(thresholdDetailCode, "\u4e0d\u5305\u62ec\u6216\u7f3a\u5c11\u5fc5\u987b\u7684\u5546\u54c1\u4fe1\u606f");
                    continue;
                }
                matchedThresholdDetailMappings.put(thresholdDetailCode, targetThresholdProductCodes);
                remainSourceProductCodes.removeAll(Sets.newHashSet(targetThresholdProductCodes));
            }
        } else {
            matchedThresholdDetailMappings.put(salePolicyThreshold.getId(), thresholdProductCodes);
        }
        Object var18_22 = null;
        if (!CollectionUtils.isEmpty((Map)failedThresholdDetailInfos)) {
            Pair pair = Pair.of((Object)Maps.newHashMap(), (Object)(CollectionUtils.isEmpty(failedThresholdDetailInfos.values()) ? "\u4e0d\u5305\u62ec\u6216\u7f3a\u5c11\u5fc5\u987b\u7684\u5546\u54c1\u4fe1\u606f" : (String)failedThresholdDetailInfos.values().iterator().next()));
        } else {
            Pair pair = Pair.of((Object)matchedThresholdDetailMappings, (Object)"");
        }
        return var18_25;
    }

    private String validate(Map<String, ProductPolicyStepResult> remainSourceProductMapping, Map<String, SalePolicyThresholdProductVo> targetThresholdProductCodeMapping, String targetProductCode) {
        SalePolicyThresholdProductVo targetThresholdProduct = targetThresholdProductCodeMapping.get(targetProductCode);
        ProductPolicyStepResult sourcePolicyConProduct = remainSourceProductMapping.get(targetProductCode);
        Integer targetThresholdUnit = targetThresholdProduct.getThresholdUnit();
        if (targetThresholdUnit == null || targetThresholdUnit != 1 && targetThresholdUnit != 2) {
            return "\u4f18\u60e0\u653f\u7b56\u4e2d\u5b58\u5728\u9519\u8bef\u7684\u8ba1\u6570\u65b9\u5f0f";
        }
        if (targetThresholdProduct.getThresholdUnit() == 1) {
            BigDecimal lastSurplusSubtotal = sourcePolicyConProduct.getLastSurplusTotalAmount();
            if ((float)targetThresholdProduct.getThresholdNumber().intValue() > lastSurplusSubtotal.setScale(4, RoundingMode.HALF_UP).floatValue()) {
                return String.format("\u5546\u54c1\uff08%s\uff09\u4e2d\u5269\u4f59\u672a\u53c2\u4e0e\u4f18\u60e0\u7684\u5c0f\u8ba1\u91d1\u989d\uff0c\u6ca1\u6709\u8fbe\u5230\u4f18\u60e0\u653f\u7b56\u7684\u4f7f\u7528\u95e8\u69db", targetProductCode);
            }
        } else {
            Integer lastSurplusTotalNumber = sourcePolicyConProduct.getLastSurplusTotalNumber();
            if (targetThresholdProduct.getThresholdNumber() > lastSurplusTotalNumber) {
                return String.format(String.format("\u5546\u54c1\uff08%s\uff09\u4e2d\u5269\u4f59\u672a\u53c2\u4e0e\u4f18\u60e0\u7684\u6570\u91cf\uff0c\u6ca1\u6709\u8fbe\u5230\u4f18\u60e0\u653f\u7b56\u7684\u4f7f\u7528\u95e8\u69db", targetProductCode), new Object[0]);
            }
        }
        return null;
    }
}

