/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.notifier;

import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import com.biz.crm.mdm.business.org.sdk.dto.OrgEventBatchDto;
import com.biz.crm.mdm.business.org.sdk.dto.OrgEventDto;
import com.biz.crm.mdm.business.org.sdk.event.OrgEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SalePolicyForOrgEventListener
implements OrgEventListener {
    @Autowired(required=false)
    private List<SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>> salePolicyCustomerScopeStrategies;

    public void onDeleteBatch(OrgEventBatchDto orgEventBatchDto) {
        SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> currentSalePolicyCustomerScopeStrategy = this.currentSalePolicyCustomerScopeStrategy();
        if (currentSalePolicyCustomerScopeStrategy == null) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        String[] currentOrgCodes = this.currentOrgCodes(orgEventBatchDto);
        if (currentOrgCodes == null || currentOrgCodes.length == 0) {
            return;
        }
        currentSalePolicyCustomerScopeStrategy.onDelete(tenantCode, currentOrgCodes);
    }

    public void onEnableBatch(OrgEventBatchDto orgEventBatchDto) {
        SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> currentSalePolicyCustomerScopeStrategy = this.currentSalePolicyCustomerScopeStrategy();
        if (currentSalePolicyCustomerScopeStrategy == null) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        String[] currentOrgCodes = this.currentOrgCodes(orgEventBatchDto);
        if (currentOrgCodes == null || currentOrgCodes.length == 0) {
            return;
        }
        currentSalePolicyCustomerScopeStrategy.onEffective(tenantCode, currentOrgCodes);
    }

    public void onDisableBatch(OrgEventBatchDto orgEventBatchDto) {
        SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> currentSalePolicyCustomerScopeStrategy = this.currentSalePolicyCustomerScopeStrategy();
        if (currentSalePolicyCustomerScopeStrategy == null) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        String[] currentOrgCodes = this.currentOrgCodes(orgEventBatchDto);
        if (currentOrgCodes == null || currentOrgCodes.length == 0) {
            return;
        }
        currentSalePolicyCustomerScopeStrategy.onInvalid(tenantCode, currentOrgCodes);
    }

    private SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> currentSalePolicyCustomerScopeStrategy() {
        SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> currentSalePolicyCustomerScopeStrategy = null;
        for (SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> salePolicyCustomerScopeStrategy : this.salePolicyCustomerScopeStrategies) {
            if (!StringUtils.equals((CharSequence)salePolicyCustomerScopeStrategy.getScopeType(), (CharSequence)"orgForSalePolicyCustomer")) continue;
            currentSalePolicyCustomerScopeStrategy = salePolicyCustomerScopeStrategy;
        }
        return currentSalePolicyCustomerScopeStrategy;
    }

    private String[] currentOrgCodes(OrgEventBatchDto orgEventBatchDto) {
        List orgEvents = orgEventBatchDto.getOrgEventDtoList();
        if (CollectionUtils.isEmpty((Collection)orgEvents)) {
            return null;
        }
        String[] orgCodes = (String[])orgEvents.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getOrgCode())).map(OrgEventDto::getOrgCode).toArray(String[]::new);
        return orgCodes;
    }

    public void onUpdate(OrgEventDto orgEventDto) {
    }

    public void onDelete(List<String> orgCodes) {
    }
}

