/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.notifier;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.dms.business.policy.sdk.dto.SalePolicyLogDto;
import com.biz.crm.dms.business.policy.sdk.event.SalePolicyLogEventListener;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SalePolicyLogEventListenerImpl
implements SalePolicyLogEventListener {
    @Autowired(required=false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    public void onCreate(SalePolicyLogDto salePolicyLogDto) {
        this.saveRecord(salePolicyLogDto, OperationTypeEunm.CREATE);
    }

    public void onUpdate(SalePolicyLogDto salePolicyLogDto) {
        this.saveRecord(salePolicyLogDto, OperationTypeEunm.UPDATE);
    }

    public void OnEnable(SalePolicyLogDto salePolicyLogDto) {
        this.saveRecord(salePolicyLogDto, OperationTypeEunm.UPDATE);
    }

    public void OnDisable(SalePolicyLogDto salePolicyLogDto) {
        this.saveRecord(salePolicyLogDto, OperationTypeEunm.UPDATE);
    }

    public void OnDelete(SalePolicyLogDto salePolicyLogDto) {
        this.saveRecord(salePolicyLogDto, OperationTypeEunm.DELETE);
    }

    private void saveRecord(SalePolicyLogDto salePolicyLogDto, OperationTypeEunm operationTypeEunm) {
        SalePolicyVo original = salePolicyLogDto.getOriginal();
        SalePolicyVo newest = salePolicyLogDto.getNewest();
        if (ObjectUtils.isEmpty((Object)original) && ObjectUtils.isEmpty((Object)newest)) {
            throw new RuntimeException("\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u65f6\uff0c\u6ca1\u6709\u53ef\u6bd4\u8f83\u4fe1\u606f");
        }
        String onlyKey = ObjectUtils.isEmpty((Object)original) ? newest.getId() : original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(operationTypeEunm.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getAppCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)original);
        crmBusinessLogDto.setNewObject((Object)newest);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}

