/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutor;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutorLadder;
import com.biz.crm.dms.business.policy.local.mapper.SalePolicyExecutorMapper;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyExecutorJpaRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SalePolicyExecutorRepository
extends ServiceImpl<SalePolicyExecutorMapper, SalePolicyExecutor> {
    @Autowired(required=false)
    private SalePolicyExecutorJpaRepository salePolicyExecutorJpaRepository;

    public SalePolicyExecutor findBySalePolicyCodeAndExecutorCode(String salePolicyCode, String executorCode, String tenantCode) {
        SalePolicyExecutor salePolicyExecutor = this.salePolicyExecutorJpaRepository.findBySalePolicyCodeAndExecutorCode(salePolicyCode, executorCode, tenantCode);
        if (salePolicyExecutor == null) {
            return null;
        }
        salePolicyExecutor.setSalePolicyExecutorLadders(this.sortedLadders(salePolicyExecutor.getSalePolicyExecutorLadders()));
        return salePolicyExecutor;
    }

    private Set<SalePolicyExecutorLadder> sortedLadders(Set<SalePolicyExecutorLadder> salePolicyExecutorLadders) {
        if (!CollectionUtils.isEmpty(salePolicyExecutorLadders)) {
            List sortedSalePolicyExecutorLadders = salePolicyExecutorLadders.stream().sorted((source, target) -> source.getIndexs() - target.getIndexs()).collect(Collectors.toList());
            return Sets.newLinkedHashSet(sortedSalePolicyExecutorLadders);
        }
        return salePolicyExecutorLadders;
    }

    public Integer countBySalePolicyCodeAndExecutorCode(String salePolicyCode, String executorCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SalePolicyExecutor::getSalePolicyCode, (Object)salePolicyCode)).eq(SalePolicyExecutor::getExecutorCode, (Object)executorCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).count();
    }

    public List<SalePolicyExecutor> findBySalePolicyCode(String salePolicyCode, String tenantCode, String executeStrategyCode) {
        Set<SalePolicyExecutor> salePolicyExecutors = this.salePolicyExecutorJpaRepository.findBySalePolicyCodeAndExecuteStrategyCode(salePolicyCode, tenantCode, executeStrategyCode);
        if (CollectionUtils.isEmpty(salePolicyExecutors)) {
            return null;
        }
        for (SalePolicyExecutor salePolicyExecutor : salePolicyExecutors) {
            salePolicyExecutor.setSalePolicyExecutorLadders(this.sortedLadders(salePolicyExecutor.getSalePolicyExecutorLadders()));
        }
        return Lists.newArrayList(salePolicyExecutors);
    }

    public void deleteByIds(Set<String> salePolicyExecutorIds) {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.in(UuidEntity::getId, salePolicyExecutorIds);
        ((SalePolicyExecutorMapper)this.baseMapper).delete((Wrapper)lambdaQuery);
    }
}

