/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyTemplete;
import com.biz.crm.dms.business.policy.local.mapper.SalePolicyTempleteMapper;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyTempleteJpaRepository;
import com.biz.crm.dms.business.policy.sdk.dto.SalePolicyTempletePageDto;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SalePolicyTempleteRepository
extends ServiceImpl<SalePolicyTempleteMapper, SalePolicyTemplete> {
    @Autowired(required=false)
    private SalePolicyTempleteJpaRepository salePolicyTempleteJpaRepository;

    public SalePolicyTemplete findByTempleteCode(String templeteCode, String tenantCode) {
        return this.salePolicyTempleteJpaRepository.findByTempleteCode(templeteCode, tenantCode);
    }

    public List<SalePolicyTemplete> findByTempleteCodes(List<String> templeteCodes, String tenantCode) {
        Set<SalePolicyTemplete> set = this.salePolicyTempleteJpaRepository.findByTempleteCodes(templeteCodes, tenantCode);
        if (CollectionUtils.isEmpty(set)) {
            return null;
        }
        return Lists.newArrayList(set);
    }

    public SalePolicyTemplete findById(String id) {
        return (SalePolicyTemplete)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).one());
    }

    public Set<SalePolicyTemplete> findByTenantCode(String tenantCode, EnableStatusEnum enableStatus) {
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return null;
        }
        if (enableStatus == null) {
            return this.salePolicyTempleteJpaRepository.findByTenantCode(tenantCode);
        }
        return this.salePolicyTempleteJpaRepository.findByTenantCodeAndEnableStatus(tenantCode, enableStatus.getCode());
    }

    public Page<SalePolicyTemplete> findByConditions(Pageable pageable, SalePolicyTempletePageDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (StringUtils.equals((CharSequence)dto.getTempleteName(), (CharSequence)"")) {
            dto.setTempleteName(null);
        }
        if (StringUtils.equals((CharSequence)dto.getTempleteCode(), (CharSequence)"")) {
            dto.setTempleteCode(null);
        }
        if (StringUtils.equals((CharSequence)dto.getEnableStatus(), (CharSequence)"")) {
            dto.setEnableStatus(null);
        }
        return ((SalePolicyTempleteMapper)this.baseMapper).findByConditions((Page<SalePolicyTemplete>)page, dto);
    }

    public void deleteByTempleteCode(String templeteCode, String tenantCode) {
        this.salePolicyTempleteJpaRepository.deleteByTempleteCode(templeteCode, tenantCode);
    }
}

