/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.scopestrategy;

import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyScopeInfoRepository;
import com.biz.crm.dms.business.policy.local.service.task.SalePolicyCacheLoadingService;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import com.google.common.collect.Lists;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractSalePolicyCustomerScopeStrategy {
    @Autowired(required=false)
    private SalePolicyScopeInfoRepository salePolicyScopeInfoRepository;
    @Autowired(required=false)
    private SalePolicyCacheLoadingService salePolicyCacheLoadingService;

    public abstract String getScopeType();

    protected void deleteSalePolicyCustomerInfos(String currentScopeType, Set<? extends AbstractSalePolicyCustomerScopeInfo> salePolicyCustomerInfos) {
        Object[] salePolicyCustomerInfoIds;
        if (!CollectionUtils.isEmpty(salePolicyCustomerInfos) && (salePolicyCustomerInfoIds = (String[])salePolicyCustomerInfos.stream().filter(item -> StringUtils.equals((CharSequence)currentScopeType, (CharSequence)item.getCustomerScopeType())).map(UuidVo::getId).toArray(String[]::new)) != null && salePolicyCustomerInfoIds.length > 0) {
            this.salePolicyScopeInfoRepository.deleteByIds(Lists.newArrayList((Object[])salePolicyCustomerInfoIds));
        }
    }

    public void onEffective(String tenantCode, String[] codes) {
        String customerScopeType = this.getScopeType();
        if (StringUtils.isBlank((CharSequence)tenantCode) || codes == null || codes.length == 0) {
            return;
        }
        this.salePolicyScopeInfoRepository.effectiveByCustomerScopeTypeAndTenantCodeAndCodes(customerScopeType, tenantCode, codes);
        this.salePolicyCacheLoadingService.notifyCacheRefresh(tenantCode);
    }

    public void onInvalid(String tenantCode, String[] codes) {
        String customerScopeType = this.getScopeType();
        if (StringUtils.isBlank((CharSequence)tenantCode) || codes == null || codes.length == 0) {
            return;
        }
        this.salePolicyScopeInfoRepository.invalidByCustomerScopeTypeAndTenantCodeAndCodes(customerScopeType, tenantCode, codes);
        this.salePolicyCacheLoadingService.notifyCacheRefresh(tenantCode);
    }

    public void onDelete(String tenantCode, String[] codes) {
        String customerScopeType = this.getScopeType();
        if (StringUtils.isBlank((CharSequence)tenantCode) || codes == null || codes.length == 0) {
            return;
        }
        this.salePolicyScopeInfoRepository.deleteByCustomerScopeTypeAndTenantCodeAndCodes(customerScopeType, tenantCode, codes);
        this.salePolicyCacheLoadingService.notifyCacheRefresh(tenantCode);
    }
}

