/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.scopestrategy;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyScopeInfo;
import com.biz.crm.dms.business.policy.local.scopestrategy.AbstractSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.local.service.SalePolicyScopeInfoService;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyScopeChannelInfoVo;
import com.biz.crm.dms.business.policy.sdk.enums.ScopeSelectionMethod;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ChannelForSalePolicyCustomerScopeStrategy
extends AbstractSalePolicyCustomerScopeStrategy
implements SalePolicyCustomerScopeStrategy<SalePolicyScopeChannelInfoVo> {
    @Autowired(required=false)
    private SalePolicyScopeInfoService salePolicyScopeInfoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    public static final String SCOPE_TYPE = "channelForSalePolicy";

    @Override
    public String getScopeType() {
        return SCOPE_TYPE;
    }

    public String getScopeTypeDesc() {
        return "\u6e20 \u9053";
    }

    public Class<SalePolicyScopeChannelInfoVo> getSalePolicyCustomerInfoClass() {
        return SalePolicyScopeChannelInfoVo.class;
    }

    public void onSaveSalePolicyCustomerInfo(boolean update, SalePolicyVo currentSalePolicy, SalePolicyVo oldSalePolicy) {
        Map salePolicyCustomerInfoMaps;
        Map oldSalePolicyCustomerInfoMaps;
        if (update && !CollectionUtils.isEmpty((Map)(oldSalePolicyCustomerInfoMaps = oldSalePolicy.getCustomerScopeMapping())) && !CollectionUtils.isEmpty((Collection)((Collection)oldSalePolicyCustomerInfoMaps.get(this.getScopeType())))) {
            this.deleteSalePolicyCustomerInfos(this.getScopeType(), (Set)oldSalePolicyCustomerInfoMaps.get(this.getScopeType()));
        }
        if (CollectionUtils.isEmpty((Map)(salePolicyCustomerInfoMaps = currentSalePolicy.getCustomerScopeMapping())) || CollectionUtils.isEmpty((Collection)((Collection)salePolicyCustomerInfoMaps.get(this.getScopeType())))) {
            return;
        }
        Set currentSalePolicyCustomerInfos = (Set)salePolicyCustomerInfoMaps.get(this.getScopeType());
        LinkedHashSet salePolicyScopeInfos = Sets.newLinkedHashSet();
        for (AbstractSalePolicyCustomerScopeInfo abstractSalePolicyCustomerInfo : currentSalePolicyCustomerInfos) {
            SalePolicyScopeChannelInfoVo salePolicyScopeChannelInfoVo = (SalePolicyScopeChannelInfoVo)abstractSalePolicyCustomerInfo;
            salePolicyScopeChannelInfoVo.setSalePolicyCode(currentSalePolicy.getSalePolicyCode());
            salePolicyScopeChannelInfoVo.setTenantCode(currentSalePolicy.getTenantCode());
            SalePolicyScopeInfo salePolicyScopeInfo = new SalePolicyScopeInfo();
            salePolicyScopeInfo.setSalePolicyCode(currentSalePolicy.getSalePolicyCode());
            salePolicyScopeInfo.setTenantCode(currentSalePolicy.getTenantCode());
            salePolicyScopeInfo.setCode(salePolicyScopeChannelInfoVo.getChannelCode());
            salePolicyScopeInfo.setName(salePolicyScopeChannelInfoVo.getChannelName());
            salePolicyScopeInfo.setCustomerScopeType(SCOPE_TYPE);
            salePolicyScopeInfo.setState(1);
            salePolicyScopeInfo.setSelectionMethod(salePolicyScopeChannelInfoVo.getSelectionMethod());
            salePolicyScopeInfos.add(salePolicyScopeInfo);
        }
        this.salePolicyScopeInfoService.createBatch(salePolicyScopeInfos);
    }

    public Set<SalePolicyScopeChannelInfoVo> requestSalePolicyCustomerInfo(String tenantCode, String salePolicyCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, salePolicyCode})) {
            return null;
        }
        List<SalePolicyScopeInfo> salePolicyScopeInfos = this.salePolicyScopeInfoService.findByTenantCodeAndSalePolicyCodeAndCustomerScopeType(tenantCode, salePolicyCode, SCOPE_TYPE);
        if (CollectionUtils.isEmpty(salePolicyScopeInfos)) {
            return null;
        }
        HashSet<SalePolicyScopeChannelInfoVo> salePolicyScopeChannelInfoVos = new HashSet<SalePolicyScopeChannelInfoVo>();
        for (SalePolicyScopeInfo salePolicyScopeInfo : salePolicyScopeInfos) {
            SalePolicyScopeChannelInfoVo salePolicyScopeChannelInfoVo = (SalePolicyScopeChannelInfoVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)salePolicyScopeInfo, SalePolicyScopeChannelInfoVo.class, HashSet.class, ArrayList.class, new String[0]));
            salePolicyScopeChannelInfoVo.setChannelCode(salePolicyScopeInfo.getCode());
            salePolicyScopeChannelInfoVo.setChannelName(salePolicyScopeInfo.getName());
            salePolicyScopeChannelInfoVos.add(salePolicyScopeChannelInfoVo);
        }
        return salePolicyScopeChannelInfoVos;
    }

    public boolean matched(String customerCode, String tenantCode, String salePolicyCode, Set<SalePolicyScopeChannelInfoVo> salePolicyCustomerInfos) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, salePolicyCode}) || CollectionUtils.isEmpty(salePolicyCustomerInfos)) {
            return false;
        }
        Map selectionMethodMap = salePolicyCustomerInfos.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getSelectionMethod(), a.getChannelCode()})).collect(Collectors.groupingBy(SalePolicyScopeChannelInfoVo::getSelectionMethod, Collectors.mapping(SalePolicyScopeChannelInfoVo::getChannelCode, Collectors.toList())));
        List includeList = selectionMethodMap.get(ScopeSelectionMethod.INCLUDE.getCode());
        List excludeList = selectionMethodMap.get(ScopeSelectionMethod.EXCLUDE.getCode());
        if (CollectionUtils.isEmpty(includeList)) {
            return false;
        }
        if (!CollectionUtils.isEmpty(excludeList)) {
            includeList.removeAll(excludeList);
        }
        Boolean isExist = this.customerVoService.existByCustomerCodeAndChannels(includeList, customerCode);
        return isExist;
    }
}

