/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.scopestrategy;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyScopeInfo;
import com.biz.crm.dms.business.policy.local.scopestrategy.AbstractSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.local.service.SalePolicyScopeInfoService;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyScopeDistributorInfoVo;
import com.biz.crm.dms.business.policy.sdk.enums.ScopeSelectionMethod;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DistributorForSalePolicyCustomerScopeStrategy
extends AbstractSalePolicyCustomerScopeStrategy
implements SalePolicyCustomerScopeStrategy<SalePolicyScopeDistributorInfoVo> {
    @Autowired(required=false)
    private SalePolicyScopeInfoService salePolicyScopeInfoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    public static final String SCOPE_TYPE = "distributorForSalePolicy";

    @Override
    public String getScopeType() {
        return SCOPE_TYPE;
    }

    public String getScopeTypeDesc() {
        return "\u5ba2 \u6237";
    }

    public Class<SalePolicyScopeDistributorInfoVo> getSalePolicyCustomerInfoClass() {
        return SalePolicyScopeDistributorInfoVo.class;
    }

    public void onSaveSalePolicyCustomerInfo(boolean update, SalePolicyVo currentSalePolicy, SalePolicyVo oldSalePolicy) {
        Map salePolicyCustomerInfoMaps;
        Map oldSalePolicyCustomerInfoMaps;
        if (update && !CollectionUtils.isEmpty((Map)(oldSalePolicyCustomerInfoMaps = oldSalePolicy.getCustomerScopeMapping())) && !CollectionUtils.isEmpty((Collection)((Collection)oldSalePolicyCustomerInfoMaps.get(this.getScopeType())))) {
            this.deleteSalePolicyCustomerInfos(this.getScopeType(), (Set)oldSalePolicyCustomerInfoMaps.get(this.getScopeType()));
        }
        if (CollectionUtils.isEmpty((Map)(salePolicyCustomerInfoMaps = currentSalePolicy.getCustomerScopeMapping())) || CollectionUtils.isEmpty((Collection)((Collection)salePolicyCustomerInfoMaps.get(this.getScopeType())))) {
            return;
        }
        Set currentSalePolicyCustomerInfos = (Set)salePolicyCustomerInfoMaps.get(this.getScopeType());
        LinkedHashSet salePolicyScopeInfos = Sets.newLinkedHashSet();
        for (AbstractSalePolicyCustomerScopeInfo abstractSalePolicyCustomerInfo : currentSalePolicyCustomerInfos) {
            SalePolicyScopeDistributorInfoVo salePolicyScopeInfoVo = (SalePolicyScopeDistributorInfoVo)abstractSalePolicyCustomerInfo;
            salePolicyScopeInfoVo.setSalePolicyCode(currentSalePolicy.getSalePolicyCode());
            salePolicyScopeInfoVo.setTenantCode(currentSalePolicy.getTenantCode());
            SalePolicyScopeInfo salePolicyScopeInfo = new SalePolicyScopeInfo();
            salePolicyScopeInfo.setSalePolicyCode(currentSalePolicy.getSalePolicyCode());
            salePolicyScopeInfo.setTenantCode(currentSalePolicy.getTenantCode());
            salePolicyScopeInfo.setCode(salePolicyScopeInfoVo.getDistributorCode());
            salePolicyScopeInfo.setName(salePolicyScopeInfoVo.getDistributorName());
            salePolicyScopeInfo.setCustomerScopeType(SCOPE_TYPE);
            salePolicyScopeInfo.setState(1);
            salePolicyScopeInfo.setSelectionMethod(salePolicyScopeInfoVo.getSelectionMethod());
            salePolicyScopeInfos.add(salePolicyScopeInfo);
        }
        this.salePolicyScopeInfoService.createBatch(salePolicyScopeInfos);
    }

    public Set<SalePolicyScopeDistributorInfoVo> requestSalePolicyCustomerInfo(String tenantCode, String salePolicyCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, salePolicyCode})) {
            return null;
        }
        List<SalePolicyScopeInfo> salePolicyScopeInfos = this.salePolicyScopeInfoService.findByTenantCodeAndSalePolicyCodeAndCustomerScopeType(tenantCode, salePolicyCode, SCOPE_TYPE);
        if (CollectionUtils.isEmpty(salePolicyScopeInfos)) {
            return null;
        }
        HashSet<SalePolicyScopeDistributorInfoVo> salePolicyScopeDistributorInfoVos = new HashSet<SalePolicyScopeDistributorInfoVo>();
        for (SalePolicyScopeInfo salePolicyScopeInfo : salePolicyScopeInfos) {
            SalePolicyScopeDistributorInfoVo salePolicyScopeDistributorInfoVo = (SalePolicyScopeDistributorInfoVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)salePolicyScopeInfo, SalePolicyScopeDistributorInfoVo.class, HashSet.class, ArrayList.class, new String[0]));
            salePolicyScopeDistributorInfoVo.setDistributorCode(salePolicyScopeInfo.getCode());
            salePolicyScopeDistributorInfoVo.setDistributorName(salePolicyScopeInfo.getName());
            salePolicyScopeDistributorInfoVos.add(salePolicyScopeDistributorInfoVo);
        }
        return salePolicyScopeDistributorInfoVos;
    }

    public boolean matched(String customerCode, String tenantCode, String salePolicyCode, Set<SalePolicyScopeDistributorInfoVo> salePolicyCustomerInfos) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, salePolicyCode}) || CollectionUtils.isEmpty(salePolicyCustomerInfos)) {
            return false;
        }
        Map selectionMethodMap = salePolicyCustomerInfos.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getSelectionMethod(), a.getDistributorCode()})).collect(Collectors.groupingBy(SalePolicyScopeDistributorInfoVo::getSelectionMethod, Collectors.mapping(SalePolicyScopeDistributorInfoVo::getDistributorCode, Collectors.toList())));
        List includeCodes = selectionMethodMap.get(ScopeSelectionMethod.INCLUDE.getCode());
        List excludeCodes = selectionMethodMap.get(ScopeSelectionMethod.EXCLUDE.getCode());
        if (CollectionUtils.isEmpty(includeCodes)) {
            return false;
        }
        if (!CollectionUtils.isEmpty(excludeCodes)) {
            includeCodes.removeAll(excludeCodes);
        }
        Boolean isExist = this.customerVoService.existByCustomerCode(customerCode);
        return isExist;
    }
}

