/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.scopestrategy;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyScopeInfo;
import com.biz.crm.dms.business.policy.local.scopestrategy.AbstractSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.local.service.SalePolicyScopeInfoService;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyScopeOrgInfoVo;
import com.biz.crm.dms.business.policy.sdk.enums.ScopeSelectionMethod;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OrgForSalePolicyCustomerScopeStrategy
extends AbstractSalePolicyCustomerScopeStrategy
implements SalePolicyCustomerScopeStrategy<SalePolicyScopeOrgInfoVo> {
    @Autowired(required=false)
    private SalePolicyScopeInfoService salePolicyScopeInfoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    public static final String SCOPE_TYPE = "orgForSalePolicyCustomer";

    @Override
    public String getScopeType() {
        return SCOPE_TYPE;
    }

    public String getScopeTypeDesc() {
        return "\u7ec4\u7ec7\u673a\u6784";
    }

    public Class<SalePolicyScopeOrgInfoVo> getSalePolicyCustomerInfoClass() {
        return SalePolicyScopeOrgInfoVo.class;
    }

    @Transactional
    public void onSaveSalePolicyCustomerInfo(boolean update, SalePolicyVo currentSalePolicy, SalePolicyVo oldSalePolicy) {
        Map salePolicyCustomerInfoMaps;
        Map oldSalePolicyCustomerInfoMaps;
        if (update && !CollectionUtils.isEmpty((Map)(oldSalePolicyCustomerInfoMaps = oldSalePolicy.getCustomerScopeMapping())) && !CollectionUtils.isEmpty((Collection)((Collection)oldSalePolicyCustomerInfoMaps.get(this.getScopeType())))) {
            this.deleteSalePolicyCustomerInfos(this.getScopeType(), (Set)oldSalePolicyCustomerInfoMaps.get(this.getScopeType()));
        }
        if (CollectionUtils.isEmpty((Map)(salePolicyCustomerInfoMaps = currentSalePolicy.getCustomerScopeMapping())) || CollectionUtils.isEmpty((Collection)((Collection)salePolicyCustomerInfoMaps.get(this.getScopeType())))) {
            return;
        }
        Set currentSalePolicyCustomerInfos = (Set)salePolicyCustomerInfoMaps.get(this.getScopeType());
        LinkedHashSet salePolicyScopeInfos = Sets.newLinkedHashSet();
        for (AbstractSalePolicyCustomerScopeInfo abstractSalePolicyCustomerInfo : currentSalePolicyCustomerInfos) {
            SalePolicyScopeOrgInfoVo salePolicyScopeInfoVo = (SalePolicyScopeOrgInfoVo)abstractSalePolicyCustomerInfo;
            salePolicyScopeInfoVo.setSalePolicyCode(currentSalePolicy.getSalePolicyCode());
            salePolicyScopeInfoVo.setTenantCode(currentSalePolicy.getTenantCode());
            SalePolicyScopeInfo salePolicyScopeInfo = new SalePolicyScopeInfo();
            salePolicyScopeInfo.setSalePolicyCode(currentSalePolicy.getSalePolicyCode());
            salePolicyScopeInfo.setTenantCode(currentSalePolicy.getTenantCode());
            salePolicyScopeInfo.setCode(salePolicyScopeInfoVo.getOrgCode());
            salePolicyScopeInfo.setName(salePolicyScopeInfoVo.getOrgName());
            salePolicyScopeInfo.setCustomerScopeType(SCOPE_TYPE);
            salePolicyScopeInfo.setState(1);
            salePolicyScopeInfo.setSelectionMethod(salePolicyScopeInfoVo.getSelectionMethod());
            salePolicyScopeInfos.add(salePolicyScopeInfo);
        }
        this.salePolicyScopeInfoService.createBatch(salePolicyScopeInfos);
    }

    public Set<SalePolicyScopeOrgInfoVo> requestSalePolicyCustomerInfo(String tenantCode, String salePolicyCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, salePolicyCode})) {
            return null;
        }
        List<SalePolicyScopeInfo> salePolicyScopeInfos = this.salePolicyScopeInfoService.findByTenantCodeAndSalePolicyCodeAndCustomerScopeType(tenantCode, salePolicyCode, SCOPE_TYPE);
        if (CollectionUtils.isEmpty(salePolicyScopeInfos)) {
            return null;
        }
        HashSet<SalePolicyScopeOrgInfoVo> salePolicyScopeOrgInfoVos = new HashSet<SalePolicyScopeOrgInfoVo>();
        for (SalePolicyScopeInfo salePolicyScopeInfo : salePolicyScopeInfos) {
            SalePolicyScopeOrgInfoVo salePolicyScopeOrgInfoVo = (SalePolicyScopeOrgInfoVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)salePolicyScopeInfo, SalePolicyScopeOrgInfoVo.class, HashSet.class, ArrayList.class, new String[0]));
            salePolicyScopeOrgInfoVo.setOrgCode(salePolicyScopeInfo.getCode());
            salePolicyScopeOrgInfoVo.setOrgName(salePolicyScopeInfo.getName());
            salePolicyScopeOrgInfoVos.add(salePolicyScopeOrgInfoVo);
        }
        return salePolicyScopeOrgInfoVos;
    }

    private Set<String> findCustomerCodes(Set<SalePolicyScopeOrgInfoVo> salePolicyCustomerInfos) {
        List excludeCustomerCodeList;
        Map selectionMethodMap = salePolicyCustomerInfos.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getSelectionMethod(), a.getOrgCode()})).collect(Collectors.groupingBy(SalePolicyScopeOrgInfoVo::getSelectionMethod, Collectors.mapping(SalePolicyScopeOrgInfoVo::getOrgCode, Collectors.toList())));
        List includeList = selectionMethodMap.get(ScopeSelectionMethod.INCLUDE.getCode());
        if (CollectionUtils.isEmpty(includeList)) {
            return null;
        }
        List includeCustomerCodeList = this.customerVoService.findByOrgCodes(includeList);
        if (CollectionUtils.isEmpty((Collection)includeCustomerCodeList)) {
            return null;
        }
        Set<String> includeCustomerCodes = includeCustomerCodeList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toSet());
        List excludeList = selectionMethodMap.get(ScopeSelectionMethod.EXCLUDE.getCode());
        if (!CollectionUtils.isEmpty(excludeList) && !CollectionUtils.isEmpty((Collection)(excludeCustomerCodeList = this.customerVoService.findByOrgCodes(excludeList)))) {
            Set excludeCustomerOrgCodes = excludeCustomerCodeList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toSet());
            includeCustomerCodes.removeAll(excludeCustomerOrgCodes);
        }
        return includeCustomerCodes;
    }

    public boolean matched(String customerCode, String tenantCode, String salePolicyCode, Set<SalePolicyScopeOrgInfoVo> salePolicyCustomerInfos) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, salePolicyCode}) || CollectionUtils.isEmpty(salePolicyCustomerInfos)) {
            return false;
        }
        Map selectionMethodMap = salePolicyCustomerInfos.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getSelectionMethod(), a.getOrgCode()})).collect(Collectors.groupingBy(SalePolicyScopeOrgInfoVo::getSelectionMethod, Collectors.mapping(SalePolicyScopeOrgInfoVo::getOrgCode, Collectors.toList())));
        List includeList = selectionMethodMap.get(ScopeSelectionMethod.INCLUDE.getCode());
        if (CollectionUtils.isEmpty(includeList)) {
            return false;
        }
        List excludeList = selectionMethodMap.get(ScopeSelectionMethod.EXCLUDE.getCode());
        Boolean isExist = this.customerVoService.existByCustomer7OrgIn7OrgNotIn(customerCode, includeList, excludeList);
        return isExist;
    }
}

