/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.service.internal;

import com.biz.crm.dms.business.policy.local.context.DefaultCycleExecuteContext;
import com.biz.crm.dms.business.policy.local.context.DefaultPolicyExecuteContext;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecord;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecordExcludePolicy;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecordGift;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecordProduct;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecordProductSelectedPolicy;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecordStepPolicy;
import com.biz.crm.dms.business.policy.local.service.SalePolicyRecordService;
import com.biz.crm.dms.business.policy.sdk.characteristic.CharacteristicStrategy;
import com.biz.crm.dms.business.policy.sdk.characteristic.CharacteristicVoter;
import com.biz.crm.dms.business.policy.sdk.config.SimplePolicyProperties;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.GiftResultInfo;
import com.biz.crm.dms.business.policy.sdk.context.ProductPolicyStepResult;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.sdk.context.StepType;
import com.biz.crm.dms.business.policy.sdk.register.SalePolicyTempleteRegister;
import com.biz.crm.dms.business.policy.sdk.service.SalePolicyExecuteService;
import com.biz.crm.dms.business.policy.sdk.service.SalePolicyVoService;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCycleRuleStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteShareStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyStickupListener;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractCharacteristicInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyLimitInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyProductInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyThreshold;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SalePolicyExecuteServiceImpl
implements SalePolicyExecuteService<DefaultPolicyExecuteContext> {
    private static final Logger log = LoggerFactory.getLogger(SalePolicyExecuteServiceImpl.class);
    @Autowired(required=false)
    private List<SalePolicyTempleteRegister> salePolicyTempleteRegisters;
    @Autowired(required=false)
    private SimplePolicyProperties simplePolicyProperties;
    @Autowired(required=false)
    private SalePolicyVoService salePolicyVoService;
    @Autowired(required=false)
    private SalePolicyRecordService salePolicyRecordService;
    @Autowired(required=false)
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private Set<CharacteristicStrategy<?>> characteristicStrateis;

    public DefaultPolicyExecuteContext preJudgment(Set<SalePolicyConProduct> initPolicyProducts, String tenantCode, String customerCode) {
        return this.preJudgment(initPolicyProducts, tenantCode, customerCode, false);
    }

    private DefaultPolicyExecuteContext preJudgment(Set<SalePolicyConProduct> initPolicyProducts, String tenantCode, String customerCode, boolean kneading) {
        Validate.notBlank((CharSequence)tenantCode, (String)"\u8fdb\u884c\u4f18\u60e0\u8ba1\u7b97\u65f6\uff0c\u7ecf\u9500\u5546\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)customerCode, (String)"\u8fdb\u884c\u4f18\u60e0\u8ba1\u7b97\u65f6\uff0c\u5ba2\u6237\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(initPolicyProducts) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u4f18\u60e0\u8ba1\u7b97\u65f6\uff0c\u53c2\u4e0e\u4f18\u60e0\u7684\u603b\u4f53\u672c\u54c1\u89c4\u683c\u4fe1\u606f\uff0c\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        long initPolicyProductSpecificationCodeSize = initPolicyProducts.stream().map(SalePolicyConProduct::getProductCode).distinct().count();
        Validate.isTrue((initPolicyProductSpecificationCodeSize == (long)initPolicyProducts.size() ? 1 : 0) != 0, (String)"\u8fdb\u884c\u4f18\u60e0\u8ba1\u7b97\u65f6\uff0c\u53c2\u4e0e\u4f18\u60e0\u7684\u603b\u4f53\u672c\u54c1\u89c4\u683c\u4fe1\u606f\uff0c\u5fc5\u987b\u4f20\u5165\u4e14\u4e0d\u80fd\u91cd\u590d!!", (Object[])new Object[0]);
        Set salePolicies = this.salePolicyVoService.findDetailsByProcessingAndCustomerCode(tenantCode, true, customerCode, null);
        if (CollectionUtils.isEmpty((Collection)salePolicies)) {
            return null;
        }
        DefaultPolicyExecuteContext executreContext = this.buildDefaultPolicyExecuteContext(salePolicies, initPolicyProducts, tenantCode, customerCode, kneading, false, null);
        return executreContext.streamlining();
    }

    private DefaultPolicyExecuteContext buildDefaultPolicyExecuteContext(Set<SalePolicyVo> initSalePolicys, Set<SalePolicyConProduct> initPolicyProducts, String tenantCode, String customerCode, boolean kneading, boolean formal, String relevanceCode) {
        BigDecimal productsTotalAmount = BigDecimal.ZERO;
        BigDecimal productsTotalNumber = BigDecimal.ZERO;
        for (SalePolicyConProduct policyConProduct : initPolicyProducts) {
            productsTotalAmount = productsTotalAmount.add(policyConProduct.getSubtotalAmount());
            productsTotalNumber = productsTotalNumber.add(policyConProduct.getQuantity());
        }
        if (initSalePolicys == null) {
            initSalePolicys = Sets.newLinkedHashSet();
        }
        DefaultPolicyExecuteContext executreContext = new DefaultPolicyExecuteContext(initPolicyProducts, initSalePolicys, productsTotalAmount, productsTotalNumber.intValue(), tenantCode, customerCode, kneading, formal, relevanceCode);
        Map<String, SalePolicyConProduct> remainingPolicyProducts = initPolicyProducts.stream().collect(Collectors.toMap(SalePolicyConProduct::getProductCode, item -> item));
        Set targetPolicyProductCodes = remainingPolicyProducts.values().stream().map(SalePolicyConProduct::getProductCode).collect(Collectors.toSet());
        for (SalePolicyVo salePolicyItem : initSalePolicys) {
            Set sourceProducts;
            if (salePolicyItem.getWholePolicy().booleanValue() || CollectionUtils.isEmpty((Collection)(sourceProducts = salePolicyItem.getSalePolicyProductInfos()))) continue;
            Set sourceProductCodes = sourceProducts.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getProductCode())).map(AbstractSalePolicyProductInfo::getProductCode).collect(Collectors.toSet());
            Sets.SetView intersectionCodeValues = Sets.intersection(targetPolicyProductCodes, sourceProductCodes);
            if (!CollectionUtils.isEmpty((Collection)intersectionCodeValues)) {
                executreContext.addNewMathedPolicy(salePolicyItem, intersectionCodeValues.toArray(new String[0]));
                for (String intersectionCode : intersectionCodeValues) {
                    remainingPolicyProducts.remove(intersectionCode);
                }
                continue;
            }
            String message = "\u672a\u6db5\u76d6\u8be5\u653f\u7b56\u8303\u56f4\u5185\u7684\u5546\u54c1\u4fe1\u606f.";
            executreContext.addExcludedPolicy(salePolicyItem, message);
        }
        for (SalePolicyVo salePolicyItem : initSalePolicys) {
            if (!salePolicyItem.getWholePolicy().booleanValue()) continue;
            executreContext.addNewMathedPolicy(salePolicyItem, (String[])initPolicyProducts.stream().map(SalePolicyConProduct::getProductCode).toArray(String[]::new));
        }
        return executreContext;
    }

    public DefaultPolicyExecuteContext preExecute(Set<SalePolicyConProduct> initPolicyProducts, Map<String, String[]> selectPolicyCodeMapping, String tenantCode, String customerCode, boolean kneading) {
        return this.execute(initPolicyProducts, selectPolicyCodeMapping, tenantCode, customerCode, kneading, false, null);
    }

    public DefaultPolicyExecuteContext preExecute(Set<SalePolicyConProduct> initPolicyProducts, String tenantCode, String customerCode, boolean kneading) {
        return this.preExecute((Set)initPolicyProducts, (Map)null, tenantCode, customerCode, kneading);
    }

    private Pair<Map<String, Set<String>>, String> validateSalePolicyThreshold(SalePolicyTempleteRegister salePolicyTempleteRegister, DefaultPolicyExecuteContext executeContext, Set<String> policyConProductCodes, SalePolicyVo currentSalePolicy) {
        SalePolicyStickupListener salePolicyStickupListener = salePolicyTempleteRegister.getStickupListener();
        AbstractSalePolicyThreshold salePolicyThreshold = currentSalePolicy.getSalePolicyProductThreshold();
        Set<SalePolicyConProduct> latestPolicyProducts = this.buildLatestPolicyProducts(policyConProductCodes, executeContext);
        Pair thresholdMatchedPair = salePolicyStickupListener.executeThreshold(latestPolicyProducts, (AbstractPolicyExecuteContext)executeContext, salePolicyThreshold);
        return thresholdMatchedPair;
    }

    private Set<SalePolicyConProduct> buildLatestPolicyProducts(Set<String> productCodes, DefaultPolicyExecuteContext executeContext) {
        LinkedHashSet policyConProducts = Sets.newLinkedHashSet();
        for (String productCode : productCodes) {
            ProductPolicyStepResult productPolicyStepResult = executeContext.findLastProductStepResultByProductCode(productCode);
            SalePolicyConProduct defaultPolicyConProduct = new SalePolicyConProduct();
            defaultPolicyConProduct.setProductCode(productCode);
            defaultPolicyConProduct.setQuantity(new BigDecimal(productPolicyStepResult.getInitNumbers()));
            defaultPolicyConProduct.setSubtotalAmount(productPolicyStepResult.getLastSubtotal());
            defaultPolicyConProduct.setUnitPrice(productPolicyStepResult.getLastPrices());
            policyConProducts.add(defaultPolicyConProduct);
        }
        return policyConProducts;
    }

    private List<String> sortPolicy(Set<SalePolicyVo> salePolicies) {
        String[] typesorts;
        List productSalePolicies = salePolicies.stream().filter(item -> item.getWholePolicy() == false).collect(Collectors.toList());
        ArrayList noConfigProductSalePolicies = Lists.newArrayList(productSalePolicies);
        ArrayList sortedProductSalePolicies = Lists.newArrayList();
        for (String string : typesorts = this.simplePolicyProperties.getTypesorts()) {
            for (SalePolicyVo productSalePolicy : productSalePolicies) {
                String type = productSalePolicy.getType();
                if (!StringUtils.equals((CharSequence)string, (CharSequence)type)) continue;
                sortedProductSalePolicies.add(productSalePolicy);
                noConfigProductSalePolicies.remove(productSalePolicy);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)noConfigProductSalePolicies)) {
            sortedProductSalePolicies.addAll(noConfigProductSalePolicies);
        }
        List wholePolicySalePolicies = salePolicies.stream().filter(item -> item.getWholePolicy()).collect(Collectors.toList());
        ArrayList noConfigWholeSalePolicies = Lists.newArrayList(wholePolicySalePolicies);
        ArrayList sortedWholeSalePolicies = Lists.newArrayList();
        for (String typesort : typesorts) {
            for (SalePolicyVo wholePolicySalePolicy : wholePolicySalePolicies) {
                String type = wholePolicySalePolicy.getType();
                if (!StringUtils.equals((CharSequence)typesort, (CharSequence)type)) continue;
                sortedWholeSalePolicies.add(wholePolicySalePolicy);
                noConfigWholeSalePolicies.remove(wholePolicySalePolicy);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)noConfigWholeSalePolicies)) {
            sortedWholeSalePolicies.addAll(noConfigWholeSalePolicies);
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)sortedProductSalePolicies);
        arrayList.addAll(sortedWholeSalePolicies);
        return arrayList.stream().map(SalePolicyVo::getSalePolicyCode).collect(Collectors.toList());
    }

    private SalePolicyTempleteRegister findSalePolicyTempleteRegister(String type) {
        Validate.notBlank((CharSequence)"\u9519\u8bef\u7684\u4f18\u60e0\u653f\u7b56\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u503c");
        Validate.isTrue((!CollectionUtils.isEmpty(this.salePolicyTempleteRegisters) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684SalePolicyRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyTempleteRegister matchedSalePolicyTempleteRegister = null;
        for (SalePolicyTempleteRegister item : this.salePolicyTempleteRegisters) {
            if (!StringUtils.equals((CharSequence)type, (CharSequence)item.getType())) continue;
            matchedSalePolicyTempleteRegister = item;
            break;
        }
        Validate.notNull(matchedSalePolicyTempleteRegister, (String)"\u672a\u5339\u914d\u4efb\u4f55SalePolicyTempleteRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return matchedSalePolicyTempleteRegister;
    }

    private SalePolicyCycleRuleStrategy findCorrectCycleRuleStrategy(SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> salePolicyExecuteStrategy, String cycleRuleCode) {
        Set<SalePolicyCycleRuleStrategy> bindableCycleRuleStrategies = this.findAllBindingCycleRuleStrategy(salePolicyExecuteStrategy);
        Validate.isTrue((!CollectionUtils.isEmpty(bindableCycleRuleStrategies) ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u5f53\u524d\u4f18\u60e0\u653f\u7b56\u6709\u81f3\u5c11\u4e00\u4e2a\u80fd\u7ed1\u5b9a\u7684\u9636\u68af\u6267\u884c\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LinkedHashMap bindableCycleRuleStrategyMapping = Maps.newLinkedHashMap();
        for (SalePolicyCycleRuleStrategy salePolicyCycleRuleStrategy : bindableCycleRuleStrategies) {
            bindableCycleRuleStrategyMapping.put(salePolicyCycleRuleStrategy.getCycleRuleCode(), salePolicyCycleRuleStrategy);
        }
        Validate.notBlank((CharSequence)cycleRuleCode, (String)"\u81f3\u5c11\u4e00\u4e2a\u5c06\u8981\u4fdd\u5b58\u7684\u4f18\u60e0\u6267\u884c\u7b56\u7565\u6ca1\u6709\u6307\u5b9acycleRuleCode\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyCycleRuleStrategy currentSalePolicyCycleRuleStrategy = (SalePolicyCycleRuleStrategy)((HashMap)bindableCycleRuleStrategyMapping).get(cycleRuleCode);
        Validate.notNull((Object)currentSalePolicyCycleRuleStrategy, (String)"\u672a\u5339\u914d\u5230\u4e1a\u52a1\u7f16\u53f7\u4e3a:%s \u7684\u9636\u68af\u6267\u884c\u89c4\u5219\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{cycleRuleCode});
        return currentSalePolicyCycleRuleStrategy;
    }

    private Set<SalePolicyCycleRuleStrategy> findAllBindingCycleRuleStrategy(SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> salePolicyExecuteStrategy) {
        Collection bindableCycleRuleStrategyClasses = salePolicyExecuteStrategy.getCycleRuleStrategyClasses();
        if (CollectionUtils.isEmpty((Collection)bindableCycleRuleStrategyClasses)) {
            return null;
        }
        LinkedHashSet bindableCycleRuleStrategySet = Sets.newLinkedHashSet();
        for (Class bindableCycleRuleStrategyClass : bindableCycleRuleStrategyClasses) {
            try {
                SalePolicyCycleRuleStrategy currentSalePolicyCycleRuleStrategy = (SalePolicyCycleRuleStrategy)this.applicationContext.getBean(bindableCycleRuleStrategyClass);
                bindableCycleRuleStrategySet.add(currentSalePolicyCycleRuleStrategy);
            }
            catch (RuntimeException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return bindableCycleRuleStrategySet;
    }

    private AbstractSalePolicyExecutorInfo findCorrectExecutorInfo(SalePolicyVo salePolicy, String executorCode) {
        Set salePolicyExecutorInfos = salePolicy.getSalePolicyExecutorInfos();
        if (CollectionUtils.isEmpty((Collection)salePolicyExecutorInfos)) {
            return null;
        }
        for (AbstractSalePolicyExecutorInfo salePolicyExecutorInfo : salePolicyExecutorInfos) {
            if (!StringUtils.equals((CharSequence)salePolicyExecutorInfo.getExecutorCode(), (CharSequence)executorCode)) continue;
            return salePolicyExecutorInfo;
        }
        return null;
    }

    private Set<SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo>> findAllBindingExecuteStrategy(SalePolicyTempleteRegister salePolicyTempleteRegister) {
        Collection bindableExecuteStrategyClasses = salePolicyTempleteRegister.getExecuteStrategyClasses();
        if (CollectionUtils.isEmpty((Collection)bindableExecuteStrategyClasses)) {
            return null;
        }
        LinkedHashSet bindableExecuteStrategySet = Sets.newLinkedHashSet();
        for (Class bindableExecuteStrategyClass : bindableExecuteStrategyClasses) {
            try {
                SalePolicyExecuteStrategy currentSalePolicyExecuteStrategy = (SalePolicyExecuteStrategy)this.applicationContext.getBean(bindableExecuteStrategyClass);
                bindableExecuteStrategySet.add(currentSalePolicyExecuteStrategy);
            }
            catch (RuntimeException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return bindableExecuteStrategySet;
    }

    private SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> findCorrectExecuteStrategy(SalePolicyTempleteRegister salePolicyTempleteRegister, String executeStrategyCode) {
        Set<SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo>> bindableExecuteStrategies = this.findAllBindingExecuteStrategy(salePolicyTempleteRegister);
        Validate.isTrue((!CollectionUtils.isEmpty(bindableExecuteStrategies) ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u5f53\u524d\u4f18\u60e0\u653f\u7b56\u6709\u81f3\u5c11\u4e00\u4e2a\u80fd\u7ed1\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u6267\u884c\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LinkedHashMap bindableExecuteStrategyMapping = Maps.newLinkedHashMap();
        for (SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> salePolicyExecuteStrategy : bindableExecuteStrategies) {
            bindableExecuteStrategyMapping.put(salePolicyExecuteStrategy.getExecuteStrategyCode(), salePolicyExecuteStrategy);
        }
        Validate.notBlank((CharSequence)executeStrategyCode, (String)"\u81f3\u5c11\u4e00\u4e2a\u5c06\u8981\u4fdd\u5b58\u7684\u4f18\u60e0\u6267\u884c\u7b56\u7565\u6ca1\u6709\u6307\u5b9aexecuteStrategyCode\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyExecuteStrategy currentSalePolicyExecuteStrategy = (SalePolicyExecuteStrategy)((HashMap)bindableExecuteStrategyMapping).get(executeStrategyCode);
        Validate.notNull((Object)currentSalePolicyExecuteStrategy, (String)"\u672a\u5339\u914d\u5230\u4e1a\u52a1\u7f16\u53f7\u4e3a:%s \u7684\u4f18\u60e0\u6267\u884c\u7b56\u7565\u4fe1\u606f\uff0c\u53ef\u80fd\u662f\u8be5\u653f\u7b56\u4e0d\u5b58\u5728\u6216\u8005\u8be5\u4f18\u60e0\u653f\u7b56\u4e0d\u5141\u8bb8\u5173\u8054\u8fd9\u4e2a\u6267\u884c\u653f\u7b56\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{executeStrategyCode});
        return currentSalePolicyExecuteStrategy;
    }

    private SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo> findCorrectLimitStrategy(SalePolicyTempleteRegister matchedSalePolicyTempleteRegister, String limitStrategyCode) {
        Set<SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo>> bindableLimitStrategies = this.findAllBindingLimitStrategy(matchedSalePolicyTempleteRegister);
        Validate.isTrue((!CollectionUtils.isEmpty(bindableLimitStrategies) ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u5f53\u524d\u4f18\u60e0\u653f\u7b56\u6709\u81f3\u5c11\u4e00\u4e2a\u80fd\u7ed1\u5b9a\u7684\u9650\u4ef7\u653f\u7b56\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LinkedHashMap bindableLimitStrategyMapping = Maps.newLinkedHashMap();
        for (SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo> salePolicyLimitStrategy : bindableLimitStrategies) {
            bindableLimitStrategyMapping.put(salePolicyLimitStrategy.getLimitStrategyCode(), salePolicyLimitStrategy);
        }
        Validate.notBlank((CharSequence)limitStrategyCode, (String)"\u81f3\u5c11\u4e00\u4e2a\u5c06\u8981\u4fdd\u5b58\u7684\u73b0\u4ef7\u7b56\u7565\u6ca1\u6709\u6307\u5b9acode\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyLimitStrategy currentSalePolicyLimitStrategy = (SalePolicyLimitStrategy)((HashMap)bindableLimitStrategyMapping).get(limitStrategyCode);
        Validate.notNull((Object)currentSalePolicyLimitStrategy, (String)"\u672a\u5339\u914d\u5230\u4e1a\u52a1\u7f16\u53f7\u4e3a:%s \u7684\u9650\u91cf\u653f\u7b56\u4fe1\u606f\uff0c\u53ef\u80fd\u662f\u8be5\u653f\u7b56\u4e0d\u5b58\u5728\u6216\u8005\u6539\u4f18\u60e0\u653f\u7b56\u4e0d\u5141\u8bb8\u5173\u8054\u8fd9\u4e2a\u9650\u91cf\u653f\u7b56\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{limitStrategyCode});
        return currentSalePolicyLimitStrategy;
    }

    private Set<SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo>> findAllBindingLimitStrategy(SalePolicyTempleteRegister matchedSalePolicyTempleteRegister) {
        Collection bindableLimitStrategyClasses = matchedSalePolicyTempleteRegister.getBindableLimitStrategyClasses();
        if (CollectionUtils.isEmpty((Collection)bindableLimitStrategyClasses)) {
            return null;
        }
        LinkedHashSet bindableLimitStrategySet = Sets.newLinkedHashSet();
        for (Class bindableLimitStrategyClass : bindableLimitStrategyClasses) {
            try {
                SalePolicyLimitStrategy currentSalePolicyLimitStrategy = (SalePolicyLimitStrategy)this.applicationContext.getBean(bindableLimitStrategyClass);
                bindableLimitStrategySet.add(currentSalePolicyLimitStrategy);
            }
            catch (RuntimeException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return bindableLimitStrategySet;
    }

    @Transactional
    public DefaultPolicyExecuteContext execute(String relevanceCode, Set<SalePolicyConProduct> initPolicyProducts, Map<String, String[]> selectPolicyCodeMapping, String tenantCode, String customerCode, boolean kneading) {
        return this.execute(initPolicyProducts, selectPolicyCodeMapping, tenantCode, customerCode, kneading, true, relevanceCode);
    }

    private DefaultPolicyExecuteContext execute(Set<SalePolicyConProduct> initPolicyProducts, Map<String, String[]> selectPolicyCodeMapping, String tenantCode, String customerCode, boolean kneading, boolean formal, String relevanceCode) {
        Validate.notBlank((CharSequence)tenantCode, (String)"\u8fdb\u884c\u4f18\u60e0\u8ba1\u7b97\u65f6\uff0c\u7ecf\u9500\u5546\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)customerCode, (String)"\u8fdb\u884c\u4f18\u60e0\u8ba1\u7b97\u65f6\uff0c\u5ba2\u6237\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(initPolicyProducts) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u4f18\u60e0\u8ba1\u7b97\u65f6\uff0c\u53c2\u4e0e\u4f18\u60e0\u7684\u603b\u4f53\u672c\u54c1\u89c4\u683c\u4fe1\u606f\uff0c\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        long initPolicyProductSpecificationCodeSize = initPolicyProducts.stream().map(SalePolicyConProduct::getProductCode).distinct().count();
        Validate.isTrue((initPolicyProductSpecificationCodeSize == (long)initPolicyProducts.size() ? 1 : 0) != 0, (String)"\u8fdb\u884c\u4f18\u60e0\u8ba1\u7b97\u65f6\uff0c\u53c2\u4e0e\u4f18\u60e0\u7684\u603b\u4f53\u672c\u54c1\u89c4\u683c\u4fe1\u606f\uff0c\u5fc5\u987b\u4f20\u5165\u4e14\u4e0d\u80fd\u91cd\u590d!!", (Object[])new Object[0]);
        Set initSalePolicyies = this.salePolicyVoService.findDetailsByProcessingAndCustomerCode(tenantCode, true, customerCode, relevanceCode);
        if (CollectionUtils.isEmpty((Collection)initSalePolicyies)) {
            return this.buildDefaultPolicyExecuteContext(null, initPolicyProducts, tenantCode, customerCode, kneading, formal, relevanceCode);
        }
        if (formal) {
            Validate.notBlank((CharSequence)relevanceCode, (String)"\u5f53\u6b63\u5f0f\u6267\u884c\u4f18\u60e0\u653f\u7b56\u8ba1\u7b97\u65f6\uff0c\u53d1\u751f\u4f18\u60e0\u7684\u4e1a\u52a1\u5355\u636e\u7f16\u53f7\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((this.salePolicyRecordService.findByBillCode(relevanceCode, tenantCode, customerCode) == null ? 1 : 0) != 0, (String)"\u5f53\u6b63\u5f0f\u6267\u884c\u4f18\u60e0\u653f\u7b56\u8ba1\u7b97\u65f6\uff0c\u53d1\u73b0\u6307\u5b9a\u5355\u636e\u5df2\u7ecf\u6267\u884c\u8fc7\u4f18\u60e0\uff0c\u4e0d\u80fd\u91cd\u590d\u6267\u884c\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        for (SalePolicyConProduct salePolicyConProduct : initPolicyProducts) {
            BigDecimal bigDecimal = salePolicyConProduct.getQuantity();
            BigDecimal unitPrice = salePolicyConProduct.getUnitPrice();
            BigDecimal subtotalAmount = salePolicyConProduct.getSubtotalAmount();
            Validate.isTrue((bigDecimal != null && bigDecimal.floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u8ba1\u7b97\u65f6\uff0c\u5546\u54c1\u521d\u59cb\u5355\u4ef7\u5fc5\u987b\u5927\u4e8e0\uff01\uff01", (Object[])new Object[0]);
            Validate.isTrue((unitPrice != null && unitPrice.floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u8ba1\u7b97\u65f6\uff0c\u5546\u54c1\u521d\u59cb\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\uff01\uff01", (Object[])new Object[0]);
            Validate.isTrue((subtotalAmount != null && subtotalAmount.floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u8ba1\u7b97\u65f6\uff0c\u5546\u54c1\u521d\u59cb\u5c0f\u8ba1\u603b\u4ef7\u5fc5\u987b\u5927\u4e8e0\uff01\uff01", (Object[])new Object[0]);
        }
        DefaultPolicyExecuteContext executeContext = this.buildDefaultPolicyExecuteContext(initSalePolicyies, initPolicyProducts, tenantCode, customerCode, kneading, formal, relevanceCode);
        if (!CollectionUtils.isEmpty(selectPolicyCodeMapping)) {
            for (Map.Entry<String, String[]> entry : selectPolicyCodeMapping.entrySet()) {
                Object mustExcludePolicyCodes;
                String selectProductCode = entry.getKey();
                Object[] selectPolicyCodes = entry.getValue();
                if (selectPolicyCodes == null) continue;
                if (selectPolicyCodes.length == 0) {
                    selectPolicyCodes = new String[]{};
                }
                HashSet selectPolicyCodeSet = Sets.newHashSet((Object[])selectPolicyCodes);
                LinkedHashSet matchedPolicies = executeContext.findPolicyCodesByProductCode(selectProductCode);
                if (CollectionUtils.isEmpty(matchedPolicies)) {
                    matchedPolicies = Sets.newLinkedHashSet();
                }
                if (CollectionUtils.isEmpty((Collection)(mustExcludePolicyCodes = Sets.difference((Set)matchedPolicies, (Set)selectPolicyCodeSet)))) continue;
                mustExcludePolicyCodes = Sets.newLinkedHashSet((Iterable)mustExcludePolicyCodes);
                Iterator iterator = mustExcludePolicyCodes.iterator();
                while (iterator.hasNext()) {
                    String mustExcludePolicyCode = (String)iterator.next();
                    executeContext.excludeMatchedPolicyMapping(selectProductCode, mustExcludePolicyCode);
                }
            }
        }
        DefaultPolicyExecuteContext defaultPolicyExecuteContext = this.doExecute(executeContext, initSalePolicyies, initPolicyProducts, tenantCode, customerCode, formal, relevanceCode);
        return defaultPolicyExecuteContext;
    }

    private DefaultPolicyExecuteContext doExecute(DefaultPolicyExecuteContext executeContext, Set<SalePolicyVo> initSalePolicyies, Set<SalePolicyConProduct> initPolicyProducts, String tenantCode, String customerCode, boolean formal, String relevanceCode) {
        Set<String> conProductCodes;
        Map<String, SalePolicyVo> initSalePolicyMapping = initSalePolicyies.stream().collect(Collectors.toMap(SalePolicyVo::getSalePolicyCode, item -> item));
        Set<String> preJudgmentMatchedPolicyCodes = executeContext.getMatchedPolicyInfos();
        if (CollectionUtils.isEmpty(preJudgmentMatchedPolicyCodes)) {
            return executeContext;
        }
        Set<SalePolicyVo> preJudgmentSalePolicies = initSalePolicyies.stream().filter(salePolicyItem -> preJudgmentMatchedPolicyCodes.contains(salePolicyItem.getSalePolicyCode())).collect(Collectors.toSet());
        List<String> sortedPreJudgmentSalePolicyCodes = this.sortPolicy(preJudgmentSalePolicies);
        ArrayList notExcludedSortedPreJudgmentSalePolicyCodes = Lists.newArrayList(sortedPreJudgmentSalePolicyCodes);
        if (!CollectionUtils.isEmpty(this.characteristicStrateis)) {
            block8: for (CharacteristicStrategy characteristicStrategy : this.characteristicStrateis) {
                for (int index = 0; index < notExcludedSortedPreJudgmentSalePolicyCodes.size(); ++index) {
                    Object errorMsg;
                    CharacteristicVoter characteristicVoter;
                    CharSequence[] selectedCharacteristicCodes;
                    String currentSalePolicyCode = (String)notExcludedSortedPreJudgmentSalePolicyCodes.get(index);
                    SalePolicyVo preJudgmentSalePolicy = initSalePolicyMapping.get(currentSalePolicyCode);
                    String characteristicCode = characteristicStrategy.characteristicCode();
                    Set selectedCharacteristicInfos = preJudgmentSalePolicy.getCharacteristicInfos();
                    if (CollectionUtils.isEmpty((Collection)selectedCharacteristicInfos) || !StringUtils.equalsAny((CharSequence)characteristicCode, (CharSequence[])(selectedCharacteristicCodes = (String[])selectedCharacteristicInfos.stream().map(AbstractCharacteristicInfo::getCharacteristicCode).toArray(String[]::new))) || (characteristicVoter = characteristicStrategy.make((AbstractPolicyExecuteContext)executeContext, preJudgmentSalePolicy, customerCode, formal, relevanceCode)) == null || characteristicVoter == CharacteristicVoter.GRANTED) continue;
                    if (characteristicVoter == CharacteristicVoter.DENIED) {
                        errorMsg = characteristicStrategy.errorMsg(preJudgmentSalePolicy);
                        executeContext.addExcludedPolicy(preJudgmentSalePolicy, (String)errorMsg);
                        notExcludedSortedPreJudgmentSalePolicyCodes.remove(index);
                        --index;
                        continue;
                    }
                    errorMsg = characteristicStrategy.errorMsg(preJudgmentSalePolicy);
                    for (Object notExcludedSortedPreJudgmentSalePolicyCode : notExcludedSortedPreJudgmentSalePolicyCodes) {
                        SalePolicyVo salePolicyVo;
                        if (StringUtils.equals((CharSequence)notExcludedSortedPreJudgmentSalePolicyCode, (CharSequence)currentSalePolicyCode) || (salePolicyVo = initSalePolicyMapping.get(notExcludedSortedPreJudgmentSalePolicyCode)) == null) continue;
                        executeContext.addExcludedPolicy(salePolicyVo, (String)errorMsg);
                    }
                    notExcludedSortedPreJudgmentSalePolicyCodes.clear();
                    notExcludedSortedPreJudgmentSalePolicyCodes.add(currentSalePolicyCode);
                    continue block8;
                }
            }
        }
        block11: for (String string : sortedPreJudgmentSalePolicyCodes) {
            SalePolicyVo preJudgmentSalePolicy = initSalePolicyMapping.get(string);
            if (preJudgmentSalePolicy.getWholePolicy().booleanValue() || CollectionUtils.isEmpty(conProductCodes = executeContext.findProductCodesByPolicyCode(string))) continue;
            SalePolicyTempleteRegister salePolicyTempleteRegister = this.findSalePolicyTempleteRegister(preJudgmentSalePolicy.getType());
            Pair<Map<String, Set<String>>, String> thresholdMatchedPair = this.validateSalePolicyThreshold(salePolicyTempleteRegister, executeContext, conProductCodes, preJudgmentSalePolicy);
            Map thresholdMatchedMapping = (Map)thresholdMatchedPair.getLeft();
            String errorMsg = (String)thresholdMatchedPair.getRight();
            if (CollectionUtils.isEmpty((Map)thresholdMatchedMapping)) {
                executeContext.addExcludedPolicy(preJudgmentSalePolicy, errorMsg);
                continue;
            }
            LinkedHashSet allMatchedProductCodes = Sets.newLinkedHashSet();
            for (Set groupProductCodes : thresholdMatchedMapping.values()) {
                allMatchedProductCodes.addAll(groupProductCodes);
            }
            Set initPolicyProductCodes = initPolicyProducts.stream().map(SalePolicyConProduct::getProductCode).collect(Collectors.toSet());
            executeContext.addNewMathedPolicy(preJudgmentSalePolicy, (String[])Sets.intersection(initPolicyProductCodes, (Set)allMatchedProductCodes).toArray((Object[])new String[0]));
            Set salePolicyProductInfos = preJudgmentSalePolicy.getSalePolicyProductInfos();
            Map<String, AbstractSalePolicyProductInfo> salePolicyProductInfoMapping = salePolicyProductInfos.stream().collect(Collectors.toMap(AbstractSalePolicyProductInfo::getProductCode, item -> item));
            LinkedHashMap productInfoExecutorGroupMapping = Maps.newLinkedHashMap();
            for (Map.Entry entry2 : thresholdMatchedMapping.entrySet()) {
                Set matchedThresholdProductCodes = (Set)entry2.getValue();
                Set matchedProductCodes = salePolicyProductInfoMapping.entrySet().stream().filter(entry -> matchedThresholdProductCodes.contains(entry.getKey())).map(entry -> (String)entry.getKey()).collect(Collectors.toSet());
                if (matchedProductCodes == null || matchedThresholdProductCodes.size() != matchedProductCodes.size()) {
                    executeContext.addExcludedPolicy(preJudgmentSalePolicy, "\u4f18\u60e0\u95e8\u69db\u4e2d\u7684\u5546\u54c1\u4fe1\u606f\u548c\u5b9e\u9645\u672c\u54c1\u4fe1\u606f\u53d1\u751f\u4e86\u51b2\u7a81\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    continue block11;
                }
                Map<String, List<AbstractSalePolicyProductInfo>> currentProductInfoExecutorGroupMapping = salePolicyProductInfoMapping.entrySet().stream().filter(entry -> matchedThresholdProductCodes.contains(entry.getKey())).filter(entry -> conProductCodes.contains(((AbstractSalePolicyProductInfo)entry.getValue()).getProductCode())).map(entry -> (AbstractSalePolicyProductInfo)entry.getValue()).collect(Collectors.groupingBy(AbstractSalePolicyProductInfo::getExecutorCode));
                if (currentProductInfoExecutorGroupMapping.size() != 1) {
                    executeContext.addExcludedPolicy(preJudgmentSalePolicy, "\u4f18\u60e0\u95e8\u69db\u4e2d\u7684\u5546\u54c1\u4fe1\u606f\u5e76\u4e0d\u5c5e\u4e8e\u540c\u4e00\u79cd\u6267\u884c\u7b56\u7565\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    continue block11;
                }
                if (CollectionUtils.isEmpty((Collection)currentProductInfoExecutorGroupMapping.entrySet().iterator().next().getValue())) continue block11;
                productInfoExecutorGroupMapping.putAll(currentProductInfoExecutorGroupMapping);
            }
            block14: for (Map.Entry entry3 : productInfoExecutorGroupMapping.entrySet()) {
                String executorCode = (String)entry3.getKey();
                List executorGroupProductInfos = (List)entry3.getValue();
                Set<String> executorGroupProductCodes = executorGroupProductInfos.stream().map(AbstractSalePolicyProductInfo::getProductCode).collect(Collectors.toSet());
                AbstractSalePolicyExecutorInfo salePolicyExecutorInfo = this.findCorrectExecutorInfo(preJudgmentSalePolicy, executorCode);
                if (salePolicyExecutorInfo == null) {
                    log.warn("\u5728\u4f18\u60e0\u653f\u7b56(%s)\u4e2d\uff0c\u6ca1\u6709\u627e\u5230\u4e1a\u52a1\u7f16\u53f7\u4e3a(%s)\u7684\u4f18\u60e0\u653f\u7b56\u6267\u884c\u7b56\u7565\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4f18\u60e0\u653f\u7b56\u8bbe\u5b9a", (Object)preJudgmentSalePolicy.getSalePolicyCode(), (Object)executorCode);
                    continue;
                }
                SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> salePolicyExecuteStrategy = this.findCorrectExecuteStrategy(salePolicyTempleteRegister, salePolicyExecutorInfo.getExecuteStrategyCode());
                SalePolicyCycleRuleStrategy salePolicyCycleRuleStrategy = this.findCorrectCycleRuleStrategy(salePolicyExecuteStrategy, salePolicyExecutorInfo.getCycleRuleCode());
                Set initPolicyProductsForCycleExecutes = initPolicyProducts.stream().filter(item -> executorGroupProductCodes.contains(item.getProductCode())).collect(Collectors.toSet());
                AbstractCycleExecuteContext cycleExecuteContext = salePolicyExecuteStrategy.buildCycleExecuteContext((AbstractPolicyExecuteContext)executeContext, executorCode, initPolicyProductsForCycleExecutes, customerCode);
                salePolicyCycleRuleStrategy.cycle(cycleExecuteContext, salePolicyExecuteStrategy, preJudgmentSalePolicy, salePolicyExecutorInfo);
                Class salePolicyExecuteShareStrategyClass = salePolicyExecuteStrategy.getSalePolicyExecuteShareStrategy();
                SalePolicyExecuteShareStrategy salePolicyExecuteShareStrategy = (SalePolicyExecuteShareStrategy)this.applicationContext.getBean(salePolicyExecuteShareStrategyClass);
                salePolicyExecuteShareStrategy.share(customerCode, preJudgmentSalePolicy, (AbstractPolicyExecuteContext)executeContext, cycleExecuteContext, executorGroupProductCodes);
                Set salePolicyLimitInfos = preJudgmentSalePolicy.getSalePolicyLimitInfos();
                if (CollectionUtils.isEmpty((Collection)salePolicyLimitInfos)) continue;
                for (AbstractSalePolicyLimitInfo salePolicyLimitInfo : salePolicyLimitInfos) {
                    String limitStrategyCode = salePolicyLimitInfo.getLimitStrategyCode();
                    SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo> salePolicyLimitStrategy = this.findCorrectLimitStrategy(salePolicyTempleteRegister, limitStrategyCode);
                    Validate.notNull(salePolicyLimitStrategy, (String)"\u4f18\u60e0\u653f\u7b56\u9884\u6267\u884c\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u9650\u91cf\u8bbe\u5b9a\u4fe1\u606f\uff08%s\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{limitStrategyCode});
                    try {
                        salePolicyLimitStrategy.preValidate((AbstractPolicyExecuteContext)executeContext, cycleExecuteContext, preJudgmentSalePolicy, salePolicyLimitInfo);
                    }
                    catch (RuntimeException e) {
                        executeContext.resetExcludedPolicy(string, executorGroupProductCodes, e.getMessage());
                        continue block14;
                    }
                }
            }
            try {
                this.analysisRepeatSalePolicy(preJudgmentSalePolicy, executeContext, conProductCodes);
            }
            catch (RuntimeException e) {
                executeContext.resetExcludedPolicy(string, conProductCodes, e.getMessage());
            }
        }
        block16: for (String string : sortedPreJudgmentSalePolicyCodes) {
            SalePolicyVo preJudgmentSalePolicy = initSalePolicyMapping.get(string);
            if (!preJudgmentSalePolicy.getWholePolicy().booleanValue() || CollectionUtils.isEmpty(conProductCodes = executeContext.findProductCodesByPolicyCode(string))) continue;
            Set<SalePolicyConProduct> initPolicyProductsForWholePolicy = initPolicyProducts.stream().filter(initPolicyProduct -> conProductCodes.contains(initPolicyProduct.getProductCode())).collect(Collectors.toSet());
            SalePolicyTempleteRegister salePolicyTempleteRegister = this.findSalePolicyTempleteRegister(preJudgmentSalePolicy.getType());
            Pair<Map<String, Set<String>>, String> thresholdMatchedPair = this.validateSalePolicyThreshold(salePolicyTempleteRegister, executeContext, conProductCodes, preJudgmentSalePolicy);
            Map thresholdMatchedMapping = (Map)thresholdMatchedPair.getLeft();
            String errorMsg = (String)thresholdMatchedPair.getRight();
            if (CollectionUtils.isEmpty((Map)thresholdMatchedMapping)) {
                executeContext.addExcludedPolicy(preJudgmentSalePolicy, errorMsg);
                continue;
            }
            Set salePolicyExecutorInfos = preJudgmentSalePolicy.getSalePolicyExecutorInfos();
            if (CollectionUtils.isEmpty((Collection)salePolicyExecutorInfos)) {
                log.warn("\u5728\u6574\u5355\u4f18\u60e0\u653f\u7b56(%s)\u4e2d\uff0c\u6ca1\u6709\u53d1\u73b0\u4f18\u60e0\u6267\u884c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4f18\u60e0\u653f\u7b56\u8bbe\u5b9a");
                continue;
            }
            if (salePolicyExecutorInfos.size() != 1) {
                log.warn("\u5728\u6574\u5355\u4f18\u60e0\u653f\u7b56(%s)\u4e2d\uff0c\u53d1\u73b0\u591a\u6761\u4f18\u60e0\u6267\u884c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4f18\u60e0\u653f\u7b56\u8bbe\u5b9a");
                continue;
            }
            AbstractSalePolicyExecutorInfo salePolicyExecutorInfo = (AbstractSalePolicyExecutorInfo)salePolicyExecutorInfos.iterator().next();
            SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> salePolicyExecuteStrategy = this.findCorrectExecuteStrategy(salePolicyTempleteRegister, salePolicyExecutorInfo.getExecuteStrategyCode());
            SalePolicyCycleRuleStrategy salePolicyCycleRuleStrategy = this.findCorrectCycleRuleStrategy(salePolicyExecuteStrategy, salePolicyExecutorInfo.getCycleRuleCode());
            BigDecimal initSubtotalAmountForCycleExecutes = BigDecimal.ZERO;
            BigDecimal initSubtotalNumberForCycleExecutes = BigDecimal.ZERO;
            BigDecimal preSubtotalAmountForCycleExecutes = BigDecimal.ZERO;
            BigDecimal preSurplusSubtotalAmountForCycleExecutes = BigDecimal.ZERO;
            BigDecimal preSurplusSubtotalNumberForCycleExecutes = BigDecimal.ZERO;
            for (SalePolicyConProduct initPolicyProductForWholePolicy : initPolicyProductsForWholePolicy) {
                ProductPolicyStepResult productPolicyStepResult = executeContext.findLastProductStepResultByProductCode(initPolicyProductForWholePolicy.getProductCode());
                initSubtotalAmountForCycleExecutes = initSubtotalAmountForCycleExecutes.add(productPolicyStepResult.getInitSubtotal());
                initSubtotalNumberForCycleExecutes = initSubtotalNumberForCycleExecutes.add(new BigDecimal(productPolicyStepResult.getInitNumbers()));
                preSubtotalAmountForCycleExecutes = preSubtotalAmountForCycleExecutes.add(productPolicyStepResult.getLastSubtotal());
                preSurplusSubtotalAmountForCycleExecutes = preSurplusSubtotalAmountForCycleExecutes.add(productPolicyStepResult.getLastSurplusTotalAmount());
                preSurplusSubtotalNumberForCycleExecutes = preSurplusSubtotalNumberForCycleExecutes.add(new BigDecimal(productPolicyStepResult.getLastSurplusTotalNumber()));
            }
            DefaultCycleExecuteContext cycleExecuteContext = new DefaultCycleExecuteContext(salePolicyExecutorInfo.getExecutorCode(), customerCode, initPolicyProductsForWholePolicy, initSubtotalAmountForCycleExecutes, initSubtotalNumberForCycleExecutes.intValue(), preSubtotalAmountForCycleExecutes, preSurplusSubtotalAmountForCycleExecutes, preSurplusSubtotalNumberForCycleExecutes.intValue());
            salePolicyCycleRuleStrategy.cycle((AbstractCycleExecuteContext)cycleExecuteContext, salePolicyExecuteStrategy, preJudgmentSalePolicy, salePolicyExecutorInfo);
            Class salePolicyExecuteShareStrategyClass = salePolicyExecuteStrategy.getSalePolicyExecuteShareStrategy();
            SalePolicyExecuteShareStrategy salePolicyExecuteShareStrategy = (SalePolicyExecuteShareStrategy)this.applicationContext.getBean(salePolicyExecuteShareStrategyClass);
            salePolicyExecuteShareStrategy.share(customerCode, preJudgmentSalePolicy, (AbstractPolicyExecuteContext)executeContext, (AbstractCycleExecuteContext)cycleExecuteContext, initPolicyProductsForWholePolicy.stream().map(SalePolicyConProduct::getProductCode).collect(Collectors.toSet()));
            Set salePolicyLimitInfos = preJudgmentSalePolicy.getSalePolicyLimitInfos();
            if (!CollectionUtils.isEmpty((Collection)salePolicyLimitInfos)) {
                for (AbstractSalePolicyLimitInfo salePolicyLimitInfo : salePolicyLimitInfos) {
                    String limitStrategyCode = salePolicyLimitInfo.getLimitStrategyCode();
                    SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo> salePolicyLimitStrategy = this.findCorrectLimitStrategy(salePolicyTempleteRegister, limitStrategyCode);
                    Validate.notNull(salePolicyLimitStrategy, (String)"\u4f18\u60e0\u653f\u7b56\u9884\u6267\u884c\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u9650\u91cf\u8bbe\u5b9a\u4fe1\u606f\uff08%s\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{limitStrategyCode});
                    try {
                        salePolicyLimitStrategy.preValidate((AbstractPolicyExecuteContext)executeContext, (AbstractCycleExecuteContext)cycleExecuteContext, preJudgmentSalePolicy, salePolicyLimitInfo);
                    }
                    catch (RuntimeException e) {
                        executeContext.resetExcludedPolicy(string, null, e.getMessage());
                        continue block16;
                    }
                }
            }
            try {
                this.analysisRepeatSalePolicy(preJudgmentSalePolicy, executeContext, conProductCodes);
            }
            catch (RuntimeException e) {
                executeContext.resetExcludedPolicy(string, conProductCodes, e.getMessage());
            }
        }
        if (!formal) {
            return executeContext;
        }
        this.salePolicyRecordService.create(relevanceCode, executeContext);
        return executeContext;
    }

    private void analysisRepeatSalePolicy(SalePolicyVo salePolicy, DefaultPolicyExecuteContext executeContext, Set<String> salePolicyProductCodes) {
        String salePolicyCode = salePolicy.getSalePolicyCode();
        String templeteRegisterType = salePolicy.getTempleteRegisterType();
        if (StringUtils.isBlank((CharSequence)templeteRegisterType)) {
            return;
        }
        for (String salePolicyProductCode : salePolicyProductCodes) {
            Deque<ProductPolicyStepResult> productPolicyStepResults = executeContext.findPolicyStepResultsByProductCode(salePolicyProductCode);
            if (CollectionUtils.isEmpty(productPolicyStepResults)) continue;
            ProductPolicyStepResult peek = productPolicyStepResults.peek();
            Set salePolicyExecutorCodes = salePolicy.getSalePolicyExecutorInfos().stream().map(AbstractSalePolicyExecutorInfo::getExecutorCode).collect(Collectors.toSet());
            if (!StringUtils.equals((CharSequence)salePolicy.getSalePolicyCode(), (CharSequence)peek.getSalePolicyCode()) || !salePolicyExecutorCodes.contains(peek.getExecuteCode())) continue;
            for (ProductPolicyStepResult productPolicyStepResult : productPolicyStepResults) {
                SalePolicyVo currentSalePolicyVo;
                String currentTempleteRegisterType;
                String currentSalePolicyCode = productPolicyStepResult.getSalePolicyCode();
                if (StringUtils.isBlank((CharSequence)currentSalePolicyCode) || StringUtils.equals((CharSequence)currentSalePolicyCode, (CharSequence)salePolicyCode) || !StringUtils.equals((CharSequence)(currentTempleteRegisterType = (currentSalePolicyVo = this.salePolicyVoService.findDetailsByCode(currentSalePolicyCode)).getTempleteRegisterType()), (CharSequence)templeteRegisterType)) continue;
                throw new IllegalArgumentException("\u540c\u4e00\u79cd\u7c7b\u578b\u7684\u4f18\u60e0\u653f\u7b56\u4e0d\u80fd\u88ab\u91cd\u590d\u53c2\u4e0e");
            }
        }
    }

    public DefaultPolicyExecuteContext findByRelevanceCode(String relevanceCode, String tenantCode, String customerCode) {
        String initProductCodes;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{relevanceCode, tenantCode, customerCode})) {
            return null;
        }
        SalePolicyRecord historySalePolicyRecord = this.salePolicyRecordService.findByBillCode(relevanceCode, tenantCode, customerCode);
        if (historySalePolicyRecord == null) {
            return null;
        }
        Set<SalePolicyRecordProduct> salePolicyRecordProducts = historySalePolicyRecord.getSalePolicyRecordProducts();
        if (CollectionUtils.isEmpty(salePolicyRecordProducts)) {
            return null;
        }
        Map<String, SalePolicyRecordProduct> salePolicyRecordInitProductMapping = salePolicyRecordProducts.stream().filter(item -> StringUtils.equals((CharSequence)item.getStepType(), (CharSequence)StepType.INIT.toString())).collect(Collectors.toMap(SalePolicyRecordProduct::getProductCode, item -> item));
        Set<SalePolicyRecordProductSelectedPolicy> salePolicyRecordProductSelectedPolicys = historySalePolicyRecord.getSalePolicyRecordProductSelectedPolicys();
        Map<Object, Object> salePolicyRecordProductSelectedPolicyMapping = Maps.newLinkedHashMap();
        if (!CollectionUtils.isEmpty(salePolicyRecordProductSelectedPolicys)) {
            salePolicyRecordProductSelectedPolicyMapping = salePolicyRecordProductSelectedPolicys.stream().collect(Collectors.toMap(SalePolicyRecordProductSelectedPolicy::getProductCode, item -> item));
        }
        if (StringUtils.isBlank((CharSequence)(initProductCodes = historySalePolicyRecord.getProductCodes()))) {
            log.warn("\u91cd\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u5386\u53f2\u4e0a\u4e0b\u6587\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684initProductCodes\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u7684\u6d41\u6c34\u8bb0\u5f55!!");
            return null;
        }
        String[] initProductCodeArray = StringUtils.split((String)initProductCodes, (String)",");
        LinkedHashSet initPolicyProducts = Sets.newLinkedHashSet();
        for (String string : initProductCodeArray) {
            SalePolicyRecordProduct salePolicyRecordProduct = salePolicyRecordInitProductMapping.get(string);
            if (salePolicyRecordProduct == null) {
                log.warn("\u91cd\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u5386\u53f2\u4e0a\u4e0b\u6587\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684salePolicyRecordProduct\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u7684\u6d41\u6c34\u8bb0\u5f55!!");
                return null;
            }
            SalePolicyConProduct defaultPolicyConProduct = new SalePolicyConProduct();
            defaultPolicyConProduct.setBillItemCode(salePolicyRecordProduct.getBillItemCode());
            defaultPolicyConProduct.setProductCode(salePolicyRecordProduct.getProductCode());
            defaultPolicyConProduct.setProductName(salePolicyRecordProduct.getProductName());
            defaultPolicyConProduct.setQuantity(new BigDecimal(salePolicyRecordProduct.getInitNumbers()));
            SalePolicyRecordProductSelectedPolicy currentSalePolicyRecordProductSelectedPolicy = null;
            currentSalePolicyRecordProductSelectedPolicy = (SalePolicyRecordProductSelectedPolicy)((Object)salePolicyRecordProductSelectedPolicyMapping.get(string));
            if (currentSalePolicyRecordProductSelectedPolicy != null) {
                String selectedPolicyCodes = currentSalePolicyRecordProductSelectedPolicy.getSelectedPolicyCodes();
                defaultPolicyConProduct.setSelectedPolicyCodes(StringUtils.split((String)selectedPolicyCodes, (String)","));
            } else {
                defaultPolicyConProduct.setSelectedPolicyCodes(null);
            }
            defaultPolicyConProduct.setSubtotalAmount(salePolicyRecordProduct.getLastSubtotal());
            defaultPolicyConProduct.setUnitPrice(salePolicyRecordProduct.getLastPrices());
            initPolicyProducts.add(defaultPolicyConProduct);
        }
        String salePolicyCodes = historySalePolicyRecord.getSalePolicyCodes();
        if (StringUtils.isBlank((CharSequence)salePolicyCodes)) {
            log.warn("\u91cd\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u5386\u53f2\u4e0a\u4e0b\u6587\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684salePolicyCodes\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u7684\u6d41\u6c34\u8bb0\u5f55!!");
            return null;
        }
        String[] initSalePolicyCodeArray = StringUtils.split((String)salePolicyCodes, (String)",");
        LinkedHashSet initSalePolicys = Sets.newLinkedHashSet();
        for (String initSalePolicyCode : initSalePolicyCodeArray) {
            SalePolicyVo initSalePolicy = this.salePolicyVoService.findDetailsByCode(initSalePolicyCode);
            if (initSalePolicy == null) {
                log.warn("\u91cd\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u5386\u53f2\u4e0a\u4e0b\u6587\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684initSalePolicyCode\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u7684\u6d41\u6c34\u8bb0\u5f55(\u5f88\u53ef\u80fd\u662f\u6570\u636e\u9519\u8bef)!!");
                return null;
            }
            initSalePolicys.add(initSalePolicy);
        }
        Map<String, SalePolicyVo> map = initSalePolicys.stream().collect(Collectors.toMap(SalePolicyVo::getSalePolicyCode, item -> item));
        BigDecimal initTotalAmount = historySalePolicyRecord.getInitTotalAmount();
        Integer initTotalNumber = historySalePolicyRecord.getInitTotalNumber();
        boolean kneading = historySalePolicyRecord.getKneading();
        DefaultPolicyExecuteContext policyExecuteContext = new DefaultPolicyExecuteContext(initPolicyProducts, initSalePolicys, initTotalAmount, initTotalNumber, tenantCode, customerCode, kneading, true, relevanceCode);
        Set<SalePolicyRecordExcludePolicy> salePolicyRecordExcludePolicys = historySalePolicyRecord.getSalePolicyRecordExcludePolicys();
        if (!CollectionUtils.isEmpty(salePolicyRecordExcludePolicys)) {
            for (SalePolicyRecordExcludePolicy salePolicyRecordExcludePolicy : salePolicyRecordExcludePolicys) {
                String salePolicyCode = salePolicyRecordExcludePolicy.getPolicyCode();
                String excludedMsg = salePolicyRecordExcludePolicy.getExcludedMsg();
                SalePolicyVo currentSalePolicyVo = map.get(salePolicyCode);
                if (currentSalePolicyVo.getWholePolicy() == null || StringUtils.isBlank((CharSequence)excludedMsg)) {
                    log.warn("\u91cd\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u5386\u53f2\u4e0a\u4e0b\u6587\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684salePolicyCode/excludedMsg\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u7684\u6d41\u6c34\u8bb0\u5f55!!");
                    return null;
                }
                policyExecuteContext.addExcludedPolicy(currentSalePolicyVo, excludedMsg);
            }
        }
        Map<String, List<SalePolicyRecordProduct>> salePolicyRecordProductGroupNoSortedMapping = salePolicyRecordProducts.stream().collect(Collectors.groupingBy(SalePolicyRecordProduct::getProductCode));
        LinkedHashMap salePolicyRecordProductGroupMapping = Maps.newLinkedHashMap();
        for (String productCode : salePolicyRecordProductGroupNoSortedMapping.keySet()) {
            List<SalePolicyRecordProduct> salePolicyRecordProductNoSorts = salePolicyRecordProductGroupNoSortedMapping.get(productCode);
            List salePolicyRecordProductSorts = salePolicyRecordProductNoSorts.stream().sorted((source, target) -> source.getSorted() - target.getSorted()).collect(Collectors.toList());
            salePolicyRecordProductGroupMapping.put(productCode, salePolicyRecordProductSorts);
        }
        Set<SalePolicyRecordStepPolicy> salePolicyRecordStepPolicySets = historySalePolicyRecord.getSalePolicyRecordStepPolicys();
        List salePolicyRecordStepPolicys = salePolicyRecordStepPolicySets.stream().filter(item -> !StringUtils.equals((CharSequence)item.getStepType(), (CharSequence)StepType.INIT.toString())).sorted((source, target) -> source.getSorted() - target.getSorted()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(salePolicyRecordStepPolicys)) {
            log.warn("\u91cd\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u5386\u53f2\u4e0a\u4e0b\u6587\u65f6\uff0c\u672a\u53d1\u73b0\u6b63\u786e\u7684\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f!!");
            return null;
        }
        for (SalePolicyRecordStepPolicy salePolicyRecordStepPolicy : salePolicyRecordStepPolicys) {
            String salePolicyCode = salePolicyRecordStepPolicy.getSalePolicyCode();
            String executeCode = salePolicyRecordStepPolicy.getExecuteCode();
            LinkedHashSet productStepResults = Sets.newLinkedHashSet();
            for (String productCode : salePolicyRecordProductGroupMapping.keySet()) {
                List salePolicyRecordProductSteps = (List)salePolicyRecordProductGroupMapping.get(productCode);
                SalePolicyRecordProduct nowSalePolicyRecordProduct = salePolicyRecordProductSteps.stream().filter(item -> StringUtils.equals((CharSequence)executeCode, (CharSequence)item.getExecuteCode()) && StringUtils.equals((CharSequence)salePolicyCode, (CharSequence)item.getSalePolicyCode())).findFirst().orElse(null);
                if (nowSalePolicyRecordProduct == null) continue;
                int index = salePolicyRecordProductSteps.indexOf((Object)nowSalePolicyRecordProduct);
                ProductPolicyStepResult productPolicyStepResult = new ProductPolicyStepResult();
                productPolicyStepResult.setProductCode(productCode);
                productPolicyStepResult.setSalePolicyCode(salePolicyCode);
                productPolicyStepResult.setExecuteCode(executeCode);
                StepType stepType = StepType.valueOf((String)nowSalePolicyRecordProduct.getStepType());
                if (stepType == null) {
                    log.warn("\u91cd\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u5386\u53f2\u4e0a\u4e0b\u6587\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684stepType\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u7684\u6d41\u6c34\u8bb0\u5f55!!");
                    return null;
                }
                productPolicyStepResult.setStepType(stepType);
                productPolicyStepResult.setInitNumbers(nowSalePolicyRecordProduct.getInitNumbers());
                productPolicyStepResult.setInitPrices(nowSalePolicyRecordProduct.getInitPrices());
                productPolicyStepResult.setInitSubtotal(nowSalePolicyRecordProduct.getInitSubtotal());
                SalePolicyRecordProduct previousSalePolicyRecordProduct = (SalePolicyRecordProduct)((Object)salePolicyRecordProductSteps.get(index - 1));
                Set<SalePolicyRecordGift> previousSalePolicyRecordGifts = previousSalePolicyRecordProduct.getSalePolicyRecordGifts();
                ArrayList preGifts = Lists.newArrayList();
                if (!CollectionUtils.isEmpty(previousSalePolicyRecordGifts)) {
                    for (SalePolicyRecordGift previousSalePolicyRecordGift : previousSalePolicyRecordGifts) {
                        GiftResultInfo preGift = new GiftResultInfo();
                        preGift.setProductCode(previousSalePolicyRecordGift.getGiftCode());
                        preGift.setProductName(previousSalePolicyRecordGift.getGiftName());
                        preGift.setQuantity(previousSalePolicyRecordGift.getQuantity());
                        preGift.setSubtotalAmount(previousSalePolicyRecordGift.getSubtotalAmount());
                        preGifts.add(preGift);
                    }
                }
                productPolicyStepResult.setPreGifts((List)preGifts);
                productPolicyStepResult.setPrePrices(previousSalePolicyRecordProduct.getLastPrices());
                productPolicyStepResult.setPreSubtotal(previousSalePolicyRecordProduct.getLastSubtotal());
                productPolicyStepResult.setPreSurplusTotalAmount(previousSalePolicyRecordProduct.getLastSurplusTotalAmount());
                productPolicyStepResult.setPreSurplusTotalNumber(previousSalePolicyRecordProduct.getLastSurplusTotalNumber());
                Set<SalePolicyRecordGift> lastSalePolicyRecordGifts = nowSalePolicyRecordProduct.getSalePolicyRecordGifts();
                ArrayList lastGifts = Lists.newArrayList();
                if (!CollectionUtils.isEmpty(lastSalePolicyRecordGifts)) {
                    for (SalePolicyRecordGift lastSalePolicyRecordGift : lastSalePolicyRecordGifts) {
                        GiftResultInfo lastGift = new GiftResultInfo();
                        lastGift.setProductCode(lastSalePolicyRecordGift.getGiftCode());
                        lastGift.setProductName(lastSalePolicyRecordGift.getGiftName());
                        lastGift.setQuantity(lastSalePolicyRecordGift.getQuantity());
                        lastGift.setSubtotalAmount(lastSalePolicyRecordGift.getSubtotalAmount());
                        lastGifts.add(lastGift);
                    }
                }
                productPolicyStepResult.setLastGifts((List)lastGifts);
                productPolicyStepResult.setLastPrices(nowSalePolicyRecordProduct.getLastPrices());
                productPolicyStepResult.setLastSubtotal(nowSalePolicyRecordProduct.getLastSubtotal());
                productPolicyStepResult.setLastSurplusTotalAmount(nowSalePolicyRecordProduct.getLastSurplusTotalAmount());
                productPolicyStepResult.setLastSurplusTotalNumber(nowSalePolicyRecordProduct.getLastSurplusTotalNumber());
                productStepResults.add(productPolicyStepResult);
            }
            if (CollectionUtils.isEmpty((Collection)productStepResults)) continue;
            SalePolicyVo currentSalePolicyVo = map.get(salePolicyCode);
            if (currentSalePolicyVo.getWholePolicy() == null) {
                log.warn("\u91cd\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u5386\u53f2\u4e0a\u4e0b\u6587\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684wholePolicy\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u7684\u6d41\u6c34\u8bb0\u5f55!!");
                return null;
            }
            if (currentSalePolicyVo.getWholePolicy().booleanValue()) {
                policyExecuteContext.addNewMathedPolicy(currentSalePolicyVo);
            } else {
                String[] matchedProductCodes = (String[])productStepResults.stream().map(ProductPolicyStepResult::getProductCode).distinct().toArray(String[]::new);
                policyExecuteContext.addNewMathedPolicy(currentSalePolicyVo, matchedProductCodes);
            }
            policyExecuteContext.addPolicyStepResult(productStepResults);
        }
        return policyExecuteContext;
    }
}

