/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.service.internal;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutorLadderVar;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyExecutorLadderVarRepository;
import com.biz.crm.dms.business.policy.local.service.SalePolicyExecutorLadderVarService;
import com.biz.crm.dms.business.policy.local.utils.AnalyzeExpressionUtils;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SalePolicyExecutorLadderVarServiceImpl
implements SalePolicyExecutorLadderVarService {
    @Autowired(required=false)
    private SalePolicyExecutorLadderVarRepository salePolicyExecutorLadderVarRepository;

    @Override
    @Transactional
    public void createBatch(Set<SalePolicyExecutorLadderVar> salePolicyExecutorLadderVars, String salePolicyExecutorLadderId, String expression) {
        Validate.isTrue((!CollectionUtils.isEmpty(salePolicyExecutorLadderVars) ? 1 : 0) != 0, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u53d8\u91cf\u65f6\uff0c\u521b\u5efa\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)salePolicyExecutorLadderId, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u53d8\u91cf\u65f6, \u9636\u68afid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)expression, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u53d8\u91cf\u65f6, \u672a\u83b7\u53d6\u5230\u7cfb\u7edf\u914d\u7f6e\u7684\u4f18\u60e0\u6267\u884c\u7b56\u7565\u8868\u8fbe\u5f0f\uff01", (Object[])new Object[0]);
        SalePolicyExecutorLadderVarServiceImpl.validateVars(salePolicyExecutorLadderVars, salePolicyExecutorLadderId, expression);
        this.salePolicyExecutorLadderVarRepository.saveBatch(salePolicyExecutorLadderVars);
    }

    private static void validateVars(Set<SalePolicyExecutorLadderVar> salePolicyExecutorLadderVars, String salePolicyExecutorLadderId, String expression) {
        Map<Integer, String> mustVarNameMapping = AnalyzeExpressionUtils.analyzeLadderExpressionMapping(expression);
        if (CollectionUtils.isEmpty(mustVarNameMapping)) {
            Validate.isTrue((boolean)CollectionUtils.isEmpty(salePolicyExecutorLadderVars), (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u53d8\u91cf\u65f6\uff0c\u53d1\u73b0\u4f18\u60e0\u6267\u884c\u7b56\u7565\u65e0\u9700\u4f20\u9012\u4efb\u4f55\u53d8\u91cf\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            return;
        }
        LinkedHashSet mustVarNames = Sets.newLinkedHashSet(mustVarNameMapping.values());
        Set variableNames = salePolicyExecutorLadderVars.stream().map(SalePolicyExecutorLadderVar::getVariableName).filter(item -> StringUtils.isNotBlank((CharSequence)item)).collect(Collectors.toSet());
        Validate.isTrue((mustVarNameMapping.size() == variableNames.size() ? 1 : 0) != 0, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u53d8\u91cf\u65f6\uff0c\u4f20\u8fc7\u6765\u7684\u53d8\u91cf\u540d\uff08%s\uff09\u548c\u7cfb\u7edf\u8868\u8fbe\u5f0f\u7684\u53d8\u91cf\u540d\uff08%s\uff09\u4e0d\u5339\u914d", (Object[])new Object[]{variableNames, mustVarNames});
        Sets.SetView differenceSet = Sets.difference(variableNames, (Set)mustVarNames);
        Validate.isTrue((boolean)differenceSet.isEmpty(), (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u53d8\u91cf\u65f6\uff0c\u53d1\u73b0\u9700\u8981\u586b\u5199\u7684\u53d8\u91cf\u4fe1\u606f(%s)\uff0c\u5e76\u6ca1\u6709\u586b\u5199\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{StringUtils.join((Object[])mustVarNames.toArray(new String[0]), (String)",")});
        String pattern = "^[A-Za-z]{1}[A-Za-z0-9]*$";
        long distinctCount = salePolicyExecutorLadderVars.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getVariableName())).map(SalePolicyExecutorLadderVar::getVariableName).distinct().count();
        Validate.isTrue((distinctCount == (long)salePolicyExecutorLadderVars.size() ? 1 : 0) != 0, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u9636\u68af\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u53d8\u91cf\u540d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (SalePolicyExecutorLadderVar salePolicyExecutorLadderVar : salePolicyExecutorLadderVars) {
            salePolicyExecutorLadderVar.setExecutorLadderId(salePolicyExecutorLadderId);
            salePolicyExecutorLadderVar.setId(null);
            String variableName = salePolicyExecutorLadderVar.getVariableName();
            Validate.notBlank((CharSequence)variableName, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u9636\u68af\u4e2d\u5b58\u5728\u9519\u8bef\u7684\u53d8\u91cf\u540d\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.matchesPattern((CharSequence)variableName, (String)pattern, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u65f6\uff0c\u53d8\u91cf\u540d\u4fe1\u606f\u53ea\u80fd\u662f\u5b57\u6bcd\u6216\u8005\u6570\u5b57\uff0c\u4e14\u9996\u5b57\u6bcd\u5fc5\u987b\u662f\u5b57\u6bcd(%s)\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{variableName});
            Integer variableType = salePolicyExecutorLadderVar.getVariableType();
            Validate.inclusiveBetween((long)1L, (long)4L, (long)variableType.intValue(), (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u65f6\uff0c\u53d8\u91cf\u7c7b\u578b\u53ea\u80fd\u662f1\uff1aboolean\u30012\uff1a\u5c0f\u6570\uff1b3\uff1a\u6574\u6570\uff1b4\uff1a\u5b57\u7b26\u4e32\uff0c\u8bf7\u68c0\u67e5!!");
            String variableValue = salePolicyExecutorLadderVar.getVariableValue();
            Validate.notNull((Object)variableValue, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u65f6\uff0c\u53d8\u91cf\u503c\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
    }
}

