/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.service.internal;

import com.biz.crm.dms.business.policy.local.entity.SalePolicy;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutor;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutorLadder;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyExecutorRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyRepository;
import com.biz.crm.dms.business.policy.local.service.SalePolicyExecutorLadderService;
import com.biz.crm.dms.business.policy.local.service.SalePolicyExecutorService;
import com.biz.crm.dms.business.policy.sdk.register.SalePolicyTempleteRegister;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCycleRuleStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SalePolicyExecutorServiceImpl
implements SalePolicyExecutorService {
    @Autowired(required=false)
    private SalePolicyExecutorRepository salePolicyExecutorRepository;
    @Autowired(required=false)
    private SalePolicyExecutorLadderService salePolicyExecutorLadderService;
    @Autowired(required=false)
    private SalePolicyRepository salePolicyRepository;
    @Autowired(required=false)
    private List<SalePolicyTempleteRegister> salePolicyTempleteRegisters;
    @Autowired(required=false)
    private ApplicationContext applicationContext;

    @Override
    @Transactional
    public void create(SalePolicyExecutor salePolicyExecutor) {
        Validate.notNull((Object)((Object)salePolicyExecutor), (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u65f6\uff0c\u6267\u884c\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String salePolicyCode = salePolicyExecutor.getSalePolicyCode();
        Validate.notBlank((CharSequence)salePolicyCode, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u65f6\uff0c\u9700\u8981\u6307\u5b9a\u4f18\u60e0\u653f\u7b56\u4e1a\u52a1\u7f16\u53f7", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        SalePolicy currentSalePolicy = this.salePolicyRepository.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode);
        Validate.notNull((Object)((Object)currentSalePolicy), (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u57fa\u672c\u4fe1\u606f(%s)\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{salePolicyCode});
        String type = currentSalePolicy.getType();
        salePolicyExecutor.setId(null);
        if (StringUtils.isBlank((CharSequence)salePolicyExecutor.getTenantCode())) {
            salePolicyExecutor.setTenantCode(tenantCode);
        }
        String executorCode = salePolicyExecutor.getExecutorCode();
        Validate.notBlank((CharSequence)executorCode, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6267\u884c\u7b56\u7565\u4e1a\u52a1\u7f16\u7801!!", (Object[])new Object[0]);
        SalePolicyExecutor exsitSalePolicyExecutor = this.salePolicyExecutorRepository.findBySalePolicyCodeAndExecutorCode(salePolicyCode, executorCode, tenantCode);
        Validate.isTrue((exsitSalePolicyExecutor == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0\u8be5\u6307\u5b9a\u7b56\u7565\u4e1a\u52a1\u7f16\u7801\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539!!", (Object[])new Object[0]);
        String executeStrategyCode = salePolicyExecutor.getExecuteStrategyCode();
        Validate.notBlank((CharSequence)executeStrategyCode, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u6267\u884c\u7b56\u7565\u4e1a\u52a1\u7f16\u53f7\uff0c\u8fd9\u4e2a\u7f16\u53f7\u6765\u81ea\u4e8e\u67d0\u4e2a\u5177\u4f53\u7684\u6267\u884c\u7b56\u7565\uff08SalePolicyExecuteStrategy\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyTempleteRegister salePolicyTempleteRegister = this.findSalePolicyTempleteRegister(type);
        Validate.notNull((Object)salePolicyTempleteRegister, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u65f6\uff0c\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u6ce8\u518c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Collection executeStrategyClasses = salePolicyTempleteRegister.getExecuteStrategyClasses();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)executeStrategyClasses) ? 1 : 0) != 0, (String)"\u5f53\u524d\u4f18\u60e0\u653f\u7b56\u6ce8\u518c\u5668\uff08%s\uff09\uff0c\u6ca1\u6709\u8bbe\u5b9a\u4efb\u4f55\u6267\u884c\u7b56\u7565\uff08SalePolicyExecuteStrategy\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{type});
        boolean matchedExecuteStrategyCode = false;
        String expression = "";
        SalePolicyExecuteStrategy salePolicyExecuteStrategy = null;
        for (Class executeStrategyClass : executeStrategyClasses) {
            try {
                salePolicyExecuteStrategy = (SalePolicyExecuteStrategy)this.applicationContext.getBean(executeStrategyClass);
                String targetExecuteStrategyCode = salePolicyExecuteStrategy.getExecuteStrategyCode();
                if (!StringUtils.equals((CharSequence)executeStrategyCode, (CharSequence)targetExecuteStrategyCode)) continue;
                matchedExecuteStrategyCode = true;
                expression = salePolicyExecuteStrategy.getExpression();
                break;
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        Validate.isTrue((boolean)matchedExecuteStrategyCode, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u65f6\uff0c\u5728\u5339\u914d\u7684\u6ce8\u518c\u5668\u4e2d\uff0c\u5e76\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u6267\u884c\u7b56\u7565\uff08%s\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{executeStrategyCode});
        String cycleRuleCode = salePolicyExecutor.getCycleRuleCode();
        Validate.notNull((Object)cycleRuleCode, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u6267\u884c\u4fe1\u606f\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u9636\u68af\u89c4\u5219\u4fe1\u606f\uff08cycleRuleCode\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Collection cycleRuleStrategyClasses = salePolicyExecuteStrategy.getCycleRuleStrategyClasses();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)cycleRuleStrategyClasses) ? 1 : 0) != 0, (String)"\u53d1\u73b0\u7c7b\u578b(%s)\u4e3a\u7684\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u6ce8\u518c\uff0c\u672a\u8bbe\u5b9a\u4efb\u4f55\u4e00\u4e2a\u201c\u9636\u68af\u5faa\u73af\u89c4\u5219\u201d\uff08SalePolicyCycleRuleStrategy\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{type});
        boolean matchedSalePolicyCycleRuleStrategy = false;
        for (Class cycleRuleStrategyClass : cycleRuleStrategyClasses) {
            SalePolicyCycleRuleStrategy salePolicyCycleRuleStrategy = (SalePolicyCycleRuleStrategy)this.applicationContext.getBean(cycleRuleStrategyClass);
            if (!StringUtils.equals((CharSequence)salePolicyCycleRuleStrategy.getCycleRuleCode(), (CharSequence)cycleRuleCode)) continue;
            matchedSalePolicyCycleRuleStrategy = true;
        }
        Validate.isTrue((boolean)matchedSalePolicyCycleRuleStrategy, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u201c\u9636\u68af\u5faa\u73af\u89c4\u5219\u201d\uff08%s\uff09 , \u8bf7\u68c0\u67e5!!", (Object[])new Object[]{cycleRuleCode});
        this.salePolicyExecutorRepository.save((Object)salePolicyExecutor);
        Set<SalePolicyExecutorLadder> salePolicyExecutorLadders = salePolicyExecutor.getSalePolicyExecutorLadders();
        this.salePolicyExecutorLadderService.createBatch(salePolicyExecutorLadders, executeStrategyCode, salePolicyCode, salePolicyExecutor.getId(), expression);
    }

    private SalePolicyTempleteRegister findSalePolicyTempleteRegister(String type) {
        Validate.notBlank((CharSequence)"\u9519\u8bef\u7684\u4f18\u60e0\u653f\u7b56\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u503c");
        Validate.isTrue((!CollectionUtils.isEmpty(this.salePolicyTempleteRegisters) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684SalePolicyTempleteRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyTempleteRegister matchedSalePolicyTempleteRegister = null;
        for (SalePolicyTempleteRegister item : this.salePolicyTempleteRegisters) {
            if (!StringUtils.equals((CharSequence)type, (CharSequence)item.getType())) continue;
            matchedSalePolicyTempleteRegister = item;
            break;
        }
        Validate.notNull(matchedSalePolicyTempleteRegister, (String)"\u672a\u5339\u914d\u4efb\u4f55SalePolicyTempleteRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return matchedSalePolicyTempleteRegister;
    }

    @Override
    public List<SalePolicyExecutor> findBySalePolicyCodeAndTenantCode(String salePolicyCode, String tenantCode, String executeStrategyCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{salePolicyCode, tenantCode, executeStrategyCode})) {
            return null;
        }
        return this.salePolicyExecutorRepository.findBySalePolicyCode(salePolicyCode, tenantCode, executeStrategyCode);
    }
}

