/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.service.internal;

import com.biz.crm.dms.business.policy.local.entity.SalePolicy;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyProduct;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyExecutorRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyProductRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyRepository;
import com.biz.crm.dms.business.policy.local.service.SalePolicyProductService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SalePolicyProductServiceImpl
implements SalePolicyProductService {
    @Autowired(required=false)
    private SalePolicyRepository salePolicyRepository;
    @Autowired(required=false)
    private SalePolicyProductRepository salePolicyProductRepository;
    @Autowired(required=false)
    private SalePolicyExecutorRepository salePolicyExecutorRepository;

    @Override
    @Transactional
    public void createBatch(Set<SalePolicyProduct> salePolicyProducts) {
        Validate.isTrue((!CollectionUtils.isEmpty(salePolicyProducts) ? 1 : 0) != 0, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u5546\u54c1\u672c\u54c1\u4fe1\u606f\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u4f20\u5165\u4e00\u6761\u672c\u54c1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
        for (SalePolicyProduct salePolicyProduct : salePolicyProducts) {
            this.createHandle(salePolicyProduct);
        }
    }

    private void createHandle(SalePolicyProduct salePolicyProduct) {
        String tenantCode = TenantUtils.getTenantCode();
        salePolicyProduct.setTenantCode(tenantCode);
        String salePolicyCode = salePolicyProduct.getSalePolicyCode();
        Validate.notBlank((CharSequence)salePolicyCode, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u672c\u54c1\u5546\u54c1\u65f6\uff0c\u53d1\u73b0\u672a\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5e76\u5b8c\u5584!!", (Object[])new Object[0]);
        salePolicyProduct.setId(null);
        SalePolicy exsitSalePolicy = this.salePolicyRepository.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode);
        Validate.notNull((Object)((Object)exsitSalePolicy), (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u672c\u54c1\u5546\u54c1\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String executorCode = salePolicyProduct.getExecutorCode();
        Validate.notBlank((CharSequence)executorCode, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u672c\u54c1\u5546\u54c1\u65f6\uff0c\u81f3\u5c11\u4e00\u6761\u672c\u54c1\u5546\u54c1\u7684\u6267\u884c\u5668\u4e1a\u52a1\u7f16\u7801\u6ca1\u6709\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Integer exsitSalePolicyExecutorCount = this.salePolicyExecutorRepository.countBySalePolicyCodeAndExecutorCode(salePolicyCode, executorCode, tenantCode);
        Validate.isTrue((exsitSalePolicyExecutorCount == 1 ? 1 : 0) != 0, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u672c\u54c1\u5546\u54c1\u65f6\uff0c\u81f3\u5c11\u6709\u4e00\u6761\u672c\u54c1\u5546\u54c1\u7684\u5173\u8054\u7684\u6267\u884c\u7b56\u7565\u6ca1\u6709\u88ab\u627e\u5230\uff08%s\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{executorCode});
        String productCode = salePolicyProduct.getProductCode();
        Validate.notBlank((CharSequence)productCode, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u672c\u54c1\u5546\u54c1\u65f6\uff0c\u81f3\u5c11\u6709\u4e00\u6761\u672c\u54c1\u5546\u54c1\u7684\u4e1a\u52a1\u7f16\u7801\u6ca1\u6709\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyProduct exsitSalePolicyProduct = this.salePolicyProductRepository.findBySalePolicyCodeAndProductCodeAndTenantCode(salePolicyCode, productCode, tenantCode);
        Validate.isTrue((exsitSalePolicyProduct == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u672c\u54c1\u5546\u54c1\u65f6\uff0c\u53d1\u73b0\u6307\u5b9a\u7684\u672c\u54c1\u5546\u54c1\u4fe1\u606f(%s)\u5df2\u7ecf\u88ab\u6dfb\u52a0\u5230\u8fd9\u6761\u4f18\u60e0\u653f\u7b56\u4e2d\uff0c\u4e0d\u80fd\u6dfb\u52a0\u91cd\u590d\u7684\u672c\u54c1\u5546\u54c1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{productCode});
        String productName = salePolicyProduct.getProductName();
        Validate.notBlank((CharSequence)productName, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u672c\u54c1\u5546\u54c1\u65f6\uff0c\u81f3\u5c11\u6709\u4e00\u6761\u672c\u54c1\u5546\u54c1\u7684\u4e2d\u6587\u540d\u79f0\u6ca1\u6709\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.salePolicyProductRepository.save((Object)salePolicyProduct);
    }

    @Override
    public List<SalePolicyProduct> findBySalePolicyCode(String salePolicyCode, String tenantCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{salePolicyCode, tenantCode})) {
            return null;
        }
        return this.salePolicyProductRepository.findBySalePolicyCode(salePolicyCode, tenantCode);
    }
}

