/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.service.internal;

import com.biz.crm.dms.business.policy.local.entity.SalePolicy;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyScopeInfo;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyScopeInfoRepository;
import com.biz.crm.dms.business.policy.local.service.SalePolicyScopeInfoService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SalePolicyScopeInfoServiceImpl
implements SalePolicyScopeInfoService {
    @Autowired(required=false)
    private SalePolicyRepository salePolicyRepository;
    @Autowired(required=false)
    private SalePolicyScopeInfoRepository salePolicyScopeInfoRepository;

    @Override
    @Transactional
    public void createBatch(Set<SalePolicyScopeInfo> salePolicyScopeInfos) {
        Validate.isTrue((!CollectionUtils.isEmpty(salePolicyScopeInfos) ? 1 : 0) != 0, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u9002\u7528\u8303\u56f4\u4fe1\u606f\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u4f20\u5165\u4e00\u6761\u9002\u7528\u8303\u56f4\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
        long codeCount = salePolicyScopeInfos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCode())).map(SalePolicyScopeInfo::getCode).distinct().count();
        Validate.isTrue((codeCount == (long)salePolicyScopeInfos.size() ? 1 : 0) != 0, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u9002\u7528\u8303\u56f4\u4fe1\u606f\u65f6\uff0c\u81f3\u5c11\u6709\u4e24\u7ec4\u8303\u56f4\u4fe1\u606f\u7684\u4e1a\u52a1\u7f16\u53f7\u91cd\u590d\u6216\u8005\u6ca1\u6709\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (SalePolicyScopeInfo salePolicyScopeInfo : salePolicyScopeInfos) {
            this.createHandle(salePolicyScopeInfo);
        }
    }

    @Override
    public List<SalePolicyScopeInfo> findByTenantCodeAndSalePolicyCodeAndCustomerScopeType(String tenantCode, String salePolicyCode, String customerScopeType) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, salePolicyCode, customerScopeType})) {
            return null;
        }
        return this.salePolicyScopeInfoRepository.findByTenantCodeAndSalePolicyCodeAndCustomerScopeType(tenantCode, salePolicyCode, customerScopeType);
    }

    private void createHandle(SalePolicyScopeInfo salePolicyScopeInfo) {
        String tenantCode = TenantUtils.getTenantCode();
        salePolicyScopeInfo.setTenantCode(tenantCode);
        salePolicyScopeInfo.setId(null);
        String salePolicyCode = salePolicyScopeInfo.getSalePolicyCode();
        SalePolicy exsitSalePolicy = this.salePolicyRepository.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode);
        Validate.notNull((Object)((Object)exsitSalePolicy), (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u9002\u7528\u8303\u56f4\u4fe1\u606f\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String code = salePolicyScopeInfo.getCode();
        Validate.notBlank((CharSequence)code, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u9002\u7528\u8303\u56f4\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        String name = salePolicyScopeInfo.getName();
        Validate.notBlank((CharSequence)name, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u9002\u7528\u8303\u56f4\u4fe1\u606f\u65f6\uff0c\u4e1a\u52a1\u540d\u79f0\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        String customerScopeType = salePolicyScopeInfo.getCustomerScopeType();
        Validate.notBlank((CharSequence)customerScopeType, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u9002\u7528\u8303\u56f4\u4fe1\u606f\u65f6\uff0c\u8303\u56f4\u7c7b\u578b\uff08customerScopeType\uff09\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        String selectionMethod = salePolicyScopeInfo.getSelectionMethod();
        Validate.notBlank((CharSequence)selectionMethod, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u9002\u7528\u8303\u56f4\u4fe1\u606f\u65f6\uff0c\u9009\u5b9a\u65b9\u5f0f\uff08selectionMethod\uff09\u4fe1\u606f\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        this.salePolicyScopeInfoRepository.save((Object)salePolicyScopeInfo);
    }
}

