/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.policy.local.entity.SalePolicy;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyTemplete;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyTempleteExecuteStrategy;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyTempleteExecuteStrategyRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyTempleteRepository;
import com.biz.crm.dms.business.policy.local.service.SalePolicyTempleteVoService;
import com.biz.crm.dms.business.policy.sdk.characteristic.CharacteristicStrategy;
import com.biz.crm.dms.business.policy.sdk.dto.SalePolicyTempleteLogDto;
import com.biz.crm.dms.business.policy.sdk.dto.SalePolicyTempletePageDto;
import com.biz.crm.dms.business.policy.sdk.enums.ProductSelectionMethod;
import com.biz.crm.dms.business.policy.sdk.event.SalePolicyTempleteLogEventListener;
import com.biz.crm.dms.business.policy.sdk.register.SalePolicyTempleteRegister;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractCharacteristicInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyLimitInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyTempleteExecuteStrategyVo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyTempleteVo;
import com.bizunited.nebula.common.service.CopyObjectCallback;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SalePolicyTempleteVoServiceImpl
implements SalePolicyTempleteVoService,
CopyObjectCallback<SalePolicyTemplete, SalePolicyTempleteVo> {
    @Autowired(required=false)
    private SalePolicyTempleteRepository salePolicyTempleteRepository;
    @Autowired(required=false)
    private List<SalePolicyTempleteRegister> salePolicyTempleteRegisters;
    @Autowired(required=false)
    private SalePolicyTempleteExecuteStrategyRepository salePolicyTempleteExecuteStrategyRepository;
    @Autowired(required=false)
    private SalePolicyRepository salePolicyRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    private static final Logger LOGGER = LoggerFactory.getLogger(SalePolicyTempleteVoServiceImpl.class);

    @Override
    @Transactional
    public SalePolicyTempleteVo create(SalePolicyTempleteVo salePolicyTemplete) {
        SalePolicyTemplete existTemplete;
        Validate.notNull((Object)salePolicyTemplete, (String)"\u6dfb\u52a0\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u65f6\uff0c\u9700\u8981\u786e\u8ba4\u4f20\u5165\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u7c7b\u5bf9\u8c61!!", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        salePolicyTemplete.setTenantCode(tenantCode);
        salePolicyTemplete.setId(null);
        String type = salePolicyTemplete.getType();
        Validate.notBlank((CharSequence)type, (String)"\u6dfb\u52a0\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u65f6\uff0c\u6a21\u677f\u7c7b\u578b\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String templeteCode = salePolicyTemplete.getTempleteCode();
        if (StringUtils.isBlank((CharSequence)templeteCode)) {
            templeteCode = StringUtils.join((Object[])new String[]{tenantCode, new SimpleDateFormat("yyyyMMddHHmmssS").format(new Date())});
            salePolicyTemplete.setTempleteCode(templeteCode);
        }
        Validate.isTrue(((existTemplete = this.salePolicyTempleteRepository.findByTempleteCode(templeteCode, tenantCode)) == null ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u65f6\uff0c\u53d1\u73b0\u6a21\u677f\u4e1a\u52a1\u7f16\u53f7\u5df2\u7ecf\u4f7f\u7528\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.validate(salePolicyTemplete, "\u6dfb\u52a0\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u65f6");
        salePolicyTemplete.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        SalePolicyTemplete salePolicyTempleteEntity = (SalePolicyTemplete)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)salePolicyTemplete, SalePolicyTemplete.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        salePolicyTempleteEntity.setBindingCharacteristicStrategyCodes(StringUtils.join((Iterable)salePolicyTemplete.getBindingCharacteristicStrategyCodes(), (String)","));
        salePolicyTempleteEntity.setBindingProductSelectionMethods(StringUtils.join((Iterable)salePolicyTemplete.getBindingProductSelectionMethods(), (String)","));
        salePolicyTempleteEntity.setBindingLimitStrategyCodes(StringUtils.join((Iterable)salePolicyTemplete.getBindingLimitStrategyCodes(), (String)","));
        salePolicyTempleteEntity.setBindingScopeTypes(StringUtils.join((Iterable)salePolicyTemplete.getBindingScopeTypes(), (String)","));
        this.salePolicyTempleteRepository.save((Object)salePolicyTempleteEntity);
        salePolicyTemplete.setId(salePolicyTempleteEntity.getId());
        Set salePolicyTempleteExecuteStrategys = salePolicyTemplete.getBindingExecuteStraties();
        for (SalePolicyTempleteExecuteStrategyVo salePolicyTempleteExecuteStrategyVo : salePolicyTempleteExecuteStrategys) {
            Set bindingExecuteLadders = salePolicyTempleteExecuteStrategyVo.getBindingExecuteLadders();
            String bindingExecuteStrategyCode = salePolicyTempleteExecuteStrategyVo.getBindingExecuteStrategyCode();
            SalePolicyTempleteExecuteStrategy salePolicyTempleteExecuteStrategy = new SalePolicyTempleteExecuteStrategy();
            salePolicyTempleteExecuteStrategy.setTempleteId(salePolicyTempleteEntity.getId());
            salePolicyTempleteExecuteStrategy.setBindingExecuteStrategyCode(bindingExecuteStrategyCode);
            salePolicyTempleteExecuteStrategy.setBindingExecuteLadders(StringUtils.join((Iterable)bindingExecuteLadders, (String)","));
            this.salePolicyTempleteExecuteStrategyRepository.save((Object)salePolicyTempleteExecuteStrategy);
            salePolicyTempleteExecuteStrategyVo.setId(salePolicyTempleteExecuteStrategy.getId());
        }
        this.recordLogOnCreate(salePolicyTemplete);
        return salePolicyTemplete;
    }

    private void recordLogOnCreate(SalePolicyTempleteVo salePolicyTemplete) {
        SalePolicyTempleteLogDto logDto = new SalePolicyTempleteLogDto();
        logDto.setOriginal(null);
        logDto.setNewest(salePolicyTemplete);
        SerializableBiConsumer & Serializable onCreate = SalePolicyTempleteLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logDto, SalePolicyTempleteLogEventListener.class, (SerializableBiConsumer)onCreate);
    }

    private void validate(SalePolicyTempleteVo salePolicyTemplete, String onTime) {
        Set bindingScopeTypes;
        Set salePolicyTempleteExecuteStrategys;
        String type = salePolicyTemplete.getType();
        Boolean supportBudget = salePolicyTemplete.getSupportBudget();
        Validate.notNull((Object)supportBudget, (String)(onTime + "\uff0c\u8be5\u4f18\u60e0\u6a21\u677f\u662f\u5426\u652f\u6301\u5173\u8054\u9884\u7b97\uff0c\u5fc5\u987b\u67e5\u8be2\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        SalePolicyTempleteRegister currentSalePolicyTempleteRegister = this.findSalePolicyTempleteRegister(type);
        Validate.notNull((Object)currentSalePolicyTempleteRegister, (String)(onTime + "\uff0c\u672a\u53d1\u73b0\u6b63\u786e\u7684\u4f18\u60e0\u653f\u7b56\u6ce8\u518c\u5668\uff08%s\uff09\uff0c\u8bf7\u68c0\u67e5!"), (Object[])new Object[]{type});
        Set bindingCharacteristicStrategyCodes = salePolicyTemplete.getBindingCharacteristicStrategyCodes();
        if (!CollectionUtils.isEmpty((Collection)bindingCharacteristicStrategyCodes)) {
            for (String characteristicStrategyCode : bindingCharacteristicStrategyCodes) {
                Validate.notNull(this.findCorrectCharacteristicStrategy(currentSalePolicyTempleteRegister, characteristicStrategyCode), (String)(onTime + "\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u7279\u6027\u6267\u884c\u89c4\u5219\u4fe1\u606f\uff08%s\uff09\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[]{characteristicStrategyCode});
            }
        }
        Boolean supportProduct = currentSalePolicyTempleteRegister.supportProduct();
        Validate.notNull((Object)supportProduct, (String)(onTime + "\uff0c\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u6ce8\u518c\u5668(%s)\uff0c\u5e76\u6ca1\u6709\u6307\u5b9asupportProduct()\u65b9\u6cd5\u7684\u8fd4\u56de\u503c\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[]{type});
        Set productSelectionMethods = salePolicyTemplete.getBindingProductSelectionMethods();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)productSelectionMethods) ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5546\u54c1\u9009\u62e9\u65b9\u5f0f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (!supportProduct.booleanValue()) {
            Validate.isTrue((productSelectionMethods.size() == 1 ? 1 : 0) != 0, (String)(onTime + "\uff0c\u5f53\u524d\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u6ce8\u518c\u5668\uff0c\u8bbe\u5b9a\u4e3a\u201c\u4e0d\u652f\u6301\u5546\u54c1\u9009\u62e9\u65b9\u5f0f\u201d\uff0c\u6240\u4ee5\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u7684\u5546\u54c1\u9009\u62e9\u65b9\u5f0f\u53ea\u80fd\u662f\u201cNOSELECT\u201d"), (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)((CharSequence)productSelectionMethods.iterator().next()), (CharSequence)ProductSelectionMethod.NOSELECT.getCode()), (String)"\u5f53\u524d\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u6ce8\u518c\u5668\uff0c\u8bbe\u5b9a\u4e3a\u201c\u4e0d\u652f\u6301\u5546\u54c1\u9009\u62e9\u65b9\u5f0f\u201d\uff0c\u6240\u4ee5\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u7684\u5546\u54c1\u9009\u62e9\u65b9\u5f0f\u53ea\u80fd\u662f\u201cNOSELECT\u201d", (Object[])new Object[0]);
        }
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)(salePolicyTempleteExecuteStrategys = salePolicyTemplete.getBindingExecuteStraties())) ? 1 : 0) != 0, (String)(onTime + "\uff0c\u5f53\u524d\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u6ce8\u518c\u5668\uff0c\u5fc5\u987b\u8bbe\u5b9a\u7ed1\u5b9a\u7684\u653f\u7b56\u6267\u884c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        for (Object salePolicyTempleteExecuteStrategyVo : salePolicyTempleteExecuteStrategys) {
            String executeStrategyCode = salePolicyTempleteExecuteStrategyVo.getBindingExecuteStrategyCode();
            Validate.notNull(this.findCorrectExecuteStrategy(currentSalePolicyTempleteRegister, executeStrategyCode), (String)(onTime + "\uff0c\u672a\u627e\u5230\u6307\u5b9a\u4f18\u60e0\u653f\u7b56\u6267\u884c\u7b56\u7565\uff08%s\uff09\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[]{executeStrategyCode});
            Set bindingExecuteLadders = salePolicyTempleteExecuteStrategyVo.getBindingExecuteLadders();
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)bindingExecuteLadders) ? 1 : 0) != 0, (String)(onTime + "\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u6267\u884c\u7b56\u7565\u4fe1\u606f\u6ca1\u6709\u6307\u5b9a\u4f7f\u7528\u7684\u9636\u68af\u7b56\u7565"), (Object[])new Object[0]);
        }
        Set bindingLimitStrategyCodes = salePolicyTemplete.getBindingLimitStrategyCodes();
        if (!CollectionUtils.isEmpty((Collection)bindingLimitStrategyCodes)) {
            for (String limitStrategyCode : bindingLimitStrategyCodes) {
                Validate.notNull(this.findCorrectLimitStrategy(currentSalePolicyTempleteRegister, limitStrategyCode), (String)(onTime + "\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u9650\u91cf\u653f\u7b56\u4fe1\u606f\uff08%s\uff09\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[]{limitStrategyCode});
            }
        }
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)(bindingScopeTypes = salePolicyTemplete.getBindingScopeTypes())) ? 1 : 0) != 0, (String)(onTime + "\uff0c\u5f53\u524d\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u6ce8\u518c\u5668\uff0c\u5fc5\u987b\u8bbe\u5b9a\u7ed1\u5b9a\u7684\u5ba2\u6237\u8303\u56f4\u9009\u62e9\u65b9\u5f0f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        for (String bindingScopeType : bindingScopeTypes) {
            Validate.notNull(this.findCorrectCustomerScopeStrategy(currentSalePolicyTempleteRegister, bindingScopeType), (String)(onTime + "\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u5ba2\u6237\u8303\u56f4\u9009\u62e9\u65b9\u5f0f\uff08%s\uff09\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[]{bindingScopeType});
        }
    }

    private CharacteristicStrategy<? extends AbstractCharacteristicInfo> findCorrectCharacteristicStrategy(SalePolicyTempleteRegister salePolicyTempleteRegister, String characteristicStrategyCode) {
        Collection characteristicStrategyClasses = salePolicyTempleteRegister.getCharacteristicStrategyClasses();
        if (CollectionUtils.isEmpty((Collection)characteristicStrategyClasses)) {
            return null;
        }
        for (Class characteristicStrategyClass : characteristicStrategyClasses) {
            try {
                CharacteristicStrategy characteristicStrategy = (CharacteristicStrategy)this.applicationContext.getBean(characteristicStrategyClass);
                if (!StringUtils.equals((CharSequence)characteristicStrategy.characteristicCode(), (CharSequence)characteristicStrategyCode)) continue;
                return characteristicStrategy;
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> findCorrectExecuteStrategy(SalePolicyTempleteRegister salePolicyTempleteRegister, String executeStrategyCode) {
        Collection executeStrategyClasses = salePolicyTempleteRegister.getExecuteStrategyClasses();
        for (Class executeStrategyClass : executeStrategyClasses) {
            try {
                SalePolicyExecuteStrategy salePolicyExecuteStrategy = (SalePolicyExecuteStrategy)this.applicationContext.getBean(executeStrategyClass);
                if (!StringUtils.equals((CharSequence)salePolicyExecuteStrategy.getExecuteStrategyCode(), (CharSequence)executeStrategyCode)) continue;
                return salePolicyExecuteStrategy;
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private Set<SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo>> findAllBindingLimitStrategy(SalePolicyTempleteRegister salePolicyTempleteRegister) {
        Collection bindableLimitStrategyClasses = salePolicyTempleteRegister.getBindableLimitStrategyClasses();
        if (CollectionUtils.isEmpty((Collection)bindableLimitStrategyClasses)) {
            return null;
        }
        LinkedHashSet bindableLimitStrategySet = Sets.newLinkedHashSet();
        for (Class bindableLimitStrategyClass : bindableLimitStrategyClasses) {
            try {
                SalePolicyLimitStrategy currentSalePolicyLimitStrategy = (SalePolicyLimitStrategy)this.applicationContext.getBean(bindableLimitStrategyClass);
                bindableLimitStrategySet.add(currentSalePolicyLimitStrategy);
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return bindableLimitStrategySet;
    }

    private SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo> findCorrectLimitStrategy(SalePolicyTempleteRegister salePolicyTempleteRegister, String limitStrategyCode) {
        Set<SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo>> bindableLimitStrategies = this.findAllBindingLimitStrategy(salePolicyTempleteRegister);
        Validate.isTrue((!CollectionUtils.isEmpty(bindableLimitStrategies) ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u5f53\u524d\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u6709\u81f3\u5c11\u4e00\u4e2a\u80fd\u7ed1\u5b9a\u7684\u9650\u4ef7\u653f\u7b56\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LinkedHashMap bindableLimitStrategyMapping = Maps.newLinkedHashMap();
        for (SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo> salePolicyLimitStrategy : bindableLimitStrategies) {
            bindableLimitStrategyMapping.put(salePolicyLimitStrategy.getLimitStrategyCode(), salePolicyLimitStrategy);
        }
        Validate.notBlank((CharSequence)limitStrategyCode, (String)"\u81f3\u5c11\u4e00\u4e2a\u5c06\u8981\u4fdd\u5b58\u7684\u73b0\u4ef7\u7b56\u7565\u6ca1\u6709\u6307\u5b9acode\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyLimitStrategy currentSalePolicyLimitStrategy = (SalePolicyLimitStrategy)((HashMap)bindableLimitStrategyMapping).get(limitStrategyCode);
        Validate.notNull((Object)currentSalePolicyLimitStrategy, (String)"\u672a\u5339\u914d\u5230\u4e1a\u52a1\u7f16\u53f7\u4e3a:%s \u7684\u9650\u91cf\u653f\u7b56\u4fe1\u606f\uff0c\u53ef\u80fd\u662f\u8be5\u653f\u7b56\u4e0d\u5b58\u5728\u6216\u8005\u6539\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u4e0d\u5141\u8bb8\u5173\u8054\u8fd9\u4e2a\u9650\u91cf\u653f\u7b56\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{limitStrategyCode});
        return currentSalePolicyLimitStrategy;
    }

    private SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> findCorrectCustomerScopeStrategy(SalePolicyTempleteRegister salePolicyTempleteRegister, String customerScopeType) {
        Set<SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>> salePolicyCustomerScopeStrategies = this.findAllBindCustomerScopeStrategy(salePolicyTempleteRegister);
        LinkedHashMap bindableCustomerScopeStrategyMapping = Maps.newLinkedHashMap();
        for (SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> salePolicyCustomerScopeStrategy : salePolicyCustomerScopeStrategies) {
            bindableCustomerScopeStrategyMapping.put(salePolicyCustomerScopeStrategy.getScopeType(), salePolicyCustomerScopeStrategy);
        }
        Validate.notBlank((CharSequence)customerScopeType, (String)"\u8be5\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u4fdd\u5b58\u65f6\uff0c\u5e76\u6ca1\u6709\u8bbe\u5b9a\u5ba2\u6237\u8303\u56f4\u7684\u9009\u62e9\u7c7b\u578b(\u6216\u8005\u6839\u672c\u6ca1\u6709\u4f20\u5165)\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyCustomerScopeStrategy currentCustomerScopeStrategy = (SalePolicyCustomerScopeStrategy)((HashMap)bindableCustomerScopeStrategyMapping).get(customerScopeType);
        Validate.notNull((Object)currentCustomerScopeStrategy, (String)"\u8be5\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u4fdd\u5b58\u65f6\uff0c\u5e76\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7c7b\u578b\u7684\u5ba2\u6237\u8303\u56f4\u9009\u62e9\u7b56\u7565\uff08%s\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return currentCustomerScopeStrategy;
    }

    private Set<SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>> findAllBindCustomerScopeStrategy(SalePolicyTempleteRegister salePolicyTempleteRegister) {
        Collection salePolicyCustomerScopeStrategyClasses = salePolicyTempleteRegister.getCustomerScopeStrategyClasses();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)salePolicyCustomerScopeStrategyClasses) ? 1 : 0) != 0, (String)"\u8be5\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u5e76\u6ca1\u6709\u6ce8\u518c\u4efb\u4f55\u5ba2\u6237\u8fd4\u56de\u9009\u62e9\u65b9\u5f0f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LinkedHashSet bindableCustomerScopeStrategies = Sets.newLinkedHashSet();
        for (Class salePolicyCustomerScopeStrategyClass : salePolicyCustomerScopeStrategyClasses) {
            try {
                SalePolicyCustomerScopeStrategy currentSalePolicyCustomerScopeStrategy = (SalePolicyCustomerScopeStrategy)this.applicationContext.getBean(salePolicyCustomerScopeStrategyClass);
                String currentScopeType = currentSalePolicyCustomerScopeStrategy.getScopeType();
                Validate.notBlank((CharSequence)currentScopeType, (String)"\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u5ba2\u6237\u8303\u56f4\u7b56\u7565\u6ca1\u6709\u6307\u5b9acode\u4fe1\u606f(%s)\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{salePolicyCustomerScopeStrategyClass.getName()});
                bindableCustomerScopeStrategies.add(currentSalePolicyCustomerScopeStrategy);
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return bindableCustomerScopeStrategies;
    }

    private SalePolicyTempleteRegister findSalePolicyTempleteRegister(String type) {
        for (SalePolicyTempleteRegister salePolicyTempleteRegister : this.salePolicyTempleteRegisters) {
            if (!StringUtils.equals((CharSequence)salePolicyTempleteRegister.getType(), (CharSequence)type)) continue;
            return salePolicyTempleteRegister;
        }
        return null;
    }

    @Override
    @Transactional
    public SalePolicyTempleteVo update(SalePolicyTempleteVo salePolicyTemplete) {
        Validate.notNull((Object)salePolicyTemplete, (String)"\u4fee\u6539\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u65f6\uff0c\u9700\u8981\u786e\u8ba4\u4f20\u5165\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u7c7b\u5bf9\u8c61!!", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        salePolicyTemplete.setTenantCode(tenantCode);
        String id = salePolicyTemplete.getId();
        Validate.notBlank((CharSequence)id, (String)"\u4fee\u6539\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u65f6\uff0c\u9700\u8981\u4f20\u5165\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u7684id\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyTemplete currentSalePolicyTemplete = this.salePolicyTempleteRepository.findById(id);
        Validate.notNull((Object)((Object)currentSalePolicyTemplete), (String)"\u4fee\u6539\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyTempleteVo currentSalePolicyTempleteVo = (SalePolicyTempleteVo)this.nebulaToolkitService.copyObjectByBlankList((Object)currentSalePolicyTemplete, SalePolicyTempleteVo.class, HashSet.class, LinkedList.class, new String[0]);
        salePolicyTemplete.setType(currentSalePolicyTemplete.getType());
        salePolicyTemplete.setTempleteCode(currentSalePolicyTemplete.getTempleteCode());
        this.validate(salePolicyTemplete, "\u6dfb\u52a0\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u65f6");
        currentSalePolicyTemplete.setBindingCharacteristicStrategyCodes(StringUtils.join((Iterable)salePolicyTemplete.getBindingCharacteristicStrategyCodes(), (String)","));
        currentSalePolicyTemplete.setBindingProductSelectionMethods(StringUtils.join((Iterable)salePolicyTemplete.getBindingProductSelectionMethods(), (String)","));
        currentSalePolicyTemplete.setBindingLimitStrategyCodes(StringUtils.join((Iterable)salePolicyTemplete.getBindingLimitStrategyCodes(), (String)","));
        currentSalePolicyTemplete.setBindingScopeTypes(StringUtils.join((Iterable)salePolicyTemplete.getBindingScopeTypes(), (String)","));
        currentSalePolicyTemplete.setSupportBudget(salePolicyTemplete.getSupportBudget());
        currentSalePolicyTemplete.setTempleteName(salePolicyTemplete.getTempleteName());
        this.salePolicyTempleteRepository.saveOrUpdate((Object)currentSalePolicyTemplete);
        this.salePolicyTempleteExecuteStrategyRepository.deleteByTempleteId(id);
        Set salePolicyTempleteExecuteStrategys = salePolicyTemplete.getBindingExecuteStraties();
        for (SalePolicyTempleteExecuteStrategyVo salePolicyTempleteExecuteStrategyVo : salePolicyTempleteExecuteStrategys) {
            Set bindingExecuteLadders = salePolicyTempleteExecuteStrategyVo.getBindingExecuteLadders();
            String bindingExecuteStrategyCode = salePolicyTempleteExecuteStrategyVo.getBindingExecuteStrategyCode();
            SalePolicyTempleteExecuteStrategy salePolicyTempleteExecuteStrategy = new SalePolicyTempleteExecuteStrategy();
            salePolicyTempleteExecuteStrategy.setTempleteId(id);
            salePolicyTempleteExecuteStrategy.setBindingExecuteStrategyCode(bindingExecuteStrategyCode);
            salePolicyTempleteExecuteStrategy.setBindingExecuteLadders(StringUtils.join((Iterable)bindingExecuteLadders, (String)","));
            this.salePolicyTempleteExecuteStrategyRepository.save((Object)salePolicyTempleteExecuteStrategy);
            salePolicyTempleteExecuteStrategyVo.setId(salePolicyTempleteExecuteStrategy.getId());
        }
        this.recordLogOnUpdate(currentSalePolicyTempleteVo, salePolicyTemplete);
        return salePolicyTemplete;
    }

    private void recordLogOnUpdate(SalePolicyTempleteVo currentSalePolicyTemplete, SalePolicyTempleteVo salePolicyTemplete) {
        SalePolicyTempleteLogDto logDto = new SalePolicyTempleteLogDto();
        logDto.setOriginal(currentSalePolicyTemplete);
        logDto.setNewest(salePolicyTemplete);
        SerializableBiConsumer & Serializable onUpdate = SalePolicyTempleteLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logDto, SalePolicyTempleteLogEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    public boolean validate(Class<?> sourceClass, Class<?> targetClass) {
        return sourceClass == SalePolicyTemplete.class && targetClass == SalePolicyTempleteVo.class;
    }

    @Override
    @Transactional
    public void invalid(String salePolicyTempleteCode) {
        Validate.notBlank((CharSequence)salePolicyTempleteCode, (String)"\u7981\u7528\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u76f8\u5173\u7684\u6a21\u677fcode", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        SalePolicyTemplete currentSalePolicyTemplete = this.salePolicyTempleteRepository.findByTempleteCode(salePolicyTempleteCode, tenantCode);
        Validate.notNull((Object)((Object)currentSalePolicyTemplete), (String)"\u7981\u7528\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u65f6\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u677fcode", (Object[])new Object[0]);
        currentSalePolicyTemplete.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
        this.salePolicyTempleteRepository.saveOrUpdate((Object)currentSalePolicyTemplete);
        this.recordLogOnDisable(currentSalePolicyTemplete);
    }

    private void recordLogOnDisable(SalePolicyTemplete currentSalePolicyTemplete) {
        SalePolicyTempleteVo voDb = new SalePolicyTempleteVo();
        voDb.setId(currentSalePolicyTemplete.getId());
        voDb.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        SalePolicyTempleteVo vo = new SalePolicyTempleteVo();
        vo.setId(currentSalePolicyTemplete.getId());
        vo.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
        SalePolicyTempleteLogDto logDto = new SalePolicyTempleteLogDto();
        logDto.setOriginal(voDb);
        logDto.setNewest(vo);
        SerializableBiConsumer & Serializable OnDisable = SalePolicyTempleteLogEventListener::OnDisable;
        this.nebulaNetEventClient.publish((NebulaEventDto)logDto, SalePolicyTempleteLogEventListener.class, (SerializableBiConsumer)OnDisable);
    }

    @Override
    @Transactional
    public void effective(String salePolicyTempleteCode) {
        Validate.notBlank((CharSequence)salePolicyTempleteCode, (String)"\u542f\u7528\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u76f8\u5173\u7684\u6a21\u677fcode", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        SalePolicyTemplete currentSalePolicyTemplete = this.salePolicyTempleteRepository.findByTempleteCode(salePolicyTempleteCode, tenantCode);
        Validate.notNull((Object)((Object)currentSalePolicyTemplete), (String)"\u542f\u7528\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u65f6\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u677fcode", (Object[])new Object[0]);
        currentSalePolicyTemplete.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.salePolicyTempleteRepository.saveOrUpdate((Object)currentSalePolicyTemplete);
        this.recordLogOnEnable(currentSalePolicyTemplete);
    }

    private void recordLogOnEnable(SalePolicyTemplete currentSalePolicyTemplete) {
        SalePolicyTempleteVo voDb = new SalePolicyTempleteVo();
        voDb.setId(currentSalePolicyTemplete.getId());
        voDb.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
        SalePolicyTempleteVo vo = new SalePolicyTempleteVo();
        vo.setId(currentSalePolicyTemplete.getId());
        vo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        SalePolicyTempleteLogDto logDto = new SalePolicyTempleteLogDto();
        logDto.setOriginal(voDb);
        logDto.setNewest(vo);
        SerializableBiConsumer & Serializable OnEnable = SalePolicyTempleteLogEventListener::OnEnable;
        this.nebulaNetEventClient.publish((NebulaEventDto)logDto, SalePolicyTempleteLogEventListener.class, (SerializableBiConsumer)OnEnable);
    }

    @Override
    @Transactional
    public void deleteByTempleteCode(String salePolicyTempleteCode) {
        Validate.notBlank((CharSequence)salePolicyTempleteCode, (String)"\u5220\u9664\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u4f18\u60e0\u653f\u7b56\u4e1a\u52a1\u7f16\u53f7!", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List<SalePolicy> salePolicies = this.salePolicyRepository.findByTempleteCodeAndTenantCode(salePolicyTempleteCode, tenantCode);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(salePolicies), (String)"\u5220\u9664\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u65f6\uff0c\u53d1\u73b0\u8be5\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664", (Object[])new Object[0]);
        SalePolicyTemplete exsitSalePolicyTemplete = this.salePolicyTempleteRepository.findByTempleteCode(salePolicyTempleteCode, tenantCode);
        Validate.notNull((Object)((Object)exsitSalePolicyTemplete), (String)"\u5220\u9664\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.salePolicyTempleteExecuteStrategyRepository.deleteByTempleteId(exsitSalePolicyTemplete.getId());
        this.salePolicyTempleteRepository.deleteByTempleteCode(salePolicyTempleteCode, tenantCode);
        this.recordLogOnDelete(exsitSalePolicyTemplete);
    }

    private void recordLogOnDelete(SalePolicyTemplete salePolicyTemplete) {
        SalePolicyTempleteVo voDb = new SalePolicyTempleteVo();
        voDb.setId(salePolicyTemplete.getId());
        SalePolicyTempleteLogDto logDto = new SalePolicyTempleteLogDto();
        logDto.setOriginal(voDb);
        logDto.setNewest(null);
        SerializableBiConsumer & Serializable OnDelete = SalePolicyTempleteLogEventListener::OnDelete;
        this.nebulaNetEventClient.publish((NebulaEventDto)logDto, SalePolicyTempleteLogEventListener.class, (SerializableBiConsumer)OnDelete);
    }

    public void callback(Class<SalePolicyTemplete> sourceClass, List<SalePolicyTemplete> sourceObjects, Class<SalePolicyTempleteVo> targetClass, List<SalePolicyTempleteVo> targetObjects) {
        Iterator<SalePolicyTempleteVo> targetObjectIterator = targetObjects.iterator();
        for (SalePolicyTemplete sourceSalePolicyTemplete : sourceObjects) {
            String templeteRegisterType;
            SalePolicyTempleteRegister salePolicyTempleteRegister;
            Set<SalePolicyTempleteExecuteStrategy> bindingExecuteStrategys;
            String bindingScopeTypes;
            String bindingLimitStrategyCodes;
            String bindingProductSelectionMethods;
            SalePolicyTempleteVo targetSalePolicyTemplete = targetObjectIterator.next();
            String bindingCharacteristicStrategyCodes = sourceSalePolicyTemplete.getBindingCharacteristicStrategyCodes();
            if (StringUtils.isNotBlank((CharSequence)bindingCharacteristicStrategyCodes)) {
                targetSalePolicyTemplete.setBindingCharacteristicStrategyCodes((Set)Sets.newHashSet((Object[])StringUtils.split((String)bindingCharacteristicStrategyCodes, (String)",")));
            }
            if (StringUtils.isNotBlank((CharSequence)(bindingProductSelectionMethods = sourceSalePolicyTemplete.getBindingProductSelectionMethods()))) {
                targetSalePolicyTemplete.setBindingProductSelectionMethods((Set)Sets.newHashSet((Object[])StringUtils.split((String)bindingProductSelectionMethods, (String)",")));
            }
            if (StringUtils.isNotBlank((CharSequence)(bindingLimitStrategyCodes = sourceSalePolicyTemplete.getBindingLimitStrategyCodes()))) {
                targetSalePolicyTemplete.setBindingLimitStrategyCodes((Set)Sets.newHashSet((Object[])StringUtils.split((String)bindingLimitStrategyCodes, (String)",")));
            }
            if (StringUtils.isNotBlank((CharSequence)(bindingScopeTypes = sourceSalePolicyTemplete.getBindingScopeTypes()))) {
                targetSalePolicyTemplete.setBindingScopeTypes((Set)Sets.newHashSet((Object[])StringUtils.split((String)bindingScopeTypes, (String)",")));
            }
            if (!CollectionUtils.isEmpty(bindingExecuteStrategys = sourceSalePolicyTemplete.getBindingExecuteStraties())) {
                LinkedHashSet bindingExecuteStrategyVos = Sets.newLinkedHashSet();
                for (SalePolicyTempleteExecuteStrategy salePolicyTempleteExecuteStrategy : bindingExecuteStrategys) {
                    SalePolicyTempleteExecuteStrategyVo salePolicyTempleteExecuteStrategyVo = new SalePolicyTempleteExecuteStrategyVo();
                    salePolicyTempleteExecuteStrategyVo.setId(salePolicyTempleteExecuteStrategy.getId());
                    salePolicyTempleteExecuteStrategyVo.setBindingExecuteLadders((Set)Sets.newHashSet((Object[])StringUtils.split((String)salePolicyTempleteExecuteStrategy.getBindingExecuteLadders(), (String)",")));
                    salePolicyTempleteExecuteStrategyVo.setBindingExecuteStrategyCode(salePolicyTempleteExecuteStrategy.getBindingExecuteStrategyCode());
                    bindingExecuteStrategyVos.add(salePolicyTempleteExecuteStrategyVo);
                }
                targetSalePolicyTemplete.setBindingExecuteStraties((Set)bindingExecuteStrategyVos);
            }
            if ((salePolicyTempleteRegister = this.findSalePolicyTempleteRegister(templeteRegisterType = sourceSalePolicyTemplete.getType())) == null) continue;
            targetSalePolicyTemplete.setTypeDesc(salePolicyTempleteRegister.getTypeDesc());
        }
    }

    @Override
    public SalePolicyTempleteVo findByTempleteCode(String templeteCode, String tenantCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{templeteCode, tenantCode})) {
            return null;
        }
        SalePolicyTemplete salePolicyTemplete = this.salePolicyTempleteRepository.findByTempleteCode(templeteCode, tenantCode);
        if (salePolicyTemplete == null) {
            return null;
        }
        return (SalePolicyTempleteVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)salePolicyTemplete, SalePolicyTempleteVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    public Set<SalePolicyTempleteVo> findByTenantCode(String tenantCode, EnableStatusEnum enableStatus) {
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return null;
        }
        Set<SalePolicyTemplete> salePolicyTempletes = this.salePolicyTempleteRepository.findByTenantCode(tenantCode, enableStatus);
        if (CollectionUtils.isEmpty(salePolicyTempletes)) {
            return null;
        }
        List<SalePolicyTempleteVo> salePolicyTempleteVos = this.covertEntityToVo(Lists.newArrayList(salePolicyTempletes));
        return Sets.newLinkedHashSet(salePolicyTempleteVos);
    }

    @Override
    public Page<SalePolicyTempleteVo> findByConditions(Pageable pageable, SalePolicyTempletePageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (SalePolicyTempletePageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new SalePolicyTempletePageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<SalePolicyTemplete> entityPage = this.salePolicyTempleteRepository.findByConditions(pageable, dto);
        List entities = entityPage.getRecords();
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        pageResult.setRecords(this.covertEntityToVo(entities));
        return pageResult;
    }

    private List<SalePolicyTempleteVo> covertEntityToVo(List<SalePolicyTemplete> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newArrayList();
        }
        ArrayList salePolicyTempleteVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(entities, SalePolicyTemplete.class, SalePolicyTempleteVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        return salePolicyTempleteVos;
    }
}

