/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.service.internal;

import com.biz.crm.dms.business.policy.local.entity.SalePolicy;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyThreshold;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyThresholdDetail;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyThresholdProduct;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyThresholdDetailRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyThresholdProductRepository;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyThresholdRepository;
import com.biz.crm.dms.business.policy.local.service.SalePolicyThresholdService;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyThresholdDetailVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyThresholdProductVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyThresholdVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SalePolicyThresholdServiceImpl
implements SalePolicyThresholdService {
    @Autowired(required=false)
    private SalePolicyRepository salePolicyRepository;
    @Autowired(required=false)
    private SalePolicyThresholdRepository salePolicyThresholdRepository;
    @Autowired(required=false)
    private SalePolicyThresholdDetailRepository salePolicyThresholdDetailRepository;
    @Autowired(required=false)
    private SalePolicyThresholdProductRepository salePolicyThresholdProductRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public SalePolicyThreshold create(SalePolicyThresholdVo salePolicyThreshold) {
        SalePolicyThreshold existThreshold;
        Validate.notNull((Object)((Object)salePolicyThreshold), (String)"\u521b\u5efa\u5546\u54c1\u95e8\u69db\u65f6\uff0c\u95e8\u69db\u57fa\u672c\u4fe1\u606f\u9700\u8981\u4f20\u5165!!", (Object[])new Object[0]);
        String salePolicyCode = salePolicyThreshold.getSalePolicyCode();
        Validate.notBlank((CharSequence)salePolicyCode, (String)"\u521b\u5efa\u5546\u54c1\u95e8\u69db\u65f6\uff0c\u9700\u8981\u6307\u5b9a\u4f18\u60e0\u653f\u7b56\u4e1a\u52a1\u7f16\u53f7", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        SalePolicy exsitSalePolicy = this.salePolicyRepository.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode);
        Validate.notNull((Object)((Object)exsitSalePolicy), (String)"\u521b\u5efa\u5546\u54c1\u95e8\u69db\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u57fa\u672c\u4fe1\u606f(%s)\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{salePolicyCode});
        if (StringUtils.isBlank((CharSequence)salePolicyThreshold.getTenantCode())) {
            salePolicyThreshold.setTenantCode(tenantCode);
        }
        Validate.isTrue(((existThreshold = this.salePolicyThresholdRepository.findBySalePolicyCode(salePolicyCode, tenantCode)) == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u95e8\u69db\u65f6\uff0c\u53d1\u73b0\u6307\u5b9a\u7684\u7684\u4f18\u60e0\u653f\u7b56\u5df2\u7ecf\u8bbe\u5b9a\u4e86\u95e8\u69db\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Integer composeUnit = salePolicyThreshold.getComposeUnit();
        Validate.inclusiveBetween((long)1L, (long)2L, (long)composeUnit.intValue(), (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u95e8\u69db\u65f6\uff0c\u603b\u6700\u4f4e\u9650\u91cf\u5355\u4f4d\u672a\u6b63\u786e\u4f20\u5165\uff081\uff1a\u603b\u91d1\u989d\uff1b2\uff1a\u603b\u6570\u91cf\uff09");
        Integer composeNumber = salePolicyThreshold.getComposeNumber();
        Validate.isTrue((composeNumber != null && composeNumber >= 0 ? 1 : 0) != 0, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u95e8\u69db\u65f6\uff0c\u603b\u6700\u4f4e\u9650\u91cf\u6570\u91cf\u672a\u4f20\u5165\uff08\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\uff0c\u5982\u679c\u6ca1\u6709\u9650\u91cf\uff0c\u5219\u4f20\u51650\uff09", (Object[])new Object[0]);
        SalePolicyThreshold salePolicyThresholdEntity = (SalePolicyThreshold)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)salePolicyThreshold, SalePolicyThreshold.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.salePolicyThresholdRepository.save((Object)salePolicyThresholdEntity);
        salePolicyThreshold.setId(salePolicyThresholdEntity.getId());
        if (exsitSalePolicy.getWholePolicy().booleanValue()) {
            return salePolicyThresholdEntity;
        }
        List<SalePolicyThresholdDetailVo> salePolicyThresholdDetails = salePolicyThreshold.getThresholdDetails();
        for (SalePolicyThresholdDetailVo salePolicyThresholdDetail : salePolicyThresholdDetails) {
            salePolicyThresholdDetail.setSalePolicyCode(salePolicyCode);
            salePolicyThresholdDetail.setTenantCode(tenantCode);
            String thresholdDetailCode = salePolicyThresholdDetail.getThresholdDetailCode();
            SalePolicyThresholdDetail exsitSalePolicyThresholdDetail = this.salePolicyThresholdDetailRepository.findBySalePolicyCodeAndThresholdDetailCode(salePolicyCode, tenantCode, thresholdDetailCode);
            Validate.isTrue((exsitSalePolicyThresholdDetail == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u95e8\u69db\u660e\u7ec6\u65f6\uff0c\u53d1\u73b0\u6307\u5b9a\u7684\u4f18\u60e0\u653f\u7b56\u95e8\u69dbcode\uff08%s\uff09\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{thresholdDetailCode});
            Validate.notBlank((CharSequence)thresholdDetailCode, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u95e8\u69db\u660e\u7ec6\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u6761\u4f18\u60e0\u653f\u7b56\u95e8\u69db\u4e1a\u52a1\u7f16\u53f7\u6ca1\u6709\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Integer includeType = salePolicyThresholdDetail.getIncludeType();
            Validate.notNull((Object)includeType, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u95e8\u69db\u660e\u7ec6\u65f6\uff08%s\uff09\uff0c\u5168\u5c40\u9650\u91cf\u7c7b\u578b\uff08includeType\uff09\u5fc5\u987b\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{thresholdDetailCode});
            Validate.inclusiveBetween((long)1L, (long)2L, (long)includeType.intValue(), (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u95e8\u69db\u660e\u7ec6\u65f6\uff0c\u53d1\u73b0\u4e0d\u652f\u6301\u7684\u95e8\u69db\u7c7b\u578b\u503c\uff08includeType\uff09,\u8bf7\u68c0\u67e5!!");
            List<SalePolicyThresholdProductVo> thresholdProducts = salePolicyThresholdDetail.getThresholdProducts();
            if (includeType == 2) {
                Integer includeNumber = salePolicyThresholdDetail.getIncludeNumber();
                Validate.isTrue((includeNumber != null && includeNumber >= 0 ? 1 : 0) != 0, (String)"\u7ef4\u62a4\u4f18\u60e0\u653f\u7b56\u95e8\u69db\u8be6\u60c5\u4fe1\u606f\u65f6\uff08%s\uff09\uff0c\u53d1\u73b0\u672a\u6b63\u786e\u586b\u5199\u7684\u201c\u5fc5\u542b\u6570\u91cf\u201d\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{thresholdDetailCode});
                Validate.isTrue((!CollectionUtils.isEmpty(thresholdProducts) ? 1 : 0) != 0, (String)"\u7ef4\u62a4\u4f18\u60e0\u653f\u7b56\u95e8\u69db\u8be6\u60c5\u4fe1\u606f\u65f6\uff08%s\uff09\uff0c\u672a\u53d1\u73b0\u5546\u54c1\u95e8\u69db\u8be6\u60c5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{thresholdDetailCode});
                Validate.isTrue((thresholdProducts.size() >= includeNumber ? 1 : 0) != 0, (String)"\u7ef4\u62a4\u4f18\u60e0\u653f\u7b56\u95e8\u69db\u8be6\u60c5\u4fe1\u606f\u65f6\uff08%s\uff09\uff0c\u53d1\u73b0\u5fc5\u9009\u5546\u54c1\u6570\u91cf\u5927\u4e8e\u95e8\u69db\u4e2d\u9009\u5b9a\u7684\u5546\u54c1\u6570\u91cf\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{thresholdDetailCode});
                int certainCount = (int)thresholdProducts.stream().filter(item -> item.getCertain() != null && item.getCertain() != false).count();
                Validate.isTrue((thresholdProducts.size() >= certainCount ? 1 : 0) != 0, (String)"\u7ef4\u62a4\u4f18\u60e0\u653f\u7b56\u95e8\u69db\u8be6\u60c5\u4fe1\u606f\u65f6\uff08%s\uff09\uff0c\u53d1\u73b0\u8bbe\u5b9a\u7684\u5546\u54c1\u6570\u91cf\u5df2\u7ecf\u5c0f\u4e8e\u8bbe\u5b9a\u4e3a\u201c\u5fc5\u9009\u201d\u7684\u5546\u54c1\u6570\u91cf\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{thresholdDetailCode});
                Validate.isTrue((includeNumber >= certainCount ? 1 : 0) != 0, (String)"\u7ef4\u62a4\u4f18\u60e0\u653f\u7b56\u95e8\u69db\u8be6\u60c5\u4fe1\u606f\u65f6\uff08%s\uff09\uff0c\u53d1\u73b0\u8bbe\u5b9a\u7684\u5546\u54c1\u95e8\u69db\u6570\u91cf\u5df2\u7ecf\u5c0f\u4e8e\u8bbe\u5b9a\u4e3a\u201c\u5fc5\u9009\u201d\u7684\u5546\u54c1\u6570\u91cf\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{thresholdDetailCode});
            }
            SalePolicyThresholdDetail salePolicyThresholdDetailEntity = (SalePolicyThresholdDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)salePolicyThresholdDetail, SalePolicyThresholdDetail.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            salePolicyThresholdDetailEntity.setSalePolicyThresholdId(salePolicyThreshold.getId());
            this.salePolicyThresholdDetailRepository.save((Object)salePolicyThresholdDetailEntity);
            salePolicyThresholdDetail.setId(salePolicyThresholdDetailEntity.getId());
            if (CollectionUtils.isEmpty(thresholdProducts)) continue;
            for (SalePolicyThresholdProductVo thresholdProductItem : thresholdProducts) {
                thresholdProductItem.setTenantCode(tenantCode);
                thresholdProductItem.setSalePolicyCode(salePolicyCode);
                thresholdProductItem.setThresholdDetailCode(thresholdDetailCode);
                String productCode = thresholdProductItem.getProductCode();
                Validate.notBlank((CharSequence)productCode, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u660e\u7ec6\u95e8\u69db\u5546\u54c1\u65f6\uff0c\u5546\u54c1\u9650\u91cf\u4fe1\u606f\u7684\u4e1a\u52a1\u7f16\u53f7\u6ca1\u6709\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                Integer thresholdUnit = thresholdProductItem.getThresholdUnit();
                Validate.inclusiveBetween((Object)1, (Object)2, (Comparable)thresholdUnit, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u660e\u7ec6\u95e8\u69db\u5546\u54c1\u65f6\uff0c\u4e1a\u52a1\u7f16\u53f7\u4e3a[%s]\u7684\u5546\u54c1\u9650\u91cf\u5355\u4f4d\u672a\u6b63\u786e\u4f20\u5165\uff081\uff1a\u603b\u91d1\u989d\uff1b2\uff1a\u603b\u6570\u91cf\uff09", (Object[])new Object[]{productCode});
                Integer thresholdNumber = thresholdProductItem.getThresholdNumber();
                Validate.isTrue((thresholdNumber != null && thresholdNumber >= 0 ? 1 : 0) != 0, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u660e\u7ec6\u95e8\u69db\u5546\u54c1\u65f6\uff0c\u4e1a\u52a1\u7f16\u53f7\u4e3a[%s]\u7684\u5546\u54c1\u9650\u91cf\u6570\u91cf\u672a\u4f20\u5165\uff08\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\uff0c\u5982\u679c\u6ca1\u6709\u9650\u91cf\uff0c\u5219\u4f20\u51650\uff09", (Object[])new Object[]{productCode});
                Boolean certain = thresholdProductItem.getCertain();
                Validate.notNull((Object)certain, (String)"\u521b\u5efa\u4f18\u60e0\u653f\u7b56\u660e\u7ec6\u95e8\u69db\u5546\u54c1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u8be5\u5546\u54c1\u95e8\u69db\u662f\u5426\u662f\u5fc5\u987b\u7684\uff08certain\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                SalePolicyThresholdProduct salePolicyThresholdProductEntity = (SalePolicyThresholdProduct)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)thresholdProductItem, SalePolicyThresholdProduct.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                salePolicyThresholdProductEntity.setThresholdDetailId(salePolicyThresholdDetailEntity.getId());
                this.salePolicyThresholdProductRepository.save((Object)salePolicyThresholdProductEntity);
                thresholdProductItem.setId(salePolicyThresholdProductEntity.getId());
            }
        }
        return salePolicyThresholdEntity;
    }

    @Override
    public SalePolicyThreshold findBySalePolicyCode(String salePolicyCode, String tenantCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{salePolicyCode, tenantCode})) {
            return null;
        }
        return this.salePolicyThresholdRepository.findBySalePolicyCode(salePolicyCode, tenantCode);
    }
}

