/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.service.task;

import com.biz.crm.dms.business.policy.local.entity.SalePolicy;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyRepository;
import com.biz.crm.dms.business.policy.local.service.task.SalePolicyLoadingTask;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SalePolicyCacheLoadingService {
    public static final String SALE_POLICY_NOTIFY = "_SALE_POLICY_NOTIFY";
    private static Map<String, Map<String, SalePolicyVo>> salePolicysCacheMapping = Maps.newConcurrentMap();
    @Autowired(required=false)
    private Redisson redisson;
    private volatile Map<String, AtomicReference<Thread>> flashingThreadMapping = Maps.newConcurrentMap();
    private Map<String, ReentrantLock> salePolicyloadLockMapping = Maps.newConcurrentMap();
    @Autowired(required=false)
    private SalePolicyRepository salePolicyRepository;
    @Autowired(required=false)
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    @Qualifier(value="policyLoadingExecutor")
    private ThreadPoolExecutor policyLoadingExecutor;
    private static final Logger LOGGER = LoggerFactory.getLogger(SalePolicyCacheLoadingService.class);

    public void notifyCacheRefresh(String tenantCode) {
        RTopic topic = this.redisson.getTopic(SALE_POLICY_NOTIFY);
        topic.publish((Object)StringUtils.join((Object[])new String[]{tenantCode}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void reloadingCache(String tenantCode) {
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return;
        }
        ReentrantLock tenantReentrantLock = null;
        while ((tenantReentrantLock = this.salePolicyloadLockMapping.get(tenantCode)) == null) {
            Class<SalePolicyCacheLoadingService> clazz = SalePolicyCacheLoadingService.class;
            // MONITORENTER : com.biz.crm.dms.business.policy.local.service.task.SalePolicyCacheLoadingService.class
            while ((tenantReentrantLock = this.salePolicyloadLockMapping.get(tenantCode)) == null) {
                tenantReentrantLock = new ReentrantLock();
                this.salePolicyloadLockMapping.put(tenantCode, tenantReentrantLock);
            }
            // MONITOREXIT : clazz
        }
        AtomicReference<Thread> tenantLeadingThreadReference = null;
        while ((tenantLeadingThreadReference = this.flashingThreadMapping.get(tenantCode)) == null) {
            Class<SalePolicyCacheLoadingService> clazz = SalePolicyCacheLoadingService.class;
            // MONITORENTER : com.biz.crm.dms.business.policy.local.service.task.SalePolicyCacheLoadingService.class
            while ((tenantLeadingThreadReference = this.flashingThreadMapping.get(tenantCode)) == null) {
                tenantLeadingThreadReference = new AtomicReference();
                this.flashingThreadMapping.put(tenantCode, tenantLeadingThreadReference);
            }
            // MONITOREXIT : clazz
        }
        Thread leadingThread = Thread.currentThread();
        boolean isFlashingThread = false;
        isFlashingThread = tenantLeadingThreadReference.compareAndSet(null, leadingThread);
        if (!isFlashingThread) {
            Thread.yield();
        }
        if (!isFlashingThread) {
            while (tenantLeadingThreadReference.get() != null) {
                Thread.yield();
            }
            return;
        }
        tenantReentrantLock.lock();
        try {
            ConcurrentMap newSalePolicysCacheForTenantMapping = Maps.newConcurrentMap();
            salePolicysCacheMapping.put(tenantCode, newSalePolicysCacheForTenantMapping);
            this.cacheByTenantCodeFromRepository(tenantCode, newSalePolicysCacheForTenantMapping);
            return;
        }
        finally {
            tenantLeadingThreadReference.compareAndSet(leadingThread, null);
            tenantReentrantLock.unlock();
        }
    }

    private void cacheByTenantCodeFromRepository(String tenantCode, Map<String, SalePolicyVo> newSalePolicysCacheForTenantMapping) {
        List<SalePolicy> allSalePolicies = this.salePolicyRepository.findByTenantCode(tenantCode);
        if (CollectionUtils.isEmpty(allSalePolicies)) {
            return;
        }
        LinkedHashSet loadingSet = Sets.newLinkedHashSet();
        for (SalePolicy salePolicy : allSalePolicies) {
            SalePolicyLoadingTask policyLoadingTask = (SalePolicyLoadingTask)this.applicationContext.getBean(SalePolicyLoadingTask.class, new Object[]{salePolicy, tenantCode});
            Future<SalePolicyVo> future = this.policyLoadingExecutor.submit(policyLoadingTask);
            loadingSet.add(future);
        }
        for (Future futureItem : loadingSet) {
            try {
                SalePolicyVo result = (SalePolicyVo)futureItem.get();
                if (result == null) continue;
                newSalePolicysCacheForTenantMapping.put(result.getSalePolicyCode(), result);
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Set<SalePolicyVo> findByTenantCode(String tenantCode, Set<String> prioritySalePolicyCodes) {
        Map<String, SalePolicyVo> cache;
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return null;
        }
        LinkedHashSet result = Sets.newLinkedHashSet();
        while (true) {
            if (this.salePolicyloadLockMapping.get(tenantCode) == null || this.flashingThreadMapping.get(tenantCode) == null) {
                this.reloadingCache(tenantCode);
            }
            AtomicReference<Thread> tenantLeadingThreadReference = null;
            if (this.salePolicyloadLockMapping.get(tenantCode) != null && (tenantLeadingThreadReference = this.flashingThreadMapping.get(tenantCode)) != null && tenantLeadingThreadReference.get() != null) {
                if (CollectionUtils.isEmpty(prioritySalePolicyCodes)) {
                    while (tenantLeadingThreadReference.get() != null) {
                        Thread.yield();
                    }
                } else {
                    String prioritySalePolicyCode;
                    SalePolicyVo currentSalePolicy;
                    cache = salePolicysCacheMapping.get(tenantCode);
                    if (cache == null) continue;
                    Iterator<String> iterator = prioritySalePolicyCodes.iterator();
                    while (iterator.hasNext() && (currentSalePolicy = cache.get(prioritySalePolicyCode = iterator.next())) != null) {
                        result.add(currentSalePolicy);
                        if (result.size() != prioritySalePolicyCodes.size()) continue;
                        return result;
                    }
                }
            }
            if (this.salePolicyloadLockMapping.get(tenantCode) != null && (tenantLeadingThreadReference = this.flashingThreadMapping.get(tenantCode)) != null && tenantLeadingThreadReference.get() == null) break;
        }
        cache = salePolicysCacheMapping.get(tenantCode);
        if (CollectionUtils.isEmpty(prioritySalePolicyCodes)) {
            result = Sets.newLinkedHashSet(cache.values());
        } else {
            result = Sets.newLinkedHashSet();
            for (String prioritySalePolicyCode : prioritySalePolicyCodes) {
                SalePolicyVo currentSalePolicyVo = cache.get(prioritySalePolicyCode);
                if (currentSalePolicyVo == null) continue;
                result.add(currentSalePolicyVo);
            }
        }
        return result;
    }
}

