/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.service.task;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.policy.local.entity.SalePolicy;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyTemplete;
import com.biz.crm.dms.business.policy.local.repository.SalePolicyTempleteRepository;
import com.biz.crm.dms.business.policy.sdk.register.SalePolicyTempleteRegister;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyStickupListener;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyLimitInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyThreshold;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.CollectionUtils;

public class SalePolicyLoadingTask
implements Callable<SalePolicyVo> {
    @Autowired(required=false)
    private List<SalePolicyTempleteRegister> salePolicyTempleteRegisters;
    @Autowired(required=false)
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SalePolicyTempleteRepository salePolicyTempleteRepository;
    @Autowired
    private LoginUserService loginUserService;
    private static final Logger LOGGER = LoggerFactory.getLogger(SalePolicyLoadingTask.class);
    private SalePolicy salePolicy;
    private String tenantCode;

    public SalePolicyLoadingTask(SalePolicy salePolicy, String tenantCode) {
        this.salePolicy = salePolicy;
        this.tenantCode = tenantCode;
        Validate.notNull((Object)((Object)salePolicy), (String)"PolicyLoadingTask: salePolicy null !!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tenantCode, (String)"PolicyLoadingTask: tenantCode blank !!", (Object[])new Object[0]);
    }

    @Override
    public SalePolicyVo call() throws Exception {
        this.loginUserService.refreshAuthentication(null);
        try {
            SalePolicyVo salePolicyVo = this.perfectByTenantCodeAndSalePolicyCodeFromRepository(this.salePolicy, this.tenantCode);
            return salePolicyVo;
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    private SalePolicyVo perfectByTenantCodeAndSalePolicyCodeFromRepository(SalePolicy salePolicy, String tenantCode) {
        String type = salePolicy.getType();
        String salePolicyCode = salePolicy.getSalePolicyCode();
        SalePolicyTempleteRegister matchedSalePolicyTempleteRegister = this.findSalePolicyTempleteRegister(type);
        if (matchedSalePolicyTempleteRegister == null) {
            LOGGER.warn("\u5728\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u7f13\u5b58\u52a0\u8f7d\u65f6\uff0c\u672a\u53d1\u73b0\u7279\u5b9a\u4f18\u60e0\u653f\u7b56\u6a21\u677f\u7684\u6ce8\u518c\u5668({})\uff0c\u8bf7\u68c0\u67e5!!", (Object)salePolicyCode);
            return null;
        }
        SalePolicyStickupListener stickupListener = matchedSalePolicyTempleteRegister.getStickupListener();
        SalePolicyVo salePolicyVo = (SalePolicyVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)salePolicy, SalePolicyVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        AbstractSalePolicyThreshold salePolicyThreshold = stickupListener.onRequestSalePolicyThreshold(tenantCode, salePolicyCode);
        if (salePolicyThreshold != null) {
            salePolicyVo.setSalePolicyProductThreshold(salePolicyThreshold);
        }
        Collection executeStrategyClasses = matchedSalePolicyTempleteRegister.getExecuteStrategyClasses();
        LinkedHashSet salePolicyExecutorInfos = Sets.newLinkedHashSet();
        for (Class executeStrategyClass : executeStrategyClasses) {
            SalePolicyExecuteStrategy currentExecuteStrategy = (SalePolicyExecuteStrategy)this.applicationContext.getBean(executeStrategyClass);
            List executorInfos = currentExecuteStrategy.onRequestSalePolicyExecutorInfo(tenantCode, salePolicyCode);
            if (CollectionUtils.isEmpty((Collection)executorInfos)) continue;
            salePolicyExecutorInfos.addAll(executorInfos);
        }
        if (CollectionUtils.isEmpty((Collection)salePolicyExecutorInfos)) {
            LOGGER.warn("\u5728\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u7f13\u5b58\u52a0\u8f7d\u65f6\uff0c\u672a\u53d1\u73b0\u7279\u5b9a\u4f18\u60e0\u653f\u7b56\u7684\u4f18\u60e0\u7b56\u7565\u4fe1\u606f({})\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u8fd9\u4e2a\u4f18\u60e0\u653f\u7b56\u4fe1\u606f\u7684\u4e1a\u52a1\u7f16\u53f7\u53d1\u751f\u4e86\u53d8\u5316\uff08\u8fd9\u53ef\u80fd\u662f\u4e00\u79cd\u6b63\u5e38\u73b0\u8c61\uff09!!", (Object)salePolicyCode);
            return null;
        }
        salePolicyVo.setSalePolicyExecutorInfos((Set)salePolicyExecutorInfos);
        boolean supportProduct = matchedSalePolicyTempleteRegister.supportProduct();
        if (supportProduct) {
            List salePolicyProductInfos = stickupListener.onRequestSalePolicyProductInfos(tenantCode, salePolicyCode);
            if (CollectionUtils.isEmpty((Collection)salePolicyProductInfos)) {
                LOGGER.warn("\u5728\u8fdb\u884c\u4f18\u60e0\u653f\u7b56\u7f13\u5b58\u52a0\u8f7d\u65f6\uff0c\u672a\u53d1\u73b0\u7279\u5b9a\u4f18\u60e0\u653f\u7b56\u7684\u5546\u54c1\u672c\u54c1\u4fe1\u606f({})\uff0c\u8bf7\u68c0\u67e5!!", (Object)salePolicyCode);
                return null;
            }
            salePolicyVo.setSalePolicyProductInfos((Set)Sets.newLinkedHashSet((Iterable)salePolicyProductInfos));
        } else {
            salePolicyVo.setSalePolicyProductInfos(null);
        }
        Collection bindableLimitStrategyClasses = matchedSalePolicyTempleteRegister.getBindableLimitStrategyClasses();
        if (!CollectionUtils.isEmpty((Collection)bindableLimitStrategyClasses)) {
            LinkedHashSet salePolicyLimitInfos = Sets.newLinkedHashSet();
            for (Class salePolicyLimitStrategyClass : bindableLimitStrategyClasses) {
                SalePolicyLimitStrategy currentSalePolicyLimitStrategy = (SalePolicyLimitStrategy)this.applicationContext.getBean(salePolicyLimitStrategyClass);
                AbstractSalePolicyLimitInfo salePolicyLimitInfo = currentSalePolicyLimitStrategy.onRequestSalePolicyLimitInfos(salePolicyCode);
                if (salePolicyLimitInfo == null) continue;
                salePolicyLimitInfos.add(salePolicyLimitInfo);
            }
            salePolicyVo.setSalePolicyLimitInfos((Set)salePolicyLimitInfos);
        }
        Set<SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>> currentCustomerScopeStrategies = this.findAllBindCustomerScopeStrategy(matchedSalePolicyTempleteRegister);
        Map<String, Set<? extends AbstractSalePolicyCustomerScopeInfo>> salePolicyCustomerInfoObjectMaps = this.customerScopeMerge(salePolicyVo, currentCustomerScopeStrategies);
        salePolicyVo.setCustomerScopeMapping(salePolicyCustomerInfoObjectMaps);
        String templeteCode = salePolicyVo.getTempleteCode();
        SalePolicyTemplete currentSalePolicyTemplete = this.salePolicyTempleteRepository.findByTempleteCode(templeteCode, tenantCode);
        if (currentSalePolicyTemplete != null) {
            String templeteType = currentSalePolicyTemplete.getType();
            salePolicyVo.setTempleteName(currentSalePolicyTemplete.getTempleteName());
            SalePolicyTempleteRegister salePolicyTempleteRegister = this.findSalePolicyTempleteRegister(templeteType);
            if (salePolicyTempleteRegister != null) {
                salePolicyVo.setTempleteRegisterType(templeteType);
                salePolicyVo.setTempleteRegisterTypeDesc(salePolicyTempleteRegister.getTypeDesc());
            }
        }
        return salePolicyVo;
    }

    private Map<String, Set<? extends AbstractSalePolicyCustomerScopeInfo>> customerScopeMerge(SalePolicyVo salePolicyVo, Set<SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>> currentCustomerScopeStrategies) {
        LinkedHashMap salePolicyCustomerInfoObjectMaps = Maps.newLinkedHashMap();
        String salePolicyCode = salePolicyVo.getSalePolicyCode();
        for (SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> salePolicyCustomerScopeStrategy : currentCustomerScopeStrategies) {
            String scopeType = salePolicyCustomerScopeStrategy.getScopeType();
            Set salePolicyCustomerInfos = salePolicyCustomerScopeStrategy.requestSalePolicyCustomerInfo(this.tenantCode, salePolicyCode);
            if (CollectionUtils.isEmpty((Collection)salePolicyCustomerInfos)) continue;
            salePolicyCustomerInfoObjectMaps.put(scopeType, salePolicyCustomerInfos);
        }
        return salePolicyCustomerInfoObjectMaps;
    }

    private SalePolicyTempleteRegister findSalePolicyTempleteRegister(String type) {
        Validate.notBlank((CharSequence)"\u9519\u8bef\u7684\u4f18\u60e0\u653f\u7b56\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u503c");
        Validate.isTrue((!CollectionUtils.isEmpty(this.salePolicyTempleteRegisters) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684SalePolicyTempleteRegister\uff08\u96c6\u5408\uff09\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        SalePolicyTempleteRegister matchedSalePolicyTempleteRegister = null;
        for (SalePolicyTempleteRegister item : this.salePolicyTempleteRegisters) {
            if (!StringUtils.equals((CharSequence)type, (CharSequence)item.getType())) continue;
            matchedSalePolicyTempleteRegister = item;
            break;
        }
        Validate.notNull(matchedSalePolicyTempleteRegister, (String)"\u672a\u5339\u914d\u4efb\u4f55SalePolicyTempleteRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return matchedSalePolicyTempleteRegister;
    }

    private Set<SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>> findAllBindCustomerScopeStrategy(SalePolicyTempleteRegister salePolicyTempleteRegister) {
        Collection salePolicyCustomerScopeStrategyClasses = salePolicyTempleteRegister.getCustomerScopeStrategyClasses();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)salePolicyCustomerScopeStrategyClasses) ? 1 : 0) != 0, (String)"\u8be5\u4f18\u60e0\u653f\u7b56\u5e76\u6ca1\u6709\u6ce8\u518c\u4efb\u4f55\u5ba2\u6237\u8fd4\u56de\u9009\u62e9\u65b9\u5f0f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LinkedHashSet bindableCustomerScopeStrategies = Sets.newLinkedHashSet();
        for (Class salePolicyCustomerScopeStrategyClass : salePolicyCustomerScopeStrategyClasses) {
            try {
                SalePolicyCustomerScopeStrategy currentSalePolicyCustomerScopeStrategy = (SalePolicyCustomerScopeStrategy)this.applicationContext.getBean(salePolicyCustomerScopeStrategyClass);
                String currentScopeType = currentSalePolicyCustomerScopeStrategy.getScopeType();
                Validate.notBlank((CharSequence)currentScopeType, (String)"\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u5ba2\u6237\u8303\u56f4\u7b56\u7565\u6ca1\u6709\u6307\u5b9acode\u4fe1\u606f(%s)\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{salePolicyCustomerScopeStrategyClass.getName()});
                bindableCustomerScopeStrategies.add(currentSalePolicyCustomerScopeStrategy);
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return bindableCustomerScopeStrategies;
    }
}

