/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.sharestrategy;

import com.biz.crm.dms.business.policy.local.context.DefaultCycleExecuteContext;
import com.biz.crm.dms.business.policy.local.context.DefaultPolicyExecuteContext;
import com.biz.crm.dms.business.policy.local.utils.GiftBuildUtils;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.CycleStepResult;
import com.biz.crm.dms.business.policy.sdk.context.GiftResultInfo;
import com.biz.crm.dms.business.policy.sdk.context.ProductPolicyStepResult;
import com.biz.crm.dms.business.policy.sdk.context.StepType;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteShareStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyGiftInquiryStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class GiftShareStrategyWithAmount
implements SalePolicyExecuteShareStrategy {
    @Autowired(required=false)
    private SalePolicyGiftInquiryStrategy salePolicyGiftInquiryStrategy;
    private static final Logger LOGGER = LoggerFactory.getLogger(GiftShareStrategyWithAmount.class);

    public void share(String customer, SalePolicyVo salePolicy, AbstractPolicyExecuteContext abstractPolicyExecuteContext, AbstractCycleExecuteContext abstractCycleExecuteContext, Set<String> productCodes) {
        DefaultPolicyExecuteContext policyExecuteContext = (DefaultPolicyExecuteContext)abstractPolicyExecuteContext;
        DefaultCycleExecuteContext cycleExecuteContext = (DefaultCycleExecuteContext)abstractCycleExecuteContext;
        String salePolicyCode = salePolicy.getSalePolicyCode();
        CycleStepResult cycleLastStepResult = cycleExecuteContext.findLastStepResult();
        Set newGiftResultInfos = cycleLastStepResult.getLastGifts();
        if (newGiftResultInfos == null) {
            newGiftResultInfos = Sets.newLinkedHashSet();
        }
        List<Object> productLastPolicyStepResults = Lists.newArrayList();
        for (String mathcedProductCode : productCodes) {
            ProductPolicyStepResult productPolicyStepResult = policyExecuteContext.findLastProductStepResultByProductCode(mathcedProductCode);
            productLastPolicyStepResults.add(productPolicyStepResult);
            if (productPolicyStepResult != null) continue;
            String errorMsg = String.format("\u9519\u8bef\u7684\u5546\u54c1\u5206\u644a\u573a\u666f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5%s\u4f18\u60e0\u653f\u7b56\u4e2d\u672c\u54c1%s\u7684\u6267\u884c\u60c5\u51b5", salePolicyCode, mathcedProductCode);
            LOGGER.warn(errorMsg);
            return;
        }
        productLastPolicyStepResults = productLastPolicyStepResults.stream().sorted((target, source) -> target.getLastSubtotal().compareTo(source.getLastSubtotal())).collect(Collectors.toList());
        Map giftPriceMapping = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)newGiftResultInfos)) {
            Set giftCodes = newGiftResultInfos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getProductCode())).map(GiftResultInfo::getProductCode).collect(Collectors.toSet());
            giftPriceMapping = this.salePolicyGiftInquiryStrategy.inquiry(customer, giftCodes, salePolicy);
        }
        LinkedHashSet newProductPolicyStepResults = Sets.newLinkedHashSet();
        BigDecimal cycleLastSubtotalAmount = cycleLastStepResult.getLastSubtotalAmount();
        Map<String, Integer> allocatedGiftMapping = newGiftResultInfos.stream().collect(Collectors.toMap(GiftResultInfo::getProductCode, item -> 0));
        for (int index = 0; index < productLastPolicyStepResults.size(); ++index) {
            ProductPolicyStepResult productPolicyStepResult = (ProductPolicyStepResult)productLastPolicyStepResults.get(index);
            BigDecimal lastSubtotal = productPolicyStepResult.getLastSubtotal();
            if (lastSubtotal.compareTo(BigDecimal.ZERO) != 1) continue;
            ProductPolicyStepResult newProductPolicyStepResult = new ProductPolicyStepResult();
            newProductPolicyStepResult.setStepType(salePolicy.getWholePolicy() != false ? StepType.POLICY : StepType.PRODUCT);
            newProductPolicyStepResult.setSalePolicyCode(salePolicy.getSalePolicyCode());
            newProductPolicyStepResult.setExecuteCode(abstractCycleExecuteContext.getExecuteCode());
            newProductPolicyStepResult.setProductCode(productPolicyStepResult.getProductCode());
            newProductPolicyStepResult.setInitNumbers(productPolicyStepResult.getInitNumbers());
            newProductPolicyStepResult.setInitPrices(productPolicyStepResult.getInitPrices());
            newProductPolicyStepResult.setInitSubtotal(productPolicyStepResult.getInitSubtotal());
            List lastProductPolicyStepResult = productPolicyStepResult.getLastGifts();
            newProductPolicyStepResult.setPreGifts(lastProductPolicyStepResult);
            newProductPolicyStepResult.setPrePrices(productPolicyStepResult.getLastPrices());
            newProductPolicyStepResult.setPreSubtotal(productPolicyStepResult.getLastSubtotal());
            newProductPolicyStepResult.setPreSurplusTotalAmount(productPolicyStepResult.getLastSurplusTotalAmount());
            newProductPolicyStepResult.setPreSurplusTotalNumber(productPolicyStepResult.getLastSurplusTotalNumber());
            newProductPolicyStepResult.setLastPrices(productPolicyStepResult.getLastPrices());
            newProductPolicyStepResult.setLastSubtotal(lastSubtotal);
            newProductPolicyStepResult.setLastSurplusTotalAmount(productPolicyStepResult.getLastSurplusTotalAmount());
            newProductPolicyStepResult.setLastSurplusTotalNumber(productPolicyStepResult.getLastSurplusTotalNumber());
            Integer preGiftEnjoyedTotalNumber = productPolicyStepResult.getLastGiftEnjoyedTotalNumber();
            newProductPolicyStepResult.setPreGiftEnjoyedTotalNumber(preGiftEnjoyedTotalNumber);
            BigDecimal preGiftsEnjoyedTotalAmount = productPolicyStepResult.getLastGiftEnjoyedTotalAmount();
            newProductPolicyStepResult.setPreGiftEnjoyedTotalAmount(preGiftsEnjoyedTotalAmount);
            BigDecimal productLastSubtotal = productPolicyStepResult.getLastSubtotal();
            BigDecimal enjoyedGiftsAmount = BigDecimal.ZERO;
            Integer enjoyedGiftsNumber = 0;
            LinkedHashSet shareNewProductGiftInfos = Sets.newLinkedHashSet();
            for (GiftResultInfo resultGiftInfo : newGiftResultInfos) {
                int allocatedGiftNumber;
                Integer quantity = resultGiftInfo.getQuantity();
                String productCode = resultGiftInfo.getProductCode();
                String productName = resultGiftInfo.getProductName();
                PriceModelVo giftPriceModel = (PriceModelVo)giftPriceMapping.get(productCode);
                BigDecimal unitPrice = BigDecimal.ZERO;
                if (giftPriceModel != null && giftPriceModel.getPrice() != null) {
                    unitPrice = giftPriceModel.getPrice().setScale(4, RoundingMode.HALF_UP);
                }
                if (quantity <= 0) continue;
                int shareQuantity = 0;
                if (index + 1 == productLastPolicyStepResults.size()) {
                    allocatedGiftNumber = allocatedGiftMapping.get(productCode);
                    shareQuantity = quantity - allocatedGiftNumber;
                    if (shareQuantity == 0) {
                        continue;
                    }
                } else {
                    shareQuantity = productLastSubtotal.divide(cycleLastSubtotalAmount, 20, RoundingMode.HALF_UP).multiply(new BigDecimal(quantity)).intValue();
                    if (shareQuantity == 0) continue;
                    allocatedGiftNumber = allocatedGiftMapping.get(productCode);
                    allocatedGiftMapping.put(productCode, allocatedGiftNumber + shareQuantity);
                }
                GiftResultInfo productGiftResultInfo = new GiftResultInfo();
                productGiftResultInfo.setProductCode(productCode);
                productGiftResultInfo.setProductName(productName);
                productGiftResultInfo.setQuantity(Integer.valueOf(shareQuantity));
                BigDecimal subtotalAmount = new BigDecimal(shareQuantity).multiply(unitPrice);
                productGiftResultInfo.setSubtotalAmount(subtotalAmount);
                enjoyedGiftsAmount = enjoyedGiftsAmount.add(subtotalAmount);
                enjoyedGiftsNumber = enjoyedGiftsNumber + shareQuantity;
                shareNewProductGiftInfos.add(productGiftResultInfo);
            }
            Set<GiftResultInfo> shareProductGiftResultInfos = GiftBuildUtils.buildGiftResult(lastProductPolicyStepResult, shareNewProductGiftInfos);
            newProductPolicyStepResult.setLastGifts((List)Lists.newArrayList(shareProductGiftResultInfos));
            Integer lastGiftEnjoyedTotalNumber = preGiftEnjoyedTotalNumber + enjoyedGiftsNumber;
            newProductPolicyStepResult.setLastGiftEnjoyedTotalNumber(lastGiftEnjoyedTotalNumber);
            BigDecimal lastGiftsEnjoyedTotalAmount = preGiftsEnjoyedTotalAmount.add(enjoyedGiftsAmount);
            newProductPolicyStepResult.setLastGiftEnjoyedTotalAmount(lastGiftsEnjoyedTotalAmount);
            newProductPolicyStepResults.add(newProductPolicyStepResult);
        }
        policyExecuteContext.addPolicyStepResult(newProductPolicyStepResults);
    }
}

