/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.local.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class AnalyzeExpressionUtils {
    private AnalyzeExpressionUtils() {
    }

    public static Map<Integer, String> analyzeLadderExpressionMapping(String expression) {
        HashMap params = Maps.newHashMap();
        String patternMathed = "[:]{1}[\\w]+\\}";
        Matcher matcher = Pattern.compile(patternMathed).matcher(expression);
        int matcher_start = 0;
        int index = 1;
        while (matcher.find(matcher_start)) {
            matcher_start = matcher.end();
            String group = matcher.group();
            params.put(index++, StringUtils.substring((String)group, (int)1, (int)(group.length() - 1)));
        }
        return params;
    }

    public static Set<String> analyzeLimiterExpressionMapping(String expression) {
        LinkedHashSet paramNames = Sets.newLinkedHashSet();
        String patternMathed = "[:]{1}[\\w]+";
        Matcher matcher = Pattern.compile(patternMathed).matcher(expression);
        int matcher_start = 0;
        while (matcher.find(matcher_start)) {
            matcher_start = matcher.end();
            String groupSubString = matcher.group();
            paramNames.add(StringUtils.substring((String)groupSubString, (int)1));
        }
        return paramNames;
    }
}

